/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.HttpStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HttpPath
extends FilesystemPath {
    protected static L10N L = new L10N("/com/caucho/vfs/messages");
    protected static LruCache cache = new LruCache(1024);
    protected String host;
    protected int port;
    protected String query;
    protected CacheEntry cacheEntry;

    HttpPath(String host, int port) {
        super(null, "/", "/");
        this._root = this;
        this.host = host;
        this.port = port == 0 ? 80 : port;
    }

    HttpPath(FilesystemPath root, String userPath, Map newAttributes, String path, String query) {
        super(root, userPath, path);
        this.host = ((HttpPath)root).host;
        this.port = ((HttpPath)root).port;
        this.query = query;
    }

    public Path lookup(String userPath, Map newAttributes) {
        if (userPath == null) {
            return this._root.fsWalk(this.getPath(), newAttributes, "/");
        }
        int length = userPath.length();
        int colon = userPath.indexOf(58);
        int slash = userPath.indexOf(47);
        if (colon != -1 && (colon < slash || slash == -1)) {
            return super.lookup(userPath, newAttributes);
        }
        if (slash == 0 && length > 1 && userPath.charAt(1) == '/') {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        String newPath = slash == 0 ? HttpPath.normalizePath("/", userPath, 0, '/') : HttpPath.normalizePath(this._pathname, userPath, 0, '/');
        return this._root.fsWalk(userPath, newAttributes, newPath);
    }

    protected Path schemeWalk(String userPath, Map attributes, String uri, int offset) {
        int i;
        int length = uri.length();
        if (length < 2 + offset || uri.charAt(offset) != '/' || uri.charAt(offset + 1) != '/') {
            throw new RuntimeException(L.l("bad scheme in `{0}'", uri));
        }
        CharBuffer buf = CharBuffer.allocate();
        char ch = '\u0000';
        for (i = 2 + offset; i < length && (ch = uri.charAt(i)) != ':' && ch != '/' && ch != '?'; ++i) {
            buf.append(ch);
        }
        String host = buf.close();
        if (host.length() == 0) {
            throw new RuntimeException(L.l("bad host in `{0}'", uri));
        }
        int port = 0;
        if (ch == ':') {
            ++i;
            while (i < length && (ch = uri.charAt(i)) >= '0' && ch <= '9') {
                port = 10 * port + uri.charAt(i) - 48;
                ++i;
            }
        }
        if (port == 0) {
            port = 80;
        }
        HttpPath root = new HttpPath(host, port);
        return root.fsWalk(userPath, attributes, uri.substring(i));
    }

    protected Path fsWalk(String userPath, Map attributes, String uri) {
        String path;
        String query = null;
        int queryIndex = uri.indexOf(63);
        if (queryIndex >= 0) {
            path = uri.substring(0, queryIndex);
            query = uri.substring(queryIndex + 1);
        } else {
            path = uri;
        }
        if (path.length() == 0) {
            path = "/";
        }
        return new HttpPath(this._root, userPath, attributes, path, query);
    }

    public String getScheme() {
        return "http";
    }

    public String getURL() {
        int port = this.getPort();
        return this.getScheme() + "://" + this.getHost() + (port == 80 ? "" : ":" + this.getPort()) + this.getPath() + (this.query == null ? "" : "?" + this.query);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserPath() {
        return this._userPath;
    }

    public String getQuery() {
        return this.query;
    }

    public long getLastModified() {
        return this.getCache().lastModified;
    }

    public long getLength() {
        return this.getCache().length;
    }

    public boolean exists() {
        return this.getCache().lastModified >= 0L;
    }

    public boolean isFile() {
        return !this.getPath().endsWith("/") && this.getCache().lastModified >= 0L;
    }

    public boolean canRead() {
        return this.isFile();
    }

    public boolean isDirectory() {
        return this.getPath().endsWith("/") && this.getCache().lastModified >= 0L;
    }

    public String[] list() throws IOException {
        try {
            HttpStream stream = HttpStream.openReadWrite(this);
            stream.setMethod("PROPFIND");
            stream.setAttribute("Depth", "1");
            WriteStream os = new WriteStream(stream);
            os.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            os.println("<propfind xmlns=\"DAV:\"><prop>");
            os.println("<resourcetype/>");
            os.println("</prop></propfind>");
            os.flush();
            ReadStream is = new ReadStream(stream);
            ListHandler handler = new ListHandler(this.getPath());
            XmlParser parser = new XmlParser();
            parser.setContentHandler(handler);
            parser.parse(is);
            is.close();
            os.close();
            stream.close();
            ArrayList names = handler.getNames();
            String[] list = new String[names.size()];
            names.toArray(list);
            return list;
        }
        catch (Exception e) {
            throw new IOException(L.l("list() is not supported by this server"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry getCache() {
        if (this.cacheEntry == null) {
            LruCache lruCache = cache;
            synchronized (lruCache) {
                this.cacheEntry = (CacheEntry)cache.get(this.getPath());
                if (this.cacheEntry == null) {
                    this.cacheEntry = new CacheEntry();
                    cache.put(this.getPath(), this.cacheEntry);
                }
            }
        }
        long now = Alarm.getCurrentTime();
        CacheEntry cacheEntry = this.cacheEntry;
        synchronized (cacheEntry) {
            try {
                if (this.cacheEntry.expires > now) {
                    return this.cacheEntry;
                }
                HttpStream stream = HttpStream.openRead(this);
                stream.setHead(true);
                String status = (String)stream.getAttribute("status");
                if (status.equals("200")) {
                    String lastModified = (String)stream.getAttribute("last-modified");
                    this.cacheEntry.lastModified = 0L;
                    if (lastModified != null) {
                        QDate date;
                        QDate qDate = date = QDate.getGlobalDate();
                        synchronized (qDate) {
                            this.cacheEntry.lastModified = date.parseDate(lastModified);
                        }
                    }
                    String length = (String)stream.getAttribute("content-length");
                    this.cacheEntry.length = 0L;
                    if (length != null) {
                        this.cacheEntry.length = Integer.parseInt(length);
                    }
                } else {
                    this.cacheEntry.lastModified = -1L;
                }
                this.cacheEntry.expires = now + 5000L;
                stream.close();
                return this.cacheEntry;
            }
            catch (Exception e) {
                this.cacheEntry.lastModified = -1L;
                this.cacheEntry.expires = now + 5000L;
                return this.cacheEntry;
            }
        }
    }

    public StreamImpl openReadImpl() throws IOException {
        return HttpStream.openRead(this);
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        return HttpStream.openReadWrite(this);
    }

    public String toString() {
        return this.getURL();
    }

    public int hashCode() {
        return 65537 * super.hashCode() + 37 * this.host.hashCode() + this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpPath)) {
            return false;
        }
        HttpPath test = (HttpPath)o;
        if (!this.host.equals(test.host)) {
            return false;
        }
        if (this.port != test.port) {
            return false;
        }
        if (this.query != null && !this.query.equals(test.query)) {
            return false;
        }
        return this.query != null || test.query == null;
    }

    static class ListHandler
    extends DefaultHandler {
        String prefix;
        ArrayList names = new ArrayList();
        boolean inHref;

        ListHandler(String prefix) {
            this.prefix = prefix;
        }

        ArrayList getNames() {
            return this.names;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals("href")) {
                this.inHref = true;
            }
        }

        public void characters(char[] data, int offset, int length) throws SAXException {
            if (!this.inHref) {
                return;
            }
            String href = new String(data, offset, length).trim();
            if (!href.startsWith(this.prefix)) {
                return;
            }
            if ((href = href.substring(this.prefix.length())).startsWith("/")) {
                href = href.substring(1);
            }
            int p = href.indexOf(47);
            if (href.equals("") || p == 0) {
                return;
            }
            if (p < 0) {
                this.names.add(href);
            } else {
                this.names.add(href.substring(0, p));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("href")) {
                this.inHref = false;
            }
        }
    }

    static class CacheEntry {
        long lastModified;
        long length;
        boolean canRead;
        long expires;

        CacheEntry() {
        }
    }
}

