/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharSegment;
import com.caucho.vfs.EnclosedWriteStream;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.VfsWriteObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;

public class WriteStream
extends OutputStream {
    private static byte[] lfBytes = new byte[]{10};
    private static byte[] crBytes = new byte[]{13};
    private static byte[] crlfBytes = new byte[]{13, 10};
    private static String sysNewline = CauchoSystem.getNewlineString();
    private static byte[] sysNewlineBytes = sysNewline.getBytes();
    private TempBuffer tempWrite;
    private byte[] write_buffer;
    private int write_length;
    private StreamImpl source;
    private char[] chars;
    private byte[] bytes;
    private Writer writeEncoding;
    private String writeEncodingName;
    private boolean flushOnNewline;
    private boolean disableClose;
    private boolean disableFlush;
    private boolean reuseBuffer;
    private StreamWriter writer;
    private PrintWriter printWriter;
    private String newline = "\n";
    private byte[] newlineBytes = lfBytes;
    private int writePrefix;

    public WriteStream() {
    }

    public WriteStream(StreamImpl source) {
        this.init(source);
    }

    public void init(StreamImpl source) {
        this.disableClose = false;
        if (this.source != null && this.source != source) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this.tempWrite == null) {
            this.tempWrite = TempBuffer.allocate();
            this.write_buffer = this.tempWrite.buf;
        }
        this.source = source;
        this.write_length = 0;
        this.flushOnNewline = source.getFlushOnNewline();
        this.newline = sysNewline;
        this.newlineBytes = sysNewlineBytes;
        this.printWriter = null;
        this.writePrefix = 0;
        this.writeEncoding = null;
        this.writeEncodingName = "ISO-8859-1";
    }

    public StreamImpl getSource() {
        return this.source;
    }

    public void pushFilter(StreamFilter filter) {
        filter.init(this.source);
        this.source = filter;
    }

    public boolean canWrite() {
        return this.source != null && this.source.canWrite();
    }

    public void clearWrite() {
        this.write_length = this.writePrefix;
        if (this.source != null) {
            this.source.clearWrite();
        }
    }

    public void setWritePrefix(int prefix) {
        if (this.write_length > this.writePrefix) {
            throw new IllegalStateException();
        }
        this.write_length = this.writePrefix = prefix;
    }

    public void setReuseBuffer(boolean reuse) {
        this.reuseBuffer = reuse;
    }

    public byte[] getBuffer() {
        return this.write_buffer;
    }

    public int getBufferOffset() {
        return this.write_length;
    }

    public void setBufferOffset(int offset) {
        this.write_length = offset;
    }

    public int getRemaining() {
        if (this.source == null) {
            return 0;
        }
        return this.write_buffer.length - this.write_length;
    }

    public void write(int ch) throws IOException {
        if (this.source == null) {
            return;
        }
        if (this.write_buffer.length <= this.write_length) {
            int len = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, len, false);
        }
        this.write_buffer[this.write_length++] = (byte)ch;
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        byte[] buffer = this.write_buffer;
        if (this.source == null) {
            return;
        }
        int bufferLength = buffer.length;
        int writeLength = this.write_length;
        if (bufferLength <= length && this.writePrefix == 0) {
            this.source.write(buffer, 0, writeLength, false);
            this.write_length = 0;
            this.source.write(buf, offset, length, false);
            return;
        }
        while (length > 0) {
            int sublen = bufferLength - writeLength;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buf, offset, buffer, writeLength, sublen);
            offset += sublen;
            length -= sublen;
            if (bufferLength > (writeLength += sublen)) continue;
            int len = writeLength;
            writeLength = this.writePrefix;
            this.source.write(buffer, 0, len, false);
        }
        this.write_length = writeLength;
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void flush() throws IOException {
        if (this.disableFlush || this.source == null) {
            return;
        }
        if (this.write_length > this.writePrefix) {
            int len = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, len, false);
        }
        if (this.source != null) {
            this.source.flush();
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName;
        if (this.source instanceof ReaderWriterStream) {
            encoding = "UTF-8";
        }
        if ((mimeName = Encoding.getMimeName(encoding)) != null && mimeName.equals(this.writeEncodingName)) {
            return;
        }
        this.writeEncoding = Encoding.getWriteEncoding(this, encoding);
        this.writeEncodingName = mimeName;
    }

    public void setLocale(Locale locale) throws UnsupportedEncodingException {
        if (this.writeEncoding == null && locale != null) {
            this.setEncoding(Encoding.getMimeName(locale));
        }
    }

    public String getEncoding() {
        if (this.source instanceof ReaderWriterStream) {
            return ((ReaderWriterStream)this.source).getEncoding();
        }
        return this.writeEncodingName;
    }

    public String getJavaEncoding() {
        return Encoding.getJavaName(this.getEncoding());
    }

    public void setFlushOnNewline(boolean flushOnNewline) {
        this.flushOnNewline = flushOnNewline;
    }

    public String getNewlineString() {
        return this.newline;
    }

    public void setNewlineString(String newline) {
        if (newline != null) {
            if (this.newline != newline && !newline.equals(this.newline)) {
                this.newlineBytes = newline == "\n" || newline.equals("\n") ? lfBytes : (newline == "\r\n" || newline.equals("\r\n") ? crlfBytes : (newline == "\r" || newline.equals("\r") ? crBytes : newline.getBytes()));
            }
            this.newline = newline;
        }
    }

    public final void print(char[] buffer, int offset, int length) throws IOException {
        byte[] writeBuffer = this.write_buffer;
        if (this.source == null) {
            return;
        }
        if (this.writeEncoding != null) {
            this.disableFlush = true;
            this.writeEncoding.write(buffer, offset, length);
            this.writeEncoding.flush();
            this.disableFlush = false;
            return;
        }
        while (length > 0) {
            int writeLength = this.write_length;
            int sublen = writeBuffer.length - writeLength;
            if (sublen <= 0) {
                this.source.write(writeBuffer, 0, writeLength, false);
                writeLength = this.writePrefix;
                sublen = writeBuffer.length - writeLength;
            }
            if (length < sublen) {
                sublen = length;
            }
            for (int i = sublen - 1; i >= 0; --i) {
                writeBuffer[writeLength + i] = (byte)buffer[offset + i];
            }
            this.write_length = writeLength + sublen;
            offset += sublen;
            length -= sublen;
        }
    }

    public final void print(char ch) throws IOException {
        if (this.writeEncoding != null) {
            this.disableFlush = true;
            this.writeEncoding.write(ch);
            this.writeEncoding.flush();
            this.disableFlush = false;
            return;
        }
        this.write((byte)ch);
    }

    public final void print(char[] buffer) throws IOException {
        this.print(buffer, 0, buffer.length);
    }

    public final void print(CharSegment segment) throws IOException {
        this.print(segment.getBuffer(), segment.getOffset(), segment.getLength());
    }

    public final void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int length = string.length();
        int offset = 0;
        while (length > 0) {
            int sublen;
            int n = sublen = length < 1024 ? length : 1024;
            if (this.chars == null || this.chars.length < sublen) {
                this.chars = new char[sublen < 32 ? 32 : sublen];
            }
            string.getChars(offset, offset + sublen, this.chars, 0);
            this.print(this.chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void print(String string, int offset, int length) throws IOException {
        if (string == null) {
            string = "null";
        }
        while (length > 0) {
            int sublen;
            int n = sublen = length < 1024 ? length : 1024;
            if (this.chars == null || this.chars.length < sublen) {
                this.chars = new char[sublen < 32 ? 32 : sublen];
            }
            string.getChars(offset, offset + sublen, this.chars, 0);
            this.print(this.chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void print(boolean b) throws IOException {
        this.print(b ? "true" : "false");
    }

    public final void print(int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (i < 0) {
            this.write(45);
            i = -i;
        } else if (i < 9) {
            this.write(48 + i);
            return;
        }
        int length = 0;
        int exp = 10;
        if (i >= 1000000000) {
            length = 9;
        } else {
            while (i >= exp) {
                exp = 10 * exp;
                ++length;
            }
        }
        byte[] buffer = this.write_buffer;
        int writeLength = this.write_length;
        if (writeLength + length < buffer.length) {
            this.write_length = (writeLength += length) + 1;
            for (int j = 0; j <= length; ++j) {
                buffer[writeLength - j] = (byte)(i % 10 + 48);
                i /= 10;
            }
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        int j = 31;
        while (i > 0) {
            this.bytes[--j] = (byte)(i % 10 + 48);
            i /= 10;
        }
        this.write(this.bytes, j, 31 - j);
    }

    public final void print(long i) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.print("-9223372036854775808");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (i < 0L) {
            this.write(45);
            i = -i;
        } else if (i == 0L) {
            this.write(48);
            return;
        }
        int j = 31;
        while (i > 0L) {
            this.bytes[--j] = (byte)(i % 10L + 48L);
            i /= 10L;
        }
        this.write(this.bytes, j, 31 - j);
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        if (o == null) {
            this.print("null");
        } else if (o instanceof VfsWriteObject) {
            ((VfsWriteObject)o).print(this);
        } else {
            this.print(o.toString());
        }
    }

    public final void println() throws IOException {
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(char[] buf, int offset, int length) throws IOException {
        this.print(buf, offset, length);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(String string) throws IOException {
        this.print(string);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(boolean b) throws IOException {
        this.println(b ? "true" : "false");
    }

    public final void println(char ch) throws IOException {
        this.write(ch);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(int i) throws IOException {
        this.print(i);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(long l) throws IOException {
        this.print(l);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(float f) throws IOException {
        this.println(String.valueOf(f));
    }

    public final void println(double d) throws IOException {
        this.println(String.valueOf(d));
    }

    public final void println(Object o) throws IOException {
        if (o == null) {
            this.println("null");
        } else {
            this.println(o.toString());
        }
    }

    public PrintWriter getPrintWriter() {
        if (this.writer == null) {
            this.writer = new StreamWriter();
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.writer);
        }
        return this.printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(String string) {
        try {
            WriteStream writeStream = this;
            synchronized (writeStream) {
                this.println(string);
                this.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Throwable exn) {
        try {
            PrintWriter out = this.getPrintWriter();
            WriteStream writeStream = this;
            synchronized (writeStream) {
                if (exn != null) {
                    exn.printStackTrace(out);
                    this.flush();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void writeStream(InputStream source) throws IOException {
        int len;
        int tmplen;
        if (source == null) {
            return;
        }
        int length = this.write_buffer.length;
        if (this.write_length >= length) {
            tmplen = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, tmplen, false);
        }
        while ((len = source.read(this.write_buffer, this.write_length, length - this.write_length)) >= 0) {
            this.write_length += len;
            if (this.write_length < length) continue;
            tmplen = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, tmplen, false);
        }
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public int writeStream(InputStream source, int totalLength) throws IOException {
        if (source == null) {
            return totalLength;
        }
        int length = this.write_buffer.length;
        if (length <= this.write_length) {
            int tmplen = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, tmplen, false);
        }
        int readLength = 0;
        while (totalLength > 0) {
            int sublen = length - this.write_length;
            if (totalLength < sublen) {
                sublen = totalLength;
            }
            if ((sublen = source.read(this.write_buffer, this.write_length, sublen)) < 0) break;
            this.write_length += sublen;
            readLength += sublen;
            totalLength -= sublen;
            if (length > this.write_length) continue;
            int tmplen = this.write_length;
            this.write_length = this.writePrefix;
            this.source.write(this.write_buffer, 0, tmplen, false);
        }
        if (this.flushOnNewline) {
            this.flush();
        }
        return readLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(Path path) throws IOException {
        ReadStream is = path.openRead();
        try {
            if (is != null) {
                this.writeStream(is);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public void setDisableClose(boolean disableClose) {
        this.disableClose = disableClose;
    }

    public boolean getDisableClose() {
        return this.disableClose;
    }

    public final boolean isClosed() {
        return this.source != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        StreamImpl s2;
        block13: {
            Writer writer2;
            try {
                if (this.write_length > this.writePrefix) {
                    int len = this.write_length;
                    this.write_length = this.writePrefix;
                    if (this.source != null) {
                        this.source.write(this.write_buffer, 0, len, true);
                    }
                }
                Object var3_2 = null;
                if (this.disableClose) {
                    this.printWriter = null;
                    return;
                }
                s2 = this.source;
                this.source = null;
                if (this.writeEncoding == null) break block13;
                writer2 = this.writeEncoding;
                this.writeEncoding = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.disableClose) {
                    this.printWriter = null;
                    return;
                }
                StreamImpl s2 = this.source;
                this.source = null;
                if (this.writeEncoding != null) {
                    Writer writer2 = this.writeEncoding;
                    this.writeEncoding = null;
                    writer2.close();
                }
                if (!this.reuseBuffer) {
                    if (this.tempWrite != null) {
                        TempBuffer.free(this.tempWrite);
                    }
                    this.tempWrite = null;
                    this.write_buffer = null;
                }
                if (s2 != null) {
                    s2.close();
                }
                throw throwable;
            }
            writer2.close();
        }
        if (!this.reuseBuffer) {
            if (this.tempWrite != null) {
                TempBuffer.free(this.tempWrite);
            }
            this.tempWrite = null;
            this.write_buffer = null;
        }
        if (s2 != null) {
            s2.close();
        }
    }

    public final void free() {
        this.source = null;
        if (this.tempWrite != null) {
            TempBuffer.free(this.tempWrite);
        }
        this.tempWrite = null;
        this.write_buffer = null;
    }

    public Object getAttribute(String name) throws IOException {
        return this.source.getAttribute(name);
    }

    public void setAttribute(String name, Object value) throws IOException {
        this.source.setAttribute(name, value);
    }

    public void removeAttribute(String name) throws IOException {
        this.source.removeAttribute(name);
    }

    public Iterator getAttributeNames() throws IOException {
        return this.source.getAttributeNames();
    }

    public Path getPath() {
        if (this.source != null) {
            return this.source.getPath();
        }
        return null;
    }

    public String getUserPath() {
        return this.source.getPath().getUserPath();
    }

    public void setPath(Path path) {
        this.source.setPath(path);
    }

    private class StreamWriter
    extends Writer
    implements EnclosedWriteStream {
        private StreamWriter() {
        }

        public final void write(char ch) throws IOException {
            WriteStream.this.print(ch);
        }

        public final void write(char[] buffer, int offset, int length) throws IOException {
            WriteStream.this.print(buffer, offset, length);
        }

        public final void write(char[] buffer) throws IOException {
            WriteStream.this.print(buffer, 0, buffer.length);
        }

        public final void write(String string) throws IOException {
            WriteStream.this.print(string);
        }

        public final void write(String string, int off, int len) throws IOException {
            WriteStream.this.print(string, off, len);
        }

        public final void flush() throws IOException {
            WriteStream.this.flush();
        }

        public final void close() throws IOException {
            WriteStream.this.printWriter = null;
        }

        public WriteStream getWriteStream() {
            return WriteStream.this;
        }
    }
}

