/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static HashMap splitNameList(String name) throws IOException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        CharBuffer cb = new CharBuffer();
        int length = name.length();
        int i = 0;
        char ch = '\u0000';
        while (i < length) {
            while (i < length && XmlChar.isWhitespace(ch = name.charAt(i))) {
                ++i;
            }
            if (i < length && !XmlChar.isNameStart(ch)) {
                throw new IOException("expected name at " + (char)ch);
            }
            cb.clear();
            while (i < length && XmlChar.isNameChar(ch)) {
                cb.append(ch);
                ch = name.charAt(++i);
            }
            String key = cb.toString();
            cb.clear();
            while (i < length && XmlChar.isWhitespace(ch = name.charAt(i))) {
                ++i;
            }
            if (ch != '=') {
                attrs.put(key, "");
                continue;
            }
            while (++i < length && XmlChar.isWhitespace(ch = name.charAt(i))) {
            }
            if (i >= length) break;
            cb.clear();
            if (ch == '\'') {
                while (++i < length && (ch = name.charAt(i)) != '\'') {
                    cb.append(ch);
                }
                ++i;
            } else if (ch == '\"') {
                while (++i < length && (ch = name.charAt(i)) != '\"') {
                    cb.append(ch);
                }
                ++i;
            } else if (XmlChar.isNameChar(ch)) {
                cb.append(ch);
                while (++i < length && XmlChar.isNameChar(ch = name.charAt(i))) {
                    cb.append(ch);
                }
            } else {
                throw new IOException("unexpected");
            }
            attrs.put(key, cb.toString());
        }
        return attrs;
    }

    public static String getPIAttribute(String pi, String key) {
        CharBuffer nameBuf = new CharBuffer();
        CharBuffer valueBuf = new CharBuffer();
        int i = 0;
        int length = pi.length();
        while (i < length) {
            String name;
            char ch = '\u0000';
            while (i < length && XmlChar.isWhitespace(ch = pi.charAt(i))) {
                ++i;
            }
            nameBuf.clear();
            while (i < length && XmlChar.isNameChar(ch = pi.charAt(i))) {
                nameBuf.append(ch);
                ++i;
            }
            while (i < length && XmlChar.isWhitespace(ch = pi.charAt(i))) {
                ++i;
            }
            if (i < length && ch != '=') {
                if (nameBuf.length() == 0) {
                    return null;
                }
                if (!nameBuf.toString().equals(key)) continue;
                return nameBuf.toString();
            }
            ++i;
            while (i < length && XmlChar.isWhitespace(ch = pi.charAt(i))) {
                ++i;
            }
            valueBuf.clear();
            if (ch == '\'') {
                ++i;
                while (i < length && (ch = pi.charAt(i)) != '\'') {
                    valueBuf.append(ch);
                    ++i;
                }
                ++i;
            } else if (ch == '\"') {
                ++i;
                while (i < length && (ch = pi.charAt(i)) != '\"') {
                    valueBuf.append(ch);
                    ++i;
                }
                ++i;
            } else if (XmlChar.isNameChar(ch)) {
                while (i < length && XmlChar.isNameChar(ch = pi.charAt(i))) {
                    valueBuf.append(ch);
                    ++i;
                }
            } else {
                return null;
            }
            if (!(name = nameBuf.toString()).equals(key)) continue;
            return valueBuf.toString();
        }
        return null;
    }

    public static Node getNext(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getFirstChild() != null) {
            return node.getFirstChild();
        }
        while (node != null) {
            if (node.getNextSibling() != null) {
                return node.getNextSibling();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static Node getPrevious(Node node) {
        if (node == null) {
            return null;
        }
        Node previous = node.getPreviousSibling();
        if (previous != null) {
            while (previous.getLastChild() != null) {
                previous = previous.getLastChild();
            }
            return previous;
        }
        return node.getParentNode();
    }

    public static String textValue(Node node) {
        if (node instanceof Element || node instanceof DocumentFragment) {
            String s = null;
            CharBuffer cb = null;
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                String value = null;
                if (child instanceof Element || child instanceof Document) {
                    if (cb == null) {
                        cb = CharBuffer.allocate();
                    }
                    if (s != null) {
                        cb.append(s);
                    }
                    s = null;
                    XmlUtil.textValue(cb, child);
                    continue;
                }
                value = child.getNodeValue();
                if (value == null || value == "") continue;
                if (cb != null) {
                    cb.append(value);
                    continue;
                }
                if (s == null && s != "") {
                    s = value;
                    continue;
                }
                cb = CharBuffer.allocate();
                cb.append(s);
                cb.append(value);
                s = null;
            }
            if (s != null) {
                return s;
            }
            if (cb != null) {
                return cb.close();
            }
            return "";
        }
        return node.getNodeValue();
    }

    public static void textValue(CharBuffer cb, Node node) {
        if (node instanceof Element || node instanceof DocumentFragment) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                XmlUtil.textValue(cb, child);
            }
        } else {
            cb.append(node.getNodeValue());
        }
    }

    public static void toSAX(Node node, ContentHandler handler) throws SAXException {
        while (node != null) {
            if (node instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                handler.processingInstruction(pi.getNodeName(), pi.getData());
            } else if (node instanceof DocumentFragment) {
                XmlUtil.toSAX(node.getFirstChild(), handler);
            }
            node = node.getNextSibling();
        }
    }
}

