/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.transform.NodeTransformer;
import com.caucho.transform.SAXTransformer;
import com.caucho.transform.StreamTransformer;
import com.caucho.transform.StringTransformer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xml.XMLWriter;
import com.caucho.xsl.CauchoStylesheet;
import com.caucho.xsl.NodeTransformerImpl;
import com.caucho.xsl.SAXTransformerImpl;
import com.caucho.xsl.StreamTransformerImpl;
import com.caucho.xsl.StringTransformerImpl;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Node;

public abstract class AbstractStylesheet
implements CauchoStylesheet,
Templates {
    private Path path;
    private ArrayList depends = new ArrayList();
    private ArrayList cacheDepends = new ArrayList();
    private ArrayList globalParameters;
    protected Properties output = new Properties();
    protected AbstractStylesheet stylesheet;
    protected String errorPage;
    protected URIResolver uriResolver;
    boolean escapeEntities = true;

    public void init(Path path) throws Exception {
        this.path = path;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    protected void copy(AbstractStylesheet stylesheet) {
        stylesheet.stylesheet = this;
        stylesheet.depends = (ArrayList)this.depends.clone();
        stylesheet.output = (Properties)this.output.clone();
        stylesheet.errorPage = this.errorPage;
        stylesheet.globalParameters = this.globalParameters;
        stylesheet.path = this.path;
        stylesheet.uriResolver = this.uriResolver;
    }

    public Object clone() {
        try {
            AbstractStylesheet instance = (AbstractStylesheet)this.getClass().newInstance();
            this.copy(instance);
            if (this.path != null) {
                instance.init(this.path);
            } else {
                instance.init(Vfs.lookup("anonymous.xsl"));
            }
            return instance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Properties getOutputProperties() {
        return this.output;
    }

    public Path getPath() {
        return this.path;
    }

    public Object getProperty(String name) {
        if (name.equals("caucho.depends")) {
            return this.depends;
        }
        if (name.equals("caucho.cache.depends")) {
            return this.cacheDepends;
        }
        if (name.equals("caucho.path")) {
            return this.path;
        }
        if (name.equals("caucho.global.param")) {
            return this.globalParameters;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("caucho.global.param")) {
            this.globalParameters = (ArrayList)value;
        }
    }

    public Transformer newTransformer() {
        return new TransformerImpl((StylesheetImpl)this.clone());
    }

    public StringTransformer newStringTransformer() {
        return new StringTransformerImpl((StylesheetImpl)this.clone());
    }

    public StreamTransformer newStreamTransformer() {
        return new StreamTransformerImpl((StylesheetImpl)this.clone());
    }

    public NodeTransformer newNodeTransformer() {
        return new NodeTransformerImpl((StylesheetImpl)this.clone());
    }

    public SAXTransformer newSAXTransformer() {
        return new SAXTransformerImpl((StylesheetImpl)this.clone());
    }

    public boolean isModified() {
        for (int i = 0; i < this.depends.size(); ++i) {
            Depend depend = (Depend)this.depends.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    protected void addDepend(Path path) {
        Depend depend = new Depend(path, path.getLastModified(), path.getLength());
        depend.setRequireSource(true);
        if (!this.depends.contains(depend)) {
            this.depends.add(depend);
        }
    }

    protected void addDepend(Path path, long lastModified, long length) {
        Depend depend = new Depend(path, lastModified, length);
        depend.setRequireSource(true);
        if (!this.depends.contains(depend)) {
            this.depends.add(depend);
        }
    }

    public ArrayList getDepends() {
        return this.depends;
    }

    protected void addCacheDepend(String path) {
        this.cacheDepends.add(path);
    }

    public ArrayList getCacheDepends() {
        return this.cacheDepends;
    }

    public abstract void transform(Node var1, XMLWriter var2, TransformerImpl var3) throws Exception;
}

