/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QElement;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XslWriter
extends Writer {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/writer");
    static L10N L = new L10N("com/caucho/xsl/messages");
    private static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    private XMLWriter xmlWriter;
    String filename;
    int line;
    int tailLine;
    private IntArray flags = new IntArray();
    private CharBuffer text = new CharBuffer();
    private String elementName;
    private String attributeURL;
    private String attributePrefix;
    private String attributeLocalName;
    private String attributeName;
    private ArrayList depends = new ArrayList();
    private boolean isCacheable = true;
    private boolean disableEscaping;
    private boolean generateLocation;
    private DOMBuilder domBuilder;
    private Document document;
    private HashMap attributes;
    private StylesheetImpl stylesheet;
    private TransformerImpl transformer;
    private HashMap cdataElements;
    private boolean isCdata;
    private HashMap namespaces;
    private ArrayList topNamespaces;
    private ArrayList elementStack;
    private int depth;

    XslWriter(HashMap env, StylesheetImpl stylesheet, TransformerImpl transformer) {
        this.stylesheet = stylesheet;
        this.transformer = transformer;
        ArrayList cdata = stylesheet.getOutputFormat().getCdataSectionElements();
        if (cdata != null) {
            this.cdataElements = new HashMap();
            for (int i = 0; i < cdata.size(); ++i) {
                String element = (String)cdata.get(i);
                this.cdataElements.put(element, element);
            }
        }
    }

    void init(XMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.namespaces = new HashMap();
        this.topNamespaces = new ArrayList();
        this.elementStack = new ArrayList();
        this.document = null;
    }

    public TransformerImpl getTransformer() {
        return this.transformer;
    }

    boolean isCacheable() {
        return this.isCacheable;
    }

    ArrayList getDepends() {
        return this.depends;
    }

    public void setNotCacheable() {
        this.isCacheable = false;
    }

    public void addCacheDepend(Path path) {
        this.transformer.addCacheDepend(path);
    }

    public boolean isFlagFirst(int id) {
        while (this.flags.size() <= id) {
            this.flags.add(0);
        }
        int value = this.flags.get(id);
        this.flags.set(id, 1);
        return value == 0;
    }

    public void write(int ch) {
        this.text.append((char)ch);
    }

    public void write(byte[] buf, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write(buf[offset + i]);
        }
    }

    public void write(char[] buf, int offset, int length) {
        this.text.append(buf, offset, length);
    }

    public void print(String string) {
        if (string == null) {
            this.text.append("null");
            return;
        }
        this.text.append(string);
    }

    public void print(boolean b) {
        this.text.append(b);
    }

    public void print(char ch) {
        this.text.append(ch);
    }

    public void print(int i) {
        this.text.append(i);
    }

    public void print(long l) {
        this.text.append(l);
    }

    public void print(float f) {
        this.text.append(f);
    }

    public void print(double d) {
        this.text.append(d);
    }

    public void print(Object o) {
        this.text.append(o);
    }

    public void println() {
        this.text.append('\n');
        ++this.tailLine;
    }

    public void println(boolean b) {
        this.text.append(b);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(char ch) {
        this.print(ch);
        this.println();
    }

    public void println(int i) {
        this.text.append(i);
        this.println();
    }

    public void println(long l) {
        this.text.append(l);
        this.println();
    }

    public void println(double d) {
        this.text.append(d);
        this.println();
    }

    public void println(float f) {
        this.text.append(f);
        this.println();
    }

    public void println(Object o) {
        this.text.append(o);
        this.println();
    }

    public void flush() {
    }

    public void close() throws IOException {
        try {
            this.popText();
            this.xmlWriter.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public boolean getDisableEscaping() {
        return this.disableEscaping;
    }

    public boolean disableEscaping(boolean disable) throws IOException, SAXException {
        if (disable != this.disableEscaping) {
            this.popText();
            this.xmlWriter.setEscapeText(!disable);
        }
        boolean old = this.disableEscaping;
        this.disableEscaping = disable;
        return old;
    }

    public void setLocation(String filename, int line) throws IOException, SAXException {
        if (filename == null || !filename.equals(this.filename) || line != this.tailLine) {
            this.popText();
        }
        this.filename = filename;
        this.line = line;
        this.tailLine = line;
    }

    public void pushElement(String name) throws IOException, SAXException {
        this.popText();
        this.xmlWriter.setLocation(this.filename, this.line, 0);
        int p = name.lastIndexOf(58);
        String local = p > 0 ? name.substring(p + 1) : name;
        this.startElement(null, null, local, name);
    }

    public void pushElement(String name, NamespaceContext namespace) throws IOException, SAXException {
        this.popText();
        this.xmlWriter.setLocation(this.filename, this.line, 0);
        int p = name.indexOf(58);
        if (p <= 0) {
            this.startElement(null, null, name, name);
            return;
        }
        String prefix = name.substring(0, p);
        String url = NamespaceContext.find(namespace, prefix);
        if (url != null) {
            this.startElement(url, prefix, name.substring(p + 1), name);
        } else {
            this.startElement(null, null, name, name);
        }
    }

    public void pushElementNs(String name, String url) throws IOException, SAXException {
        this.popText();
        this.xmlWriter.setLocation(this.filename, this.line, 0);
        int p = name.indexOf(58);
        if (p <= 0) {
            this.startElement(url, "", name, name);
            return;
        }
        String prefix = name.substring(0, p);
        String local = name.substring(p + 1);
        this.startElement(url, prefix, local, name);
    }

    public void pushElement(String url, String prefix, String local, String name) throws IOException, SAXException {
        this.popText();
        this.xmlWriter.setLocation(this.filename, this.line, 0);
        if (url != null && url.startsWith("quote:")) {
            url = url.substring(6);
        }
        this.startElement(url, prefix, local, name);
    }

    public void pushAttribute(String name) throws IOException, SAXException {
        this.popText();
        this.attributeURL = null;
        this.attributePrefix = null;
        this.attributeLocalName = null;
        this.attributeName = name;
    }

    public void pushAttribute(String name, NamespaceContext namespace) throws IOException, SAXException {
        String url;
        this.popText();
        int p = name.indexOf(58);
        String prefix = "";
        if (p > 0) {
            prefix = name.substring(0, p);
        }
        if ((url = NamespaceContext.find(namespace, prefix)) != null) {
            this.attributeURL = url;
            this.attributePrefix = prefix;
            this.attributeLocalName = name.substring(p + 1);
            this.attributeName = name;
        } else {
            this.attributeURL = null;
            this.attributePrefix = null;
            this.attributeLocalName = null;
            this.attributeName = name;
        }
    }

    public void pushAttributeNs(String name, String url) throws IOException, SAXException {
        this.popText();
        int p = name.indexOf(58);
        String prefix = "";
        String local = name;
        if (p > 0) {
            prefix = name.substring(0, p);
            local = name.substring(p + 1);
        }
        this.attributeURL = url;
        this.attributePrefix = prefix;
        this.attributeLocalName = local;
        this.attributeName = name;
    }

    public void pushAttribute(String prefix, String local, String url) throws IOException, SAXException {
        this.popText();
        if (url != null && url.startsWith("quote:")) {
            url = url.substring(6);
        }
        this.attributeURL = url;
        this.attributePrefix = prefix;
        this.attributeLocalName = local;
        this.attributeName = prefix != null && !prefix.equals("") ? prefix + ":" + local : local;
    }

    public void popAttribute() throws IOException, SAXException {
        this.attribute(this.attributeURL, this.attributePrefix, this.attributeLocalName, this.attributeName, this.text.toString());
        this.text.clear();
        this.attributeName = null;
    }

    public void setAttribute(String name, String value) throws IOException, SAXException {
        this.attribute(null, null, name, name, value);
    }

    public void pushCopy(Node copyNode) throws IOException, SAXException {
        this.popText();
        switch (copyNode.getNodeType()) {
            case 2: {
                QAbstractNode oldNode = (QAbstractNode)copyNode;
                this.attribute(oldNode.getNamespaceURI(), oldNode.getPrefix(), oldNode.getLocalName(), oldNode.getNodeName(), oldNode.getNodeValue());
                break;
            }
            case 9: {
                return;
            }
            case 1: {
                QElement oldElt = (QElement)copyNode;
                if (this.generateLocation) {
                    this.xmlWriter.setLocation(oldElt.getFilename(), oldElt.getLine(), 0);
                }
                this.startElement(oldElt.getNamespaceURI(), oldElt.getPrefix(), oldElt.getLocalName(), oldElt.getNodeName());
                break;
            }
            case 8: {
                this.xmlWriter.comment(((Comment)copyNode).getData());
                break;
            }
            case 3: {
                if (this.generateLocation) {
                    this.xmlWriter.setLocation(((QAbstractNode)copyNode).getFilename(), ((QAbstractNode)copyNode).getLine(), 0);
                }
                this.text.append(((Text)copyNode).getData());
                break;
            }
            case 7: {
                ProcessingInstruction oldPi = (ProcessingInstruction)copyNode;
                this.xmlWriter.processingInstruction(oldPi.getNodeName(), oldPi.getNodeValue());
            }
        }
    }

    public void popCopy(Node copyNode) throws IOException, SAXException {
        if (copyNode.getNodeType() == 1) {
            this.popText();
            this.popElement();
        }
    }

    public void pushPi() throws IOException, SAXException {
        this.popText();
    }

    public void popPi(String name) throws IOException, SAXException {
        this.xmlWriter.processingInstruction(name, this.text.toString());
        this.text.clear();
    }

    public void pushComment() throws IOException, SAXException {
        this.popText();
    }

    public void popComment() throws IOException, SAXException {
        this.xmlWriter.comment(this.text.toString());
        this.text.clear();
    }

    public XMLWriter pushFragment() throws IOException, SAXException {
        this.popText();
        DOMBuilder domBuilder = new DOMBuilder();
        if (this.document == null) {
            this.document = Xml.createDocument();
        }
        domBuilder.init(this.document.createDocumentFragment());
        XMLWriter oldWriter = this.xmlWriter;
        this.xmlWriter = domBuilder;
        return oldWriter;
    }

    public Node popFragment(XMLWriter oldWriter) throws IOException, SAXException {
        this.popText();
        DOMBuilder domBuilder = (DOMBuilder)this.xmlWriter;
        this.xmlWriter = oldWriter;
        domBuilder.endDocument();
        Node node = domBuilder.getNode();
        return node;
    }

    public void valueOf(Object node) throws IOException, SAXException {
        if (node == null) {
            return;
        }
        if (node instanceof ArrayList) {
            ArrayList list = (ArrayList)node;
            if (list.size() > 0) {
                this.valueOf(list.get(0));
            }
        } else if (node instanceof Iterator) {
            Iterator list = (Iterator)node;
            this.valueOf(list.next());
        } else if (node instanceof Element || node instanceof DocumentFragment) {
            Node elt = (Node)node;
            for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.elementValueOf(child);
            }
        } else if (node instanceof Text) {
            String data = ((Text)node).getNodeValue();
            for (int i = 0; i < data.length(); ++i) {
                if (XmlChar.isWhitespace(data.charAt(i))) continue;
                this.print(data);
                return;
            }
            if (!this.stylesheet.stripSpaces(((Node)node).getParentNode())) {
                this.print(data);
            }
        } else if (node instanceof Node) {
            this.print(((QAbstractNode)node).getNodeValue());
        } else if (node instanceof Double) {
            Double d = (Double)node;
            double dValue = d;
            if ((double)((int)dValue) == dValue) {
                this.print((int)dValue);
            } else {
                this.print(dValue);
            }
        } else {
            this.print(node);
        }
    }

    private void elementValueOf(Node node) throws IOException, SAXException {
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            Element elt = (Element)node;
            for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.elementValueOf(child);
            }
        } else if (node instanceof Text) {
            String data = ((Text)node).getNodeValue();
            for (int i = 0; i < data.length(); ++i) {
                if (XmlChar.isWhitespace(data.charAt(i))) continue;
                this.print(data);
                return;
            }
            if (!this.stylesheet.stripSpaces(node.getParentNode())) {
                this.print(data);
            }
        }
    }

    public void copyOf(Object value) throws IOException, SAXException, XPathException {
        this.popText();
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            for (int i = 0; i < list.size(); ++i) {
                Node child = (Node)list.get(i);
                this.copyOf(child);
            }
        } else if (value instanceof Iterator) {
            Iterator iter = (Iterator)value;
            while (iter.hasNext()) {
                Node child = (Node)iter.next();
                this.copyOf(child);
            }
        } else if (value instanceof Attr) {
            Attr child = (Attr)value;
            this.attribute(child.getNamespaceURI(), child.getPrefix(), child.getLocalName(), child.getNodeName(), child.getNodeValue());
        } else if (value instanceof QElement) {
            Node subNode;
            QElement child = (QElement)value;
            this.startElement(child.getNamespaceURI(), child.getPrefix(), child.getLocalName(), child.getNodeName());
            for (subNode = child.getFirstAttribute(); subNode != null; subNode = subNode.getNextSibling()) {
                QAttr attr = (QAttr)subNode;
                this.attribute(attr.getNamespaceURI(), attr.getPrefix(), attr.getLocalName(), attr.getNodeName(), attr.getNodeValue());
            }
            for (subNode = child.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                this.copyOf(subNode);
            }
            this.popElement();
        } else if (value instanceof DocumentFragment) {
            for (Node subNode = ((Node)value).getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                this.copyOf(subNode);
            }
        } else if (value instanceof Text) {
            Text child = (Text)value;
            this.text.append(child.getNodeValue());
        } else if (value instanceof Comment) {
            Comment child = (Comment)value;
            this.xmlWriter.comment(child.getNodeValue());
        } else if (value instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)value;
            this.xmlWriter.processingInstruction(pi.getNodeName(), pi.getNodeValue());
        } else if (value instanceof Node) {
            Node child = (Node)value;
            this.text.append(child.getNodeValue());
        } else {
            this.print(Expr.toString(value));
        }
    }

    public void addNamespace(String prefix, String url) {
        if (url.startsWith("quote:")) {
            url = url.substring(6);
        }
        if (!url.equals("")) {
            this.namespaces.put(prefix, url);
            this.topNamespaces.add(prefix);
        }
    }

    void startElement(String url, String prefix, String local, String qName) throws IOException, SAXException {
        String topUrl;
        String topPrefix;
        int i;
        if (this.attributeName != null) {
            throw this.error(L.l("element `{0}' is not allowed inside attribute `{1}'.  xsl:attribute must contain text only.", (Object)qName, this.attributeName));
        }
        this.popText();
        StackItem item = null;
        if (this.depth >= this.elementStack.size()) {
            item = new StackItem();
            this.elementStack.add(item);
        } else {
            item = (StackItem)this.elementStack.get(this.depth);
        }
        item.init(url, prefix, local, qName, this.isCdata);
        if (this.cdataElements != null && this.cdataElements.get(qName) != null) {
            this.isCdata = true;
        }
        this.xmlWriter.setLocation(this.filename, this.line, 0);
        ++this.depth;
        if (this.depth == 1) {
            for (i = 0; i < this.topNamespaces.size(); ++i) {
                topPrefix = (String)this.topNamespaces.get(i);
                topUrl = (String)this.namespaces.get(topPrefix);
                this.xmlWriter.startPrefixMapping(topPrefix, topUrl);
            }
        }
        this.xmlWriter.startElement(url, local, qName);
        if (this.depth == 1) {
            for (i = 0; i < this.topNamespaces.size(); ++i) {
                topPrefix = (String)this.topNamespaces.get(i);
                topUrl = (String)this.namespaces.get(topPrefix);
                if (topPrefix.equals("")) {
                    this.xmlWriter.attribute(XMLNS, "", "xmlns", topUrl);
                    continue;
                }
                this.xmlWriter.attribute(XMLNS, topPrefix, "xmlns:" + topPrefix, topUrl);
            }
        }
        if (url == null) {
            return;
        }
        this.bindNamespace(prefix, url);
    }

    public void popElement() throws IOException, SAXException {
        this.popText();
        --this.depth;
        StackItem item = (StackItem)this.elementStack.get(this.depth);
        try {
            int i;
            this.xmlWriter.endElement(item.getNamespace(), item.getLocalName(), item.getName());
            for (i = 0; i < item.nsSize(); ++i) {
                String oldPrefix = item.getNSPrefix(i);
                String oldUrl = item.getNSUrl(i);
                this.xmlWriter.endPrefixMapping(oldPrefix);
                if (oldUrl == null) {
                    this.namespaces.remove(oldPrefix);
                    continue;
                }
                this.namespaces.put(oldPrefix, oldUrl);
            }
            if (this.depth == 0) {
                for (i = 0; i < this.topNamespaces.size(); ++i) {
                    String topPrefix = (String)this.topNamespaces.get(i);
                    this.xmlWriter.endPrefixMapping(topPrefix);
                }
            }
            this.isCdata = item.getCdata();
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    void attribute(String url, String prefix, String local, String qName, String value) throws IOException, SAXException {
        if (qName.startsWith("xmlns:")) {
            this.bindNamespace(qName.substring("xmlns:".length()), value);
        } else if (qName.equals("xmlns")) {
            this.bindNamespace("", value);
        } else {
            this.xmlWriter.attribute(url, local, qName, value);
            if (url != null && !url.equals("") && !prefix.equals("")) {
                this.bindNamespace(prefix, url);
            }
        }
    }

    private void bindNamespace(String prefix, String url) throws IOException, SAXException {
        String oldUrl = (String)this.namespaces.get(prefix);
        if (oldUrl == null && url.equals("") || oldUrl != null && url.equals(oldUrl)) {
            return;
        }
        if (prefix != null && !prefix.equals("")) {
            this.xmlWriter.attribute(XMLNS, prefix, "xmlns:" + prefix, url);
            this.namespaces.put(prefix, url);
        } else {
            this.xmlWriter.attribute(XMLNS, null, "xmlns", url);
            this.namespaces.put(prefix, url);
        }
        StackItem item = (StackItem)this.elementStack.get(this.depth - 1);
        item.addNamespace(prefix, oldUrl);
    }

    public void popText() throws IOException, SAXException {
        Object textNode = null;
        if (this.text.length() == 0) {
            return;
        }
        if (this.filename != null) {
            this.xmlWriter.setLocation(this.filename, this.line, 0);
            this.line = this.tailLine;
        }
        if (this.isCdata) {
            this.xmlWriter.cdata(this.text.getBuffer(), 0, this.text.getLength());
        } else {
            this.xmlWriter.text(this.text.getBuffer(), 0, this.text.getLength());
        }
        this.text.clear();
    }

    public Object getProperty(String name) {
        return this.transformer.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.transformer.setProperty(name, value);
    }

    public void removeProperty(String name) {
    }

    public Iterator getPropertyNames() {
        return null;
    }

    public Object getParameter(String name) {
        return this.transformer.getParameter(name);
    }

    public Path getPwd() {
        return (Path)this.getProperty("caucho.pwd");
    }

    public OutputStream openWrite(ExprEnvironment env, String href) throws IOException {
        XmlPrinter printer;
        Path path;
        if (this.xmlWriter instanceof XmlPrinter && (path = (printer = (XmlPrinter)this.xmlWriter).getPath()) != null) {
            return path.getParent().lookup(href).openWrite();
        }
        Path stylesheetPath = env.getStylesheetEnv().getPath();
        return stylesheetPath.getParent().lookup(href).openWrite();
    }

    public XslWriter openResultDocument(OutputStream os) throws IOException, SAXException {
        XmlPrinter writer = new XmlPrinter(os);
        XslWriter out = new XslWriter(null, this.stylesheet, this.transformer);
        out.init(writer);
        writer.startDocument();
        return out;
    }

    public PageContext getPage() {
        return (PageContext)this.getProperty("caucho.page.context");
    }

    private IOException error(String message) {
        if (this.filename != null) {
            return new IOException(this.filename + ":" + this.line + ": " + message);
        }
        return new IOException(message);
    }

    static class StackItem {
        String url;
        String prefix;
        String local;
        String qName;
        boolean isCdata;
        ArrayList nsPrefixes;
        ArrayList nsUrls;

        StackItem() {
        }

        void clear() {
        }

        void init(String url, String prefix, String local, String qName, boolean isCdata) {
            if (this.nsPrefixes != null) {
                this.nsPrefixes.clear();
                this.nsUrls.clear();
            }
            this.url = url;
            this.prefix = prefix;
            this.local = local;
            this.qName = qName;
            this.isCdata = isCdata;
        }

        String getNamespace() {
            return this.url;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getLocalName() {
            return this.local;
        }

        String getName() {
            return this.qName;
        }

        boolean getCdata() {
            return this.isCdata;
        }

        int nsSize() {
            return this.nsPrefixes == null ? 0 : this.nsPrefixes.size();
        }

        String getNSPrefix(int i) {
            return (String)this.nsPrefixes.get(i);
        }

        String getNSUrl(int i) {
            return (String)this.nsUrls.get(i);
        }

        void addNamespace(String prefix, String oldUrl) {
            if (this.nsPrefixes == null) {
                this.nsPrefixes = new ArrayList();
                this.nsUrls = new ArrayList();
            }
            this.nsPrefixes.add(prefix);
            this.nsUrls.add(oldUrl);
        }
    }
}

