/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async.model;

import com.opensymphony.async.util.GUIDGenerator;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.math.BigDecimal;

/**
 * Abstract base class for model entities
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public abstract class AbstractDomainObject {
    private static GUIDGenerator GUID_GENERATOR = new GUIDGenerator();
    public static final BigDecimal ZERO = BigDecimal.valueOf(0);
    private String id;
    private int version = -1;

    protected AbstractDomainObject() {
        this.id = GUID_GENERATOR.getUnformatedUUID();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AbstractDomainObject)) return false;

        final AbstractDomainObject abstractDomainObject = (AbstractDomainObject) o;

        if (id != null ? !id.equals(abstractDomainObject.getId()) : abstractDomainObject.getId() != null) return false;

        return true;
    }

    public int hashCode() {
        return (id != null ? id.hashCode() : 0);
    }

    public String toString() {
       return new ToStringBuilder(this)
            .append("id", getId())
            .toString();
	}
}

