/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async.model;

import java.util.List;
import java.util.Date;
import java.util.ArrayList;

/**
 * Experiment
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public class Experiment extends AbstractDomainObject {
    private List runs = new ArrayList();
    private Date startDate = new Date();
    private Date endDate;

    public List getRuns() {
        return runs;
    }

    public void setRuns(List runs) {
        this.runs = runs;
    }

    public void addRun(Run run) {
        run.setExperiment(this);
        getRuns().add(run);
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}
