/*
 * Copyright (c) 2005 Jason Carreira. All Rights Reserved.
 */
package com.opensymphony.async.web.actions;

import com.opensymphony.async.model.Experiment;

/**
 * ShowExperiment
 *
 * @author Jason Carreira <jcarreira@eplus.com>
 */
public class ShowExperiment extends AbstractExperimentAction {
    String experimentId;
    Experiment experiment;

    public String getExperimentId() {
        return experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public Experiment getExperiment() {
        return experiment;
    }

    public void validate() {
        if((experimentId == null) || (experimentId.trim().equals(""))) {
            addFieldError("experimentId","You must provide an experiment id");
        }
    }

    public String execute() throws Exception {
        experiment = experimentDao.findById(experimentId);
        return SUCCESS;
    }
}
