/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.upload.MultipartElement;

public class MultipartIterator {
    protected HttpServletRequest request;
    protected ServletInputStream inputStream;
    protected String boundary;
    protected boolean contentRead = false;
    protected long maxSize = -1L;
    protected long totalLength = 0L;
    protected int contentLength;
    protected int bufferSize = 4096;

    public MultipartIterator(HttpServletRequest request) throws ServletException {
        this(request, -1);
    }

    public MultipartIterator(HttpServletRequest request, int bufferSize) throws ServletException {
        this(request, bufferSize, -1L);
    }

    public MultipartIterator(HttpServletRequest request, int bufferSize, long maxSize) throws ServletException {
        this.request = request;
        this.maxSize = maxSize;
        if (bufferSize > -1) {
            this.bufferSize = bufferSize;
        }
        this.parseRequest();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public MultipartElement getNextElement() throws ServletException, UnsupportedEncodingException {
        String disposition = this.readLine();
        if (disposition != null && disposition.startsWith("Content-Disposition")) {
            String name = MultipartIterator.parseDispositionName(disposition);
            String filename = MultipartIterator.parseDispositionFilename(disposition);
            String contentType = null;
            if (filename != null) {
                filename = new File(filename).getName();
                int colonIndex = filename.indexOf(":");
                int slashIndex = filename.lastIndexOf("\\");
                if (colonIndex > -1 && slashIndex > -1) {
                    filename = filename.substring(slashIndex + 1, filename.length());
                }
                contentType = this.readLine();
                contentType = MultipartIterator.parseContentType(contentType);
            }
            StringBuffer textData = new StringBuffer();
            this.readLine();
            String line = this.readLine();
            while (line != null && !line.startsWith(this.boundary)) {
                textData.append(line);
                line = this.readLine();
                if (this.maxSize <= -1L || this.totalLength <= this.maxSize) continue;
                throw new ServletException("Multipart data size exceeds the maximum allowed post size");
            }
            if (textData.length() > 1) {
                textData.setLength(textData.length() - 2);
            }
            MultipartElement element = new MultipartElement(name, filename, contentType, textData.toString().getBytes("ISO-8859-1"));
            return element;
        }
        return null;
    }

    public static String parseBoundary(String contentType) {
        if (contentType.lastIndexOf("boundary=") != -1) {
            String _boundary = "--" + contentType.substring(contentType.lastIndexOf("boundary=") + 9);
            if (_boundary.endsWith("\n")) {
                return _boundary.substring(0, _boundary.length() - 1);
            }
            return _boundary;
        }
        return null;
    }

    public static String parseContentType(String contentTypeString) {
        int endLineIndex;
        int nameIndex = contentTypeString.indexOf("Content-Type: ");
        if (nameIndex != -1 && (endLineIndex = contentTypeString.indexOf("\n")) != -1) {
            return contentTypeString.substring(nameIndex + 14, endLineIndex);
        }
        return null;
    }

    public static String parseDispositionFilename(String dispositionString) {
        return MultipartIterator.parseForAttribute("filename", dispositionString);
    }

    public static String parseDispositionName(String dispositionString) {
        return MultipartIterator.parseForAttribute("name", dispositionString);
    }

    public static String parseForAttribute(String attribute, String parseString) {
        int nameIndex = parseString.indexOf(String.valueOf(attribute) + "=\"");
        if (nameIndex != -1) {
            int endQuoteIndex = parseString.indexOf("\"", nameIndex + attribute.length() + 3);
            if (endQuoteIndex != -1) {
                return parseString.substring(nameIndex + attribute.length() + 2, endQuoteIndex);
            }
            return "";
        }
        return null;
    }

    protected void parseRequest() throws ServletException {
        this.contentLength = this.request.getContentLength();
        this.boundary = MultipartIterator.parseBoundary(this.request.getContentType());
        try {
            this.inputStream = this.request.getInputStream();
        }
        catch (IOException iOException) {
            throw new ServletException("MultipartIterator.parseRequest(): IOException while trying to obtain ServletInputStream");
        }
        if (this.boundary == null || this.boundary.length() < 1) {
            this.boundary = MultipartIterator.parseBoundary(this.request.getHeader("Content-type"));
        }
        if (this.boundary == null || this.boundary.length() < 1) {
            throw new ServletException("MultipartIterator: cannot retrieve boundary for multipart request");
        }
        try {
            String firstLine = this.readLine();
            if (firstLine == null) {
                throw new ServletException("MultipartIterator: no multipart request data sent");
            }
            if (!firstLine.startsWith(this.boundary)) {
                throw new ServletException("MultipartIterator: invalid multipart request data, doesn't start with boundary");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ServletException("MultipartIterator: encoding \"ISO-8859-1\" not supported");
        }
    }

    protected String readLine() throws ServletException, UnsupportedEncodingException {
        int bytesRead;
        byte[] bufferByte = new byte[this.bufferSize];
        if (this.totalLength >= (long)this.contentLength) {
            return null;
        }
        try {
            bytesRead = this.inputStream.readLine(bufferByte, 0, this.bufferSize);
        }
        catch (IOException ioe) {
            throw new ServletException("IOException while reading multipart request: " + ioe.getMessage());
        }
        if (bytesRead == -1) {
            return null;
        }
        this.totalLength += (long)bytesRead;
        return new String(bufferByte, 0, bytesRead, "ISO-8859-1");
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

