/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.struts.util.MessageResourcesFactory;

public abstract class MessageResources
implements Serializable {
    protected String config = null;
    protected Locale defaultLocale = Locale.getDefault();
    protected MessageResourcesFactory factory = null;
    private HashMap formats = new HashMap();
    protected boolean returnNull = false;
    protected static MessageResourcesFactory defaultFactory = null;

    public MessageResources(MessageResourcesFactory factory, String config) {
        this(factory, config, false);
    }

    public MessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        this.factory = factory;
        this.config = config;
        this.returnNull = returnNull;
    }

    public String getConfig() {
        return this.config;
    }

    public MessageResourcesFactory getFactory() {
        return this.factory;
    }

    public String getMessage(String key) {
        return this.getMessage(null, key);
    }

    public String getMessage(String key, Object arg0) {
        return this.getMessage(null, key, arg0);
    }

    public String getMessage(String key, Object arg0, Object arg1) {
        return this.getMessage(null, key, arg0, arg1);
    }

    public String getMessage(String key, Object arg0, Object arg1, Object arg2) {
        return this.getMessage(null, key, arg0, arg1, arg2);
    }

    public String getMessage(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getMessage(null, key, arg0, arg1, arg2, arg3);
    }

    public String getMessage(String key, Object[] args) {
        return this.getMessage((Locale)null, key, args);
    }

    public abstract String getMessage(Locale var1, String var2);

    public String getMessage(Locale locale, String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        return this.getMessage(locale, key, args);
    }

    public String getMessage(Locale locale, String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        return this.getMessage(locale, key, args);
    }

    public String getMessage(Locale locale, String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        return this.getMessage(locale, key, args);
    }

    public String getMessage(Locale locale, String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        return this.getMessage(locale, key, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMessage(Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        MessageFormat format = null;
        String formatKey = this.messageKey(locale, key);
        HashMap hashMap = this.formats;
        synchronized (hashMap) {
            format = (MessageFormat)this.formats.get(formatKey);
            if (format != null) return format.format(args);
            String formatString = this.getMessage(locale, key);
            if (formatString == null) {
                if (!this.returnNull) return "???" + formatKey + "???";
                return null;
            }
            format = new MessageFormat(formatString);
            this.formats.put(formatKey, format);
            return format.format(args);
        }
    }

    public static synchronized MessageResources getMessageResources(String config) {
        if (defaultFactory == null) {
            defaultFactory = MessageResourcesFactory.createFactory();
        }
        return defaultFactory.createResources(config);
    }

    public boolean getReturnNull() {
        return this.returnNull;
    }

    protected String localeKey(Locale locale) {
        if (locale == null) {
            return "";
        }
        return locale.toString();
    }

    public void log(String message) {
        PrintWriter writer = this.factory.getWriter();
        if (writer != null) {
            writer.print("MessageResources: ");
            writer.println(message);
            writer.flush();
        }
    }

    public void log(String message, Throwable throwable) {
        PrintWriter writer = this.factory.getWriter();
        if (writer != null) {
            writer.print("MessageResources: ");
            writer.println(message);
            throwable.printStackTrace(writer);
            writer.flush();
        }
    }

    protected String messageKey(String localeKey, String key) {
        return String.valueOf(localeKey) + "." + key;
    }

    protected String messageKey(Locale locale, String key) {
        return String.valueOf(this.localeKey(locale)) + "." + key;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }
}

