/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.struts.util.FastHashMap;

public final class PropertyUtils {
    public static final char INDEXED_DELIM = '[';
    public static final char INDEXED_DELIM2 = ']';
    public static final char NESTED_DELIM = '.';
    private static FastHashMap descriptorsCache = null;

    static {
        descriptorsCache = new FastHashMap();
        descriptorsCache.setFast(true);
    }

    public static void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors(orig);
        int i = 0;
        while (i < origDescriptors.length) {
            String name = origDescriptors[i].getName();
            if (PropertyUtils.getPropertyDescriptor(dest, name) != null) {
                Object value = PropertyUtils.getSimpleProperty(orig, name);
                try {
                    PropertyUtils.setSimpleProperty(dest, name, value);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            ++i;
        }
    }

    public static Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        return PropertyUtils.getIndexedProperty(bean, name, index);
    }

    public static Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod()) != null) {
            Object[] subscript = new Object[]{new Integer(index)};
            return readMethod.invoke(bean, subscript);
        }
        readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = readMethod.invoke(bean, new Object[0]);
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed");
        }
        return Array.get(value, index);
    }

    public static Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim;
        while ((delim = name.indexOf(46)) >= 0) {
            String next = name.substring(0, delim);
            bean = next.indexOf(91) >= 0 ? PropertyUtils.getIndexedProperty(bean, next) : PropertyUtils.getSimpleProperty(bean, next);
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, delim) + "'");
            }
            name = name.substring(delim + 1);
        }
        if (name.indexOf(91) >= 0) {
            return PropertyUtils.getIndexedProperty(bean, name);
        }
        return PropertyUtils.getSimpleProperty(bean, name);
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PropertyUtils.getNestedProperty(bean, name);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int period;
        while ((period = name.indexOf(".")) >= 0) {
            String next = name.substring(0, period);
            bean = next.indexOf("[") >= 0 ? PropertyUtils.getIndexedProperty(bean, next) : PropertyUtils.getSimpleProperty(bean, next);
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, period) + "'");
            }
            name = name.substring(period + 1);
        }
        int left = name.indexOf("[");
        if (left >= 0) {
            name = name.substring(0, left);
        }
        if (bean == null || name == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        if (descriptors == null) {
            return null;
        }
        int i = 0;
        while (i < descriptors.length) {
            if (name.equals(descriptors[i].getName())) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            return new PropertyDescriptor[0];
        }
        String beanClassName = bean.getClass().getName();
        PropertyDescriptor[] descriptors = (PropertyDescriptor[])descriptorsCache.get(beanClassName);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(beanClassName, descriptors);
        return descriptors;
    }

    public static Class getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    public static Class getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        return descriptor.getPropertyType();
    }

    public static Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = readMethod.invoke(bean, new Object[0]);
        return value;
    }

    public static void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method writeMethod;
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod()) != null) {
            Object[] subscript = new Object[]{new Integer(index), value};
            writeMethod.invoke(bean, subscript);
            return;
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object array = readMethod.invoke(bean, new Object[0]);
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed");
        }
        Array.set(array, index, value);
    }

    public static void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        PropertyUtils.setIndexedProperty(bean, name, index, value);
    }

    public static void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim;
        while ((delim = name.indexOf(46)) >= 0) {
            String next = name.substring(0, delim);
            bean = next.indexOf(91) >= 0 ? PropertyUtils.getIndexedProperty(bean, next) : PropertyUtils.getSimpleProperty(bean, next);
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, delim) + "'");
            }
            name = name.substring(delim + 1);
        }
        if (name.indexOf(91) >= 0) {
            PropertyUtils.setIndexedProperty(bean, name, value);
        } else {
            PropertyUtils.setSimpleProperty(bean, name, value);
        }
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtils.setNestedProperty(bean, name, value);
    }

    public static void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method");
        }
        Object[] values = new Object[]{value};
        writeMethod.invoke(bean, values);
    }
}

