/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.util.PropertyUtils;

public final class BeanUtils {
    public static String capitalize(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = bean.getClass();
        Object newBean = clazz.newInstance();
        PropertyUtils.copyProperties(newBean, bean);
        return newBean;
    }

    public static Object convert(String value, Class clazz) {
        String type = clazz.getName();
        if ("java.lang.String".equals(type) || "String".equals(type)) {
            if (value == null) {
                return null;
            }
            return value;
        }
        if ("java.lang.Boolean".equals(type) || Boolean.TYPE.getName().equals(type) || "boolean".equals(type)) {
            return BeanUtils.convertBoolean(value);
        }
        if ("java.lang.Byte".equals(type) || Byte.TYPE.getName().equals(type) || "byte".equals(type)) {
            return BeanUtils.convertByte(value);
        }
        if ("java.lang.Character".equals(type) || Character.TYPE.getName().equals(type) || "char".equals(type)) {
            return BeanUtils.convertCharacter(value);
        }
        if ("java.lang.Integer".equals(type) || Integer.TYPE.getName().equals(type) || "int".equals(type)) {
            return BeanUtils.convertInteger(value);
        }
        if ("java.lang.Long".equals(type) || Long.TYPE.getName().equals(type) || "long".equals(type)) {
            return BeanUtils.convertLong(value);
        }
        if ("java.lang.Float".equals(type) || Float.TYPE.getName().equals(type) || "float".equals(type)) {
            return BeanUtils.convertFloat(value);
        }
        if ("java.lang.Double".equals(type) || Double.TYPE.getName().equals(type) || "double".equals(type)) {
            return BeanUtils.convertDouble(value);
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Object convert(String[] values, Class clazz) {
        String type = clazz.getComponentType().getName();
        if ("java.lang.String".equals(type) || "String".equals(type)) {
            if (values == null) {
                return null;
            }
            return values;
        }
        int len = values.length;
        if ("java.lang.Boolean".equals(type)) {
            Boolean[] array = new Boolean[len];
            int i = 0;
            while (i < len) {
                array[i] = BeanUtils.convertBoolean(values[i]);
                ++i;
            }
            return array;
        }
        if ("boolean".equals(type) || Boolean.TYPE.getName().equals(type)) {
            boolean[] array = new boolean[len];
            int i = 0;
            while (i < len) {
                array[i] = BeanUtils.convertBoolean(values[i]);
                ++i;
            }
        } else {
            if ("java.lang.Byte".equals(type)) {
                Byte[] array = new Byte[len];
                int i = 0;
                while (i < len) {
                    array[i] = BeanUtils.convertByte(values[i]);
                    ++i;
                }
                return array;
            }
            if ("byte".equals(type) || Byte.TYPE.getName().equals(type)) {
                byte[] array = new byte[len];
                int i = 0;
                while (i < len) {
                    array[i] = BeanUtils.convertByte(values[i]);
                    ++i;
                }
            } else {
                if ("java.lang.Character".equals(type)) {
                    Character[] array = new Character[len];
                    int i = 0;
                    while (i < len) {
                        array[i] = BeanUtils.convertCharacter(values[i]);
                        ++i;
                    }
                    return array;
                }
                if ("char".equals(type) || Character.TYPE.getName().equals(type)) {
                    char[] array = new char[len];
                    int i = 0;
                    while (i < len) {
                        array[i] = BeanUtils.convertCharacter(values[i]).charValue();
                        ++i;
                    }
                } else {
                    if ("java.lang.Integer".equals(type)) {
                        Integer[] array = new Integer[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertInteger(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if ("int".equals(type) || Integer.TYPE.getName().equals(type)) {
                        int[] array = new int[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertInteger(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if ("java.lang.Long".equals(type)) {
                        Long[] array = new Long[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertLong(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if ("long".equals(type) || Long.TYPE.getName().equals(type)) {
                        long[] array = new long[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertLong(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if ("java.lang.Float".equals(type)) {
                        Float[] array = new Float[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertFloat(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if ("float".equals(type) || Float.TYPE.getName().equals(type)) {
                        float[] array = new float[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertFloat(values[i]).floatValue();
                            ++i;
                        }
                        return array;
                    }
                    if ("java.lang.Double".equals(type)) {
                        Double[] array = new Double[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertDouble(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if ("double".equals(type) || Double.TYPE.getName().equals(type)) {
                        double[] array = new double[len];
                        int i = 0;
                        while (i < len) {
                            array[i] = BeanUtils.convertDouble(values[i]);
                            ++i;
                        }
                        return array;
                    }
                    if (values == null) {
                        return null;
                    }
                    String[] array = new String[len];
                    int i = 0;
                    while (i < len) {
                        array[i] = values[i].toString();
                        ++i;
                    }
                    return array;
                }
            }
        }
        return null;
    }

    private static Boolean convertBoolean(String value) {
        if (value == null) {
            return new Boolean(false);
        }
        if (value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on")) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    private static Byte convertByte(String value) {
        try {
            return new Byte(value);
        }
        catch (NumberFormatException numberFormatException) {
            return new Byte(0);
        }
    }

    private static Character convertCharacter(String value) {
        if (value == null) {
            return new Character(' ');
        }
        if (value.length() == 0) {
            return new Character(' ');
        }
        return new Character(value.charAt(0));
    }

    private static Double convertDouble(String value) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(0.0);
        }
    }

    private static Float convertFloat(String value) {
        try {
            return new Float(value);
        }
        catch (NumberFormatException numberFormatException) {
            return new Float(0.0);
        }
    }

    private static Integer convertInteger(String value) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException numberFormatException) {
            return new Integer(0);
        }
    }

    private static Long convertLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException numberFormatException) {
            return new Long(0L);
        }
    }

    public static String filter(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == '<') {
                result.append("&lt;");
            } else if (ch == '>') {
                result.append("&gt;");
            } else if (ch == '&') {
                result.append("&amp;");
            } else if (ch == '\"') {
                result.append("&quot;");
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] getArrayProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getProperty(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList values = new ArrayList((Collection)value);
            return values.toArray(new String[values.size()]);
        }
        if (value.getClass().isArray()) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                int n = Array.getLength(value);
                int i = 0;
                while (i < n) {
                    values.add(Array.get(value, i).toString());
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            return values.toArray(new String[values.size()]);
        }
        String[] results = new String[]{value.toString()};
        return results;
    }

    public static String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim = 91;
        if (delim < 0) {
            return BeanUtils.getScalarProperty(bean, name);
        }
        int index = -1;
        try {
            index = Integer.parseInt(name.substring(delim + 1));
            name = name.substring(0, delim);
        }
        catch (NumberFormatException numberFormatException) {
            return BeanUtils.getScalarProperty(bean, name);
        }
        return BeanUtils.getIndexedProperty(bean, name, index);
    }

    public static String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (index < 0) {
            return null;
        }
        String[] values = BeanUtils.getArrayProperty(bean, name);
        if (values == null || index >= values.length) {
            return null;
        }
        return values[index];
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) {
        try {
            return PropertyUtils.getPropertyDescriptor(bean, name);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        return PropertyUtils.getPropertyDescriptors(bean);
    }

    public static Object getPropertyValue(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PropertyUtils.getProperty(bean, name);
    }

    public static String getScalarProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getProperty(bean, name);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            String[] values = BeanUtils.getArrayProperty(bean, name);
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        return value.toString();
    }

    public static Object lookup(PageContext pageContext, String name, String scope) {
        Object bean = null;
        if (scope == null) {
            bean = pageContext.findAttribute(name);
        } else if (scope.equalsIgnoreCase("page")) {
            bean = pageContext.getAttribute(name, 1);
        } else if (scope.equalsIgnoreCase("request")) {
            bean = pageContext.getAttribute(name, 2);
        } else if (scope.equalsIgnoreCase("session")) {
            bean = pageContext.getAttribute(name, 3);
        } else if (scope.equalsIgnoreCase("application")) {
            bean = pageContext.getAttribute(name, 4);
        } else {
            throw new IllegalArgumentException(scope);
        }
        return bean;
    }

    public static void populate(Object bean, String prefix, String suffix, HttpServletRequest request) throws ServletException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Enumeration names = null;
        Hashtable multipartElements = null;
        boolean isMultipart = false;
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            isMultipart = true;
            MultipartRequestHandler multipart = null;
            if (!(bean instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + bean.getClass().getName() + "\"");
            }
            ActionServlet servlet = ((ActionForm)bean).getServlet();
            String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
            request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
            if (multipartClass != null) {
                try {
                    multipart = (MultipartRequestHandler)Class.forName(multipartClass).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    servlet.log("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class");
                }
                catch (InstantiationException ie) {
                    servlet.log("InstantiaionException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    servlet.log("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage());
                }
            }
            if (multipart == null) {
                try {
                    multipart = (MultipartRequestHandler)Class.forName(servlet.getMultipartClass()).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ServletException("Cannot find multipart class \"" + servlet.getMultipartClass() + "\"" + ", exception: " + cnfe.getMessage());
                }
                catch (InstantiationException ie) {
                    throw new ServletException("InstantiaionException when instantiating multipart class \"" + servlet.getMultipartClass() + "\", exception: " + ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new ServletException("IllegalAccessException when instantiating multipart class \"" + servlet.getMultipartClass() + "\", exception: " + iae.getMessage());
                }
            }
            ((ActionForm)bean).setMultipartRequestHandler(multipart);
            multipart.setServlet(servlet);
            multipart.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
            request.removeAttribute("org.apache.struts.action.mapping.instance");
            multipart.handleRequest(request);
            multipartElements = multipart.getAllElements();
            names = multipartElements.keys();
        }
        if (!isMultipart) {
            names = request.getParameterNames();
        }
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String stripped = name;
            int subscript = stripped.lastIndexOf("[");
            if (subscript >= 0) {
                stripped = stripped.substring(0, subscript);
            }
            if (prefix != null) {
                if (!stripped.startsWith(prefix)) continue;
                stripped = stripped.substring(prefix.length());
            }
            if (suffix != null) {
                if (!stripped.endsWith(suffix)) continue;
                stripped = stripped.substring(0, stripped.length() - suffix.length());
            }
            if (isMultipart) {
                properties.put(stripped, multipartElements.get(name));
                continue;
            }
            properties.put(stripped, request.getParameterValues(name));
        }
        try {
            BeanUtils.populate(bean, properties);
        }
        catch (Exception e) {
            throw new ServletException("BeanUtils.populate", (Throwable)e);
        }
    }

    public static void populate(Object bean, Hashtable properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        if (descriptors.length < 1) {
            return;
        }
        Enumeration names = properties.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = properties.get(name);
            if (value == null) continue;
            Method setter = null;
            Class<?>[] parameterTypes = null;
            int i = 0;
            while (i < descriptors.length) {
                if (name.equals(descriptors[i].getName()) && (setter = descriptors[i].getWriteMethod()) != null) {
                    parameterTypes = setter.getParameterTypes();
                    if (parameterTypes.length == 1) break;
                    setter = null;
                }
                ++i;
            }
            if (setter == null) continue;
            Object[] parameters = new Object[1];
            if (parameterTypes[0].isArray()) {
                if (value instanceof String) {
                    String[] values = new String[]{(String)value};
                    parameters[0] = BeanUtils.convert(values, parameterTypes[0]);
                } else {
                    parameters[0] = BeanUtils.convert((String[])value, parameterTypes[0]);
                }
            } else {
                parameters[0] = value instanceof String ? BeanUtils.convert((String)value, parameterTypes[0]) : (value instanceof FormFile ? value : BeanUtils.convert(((String[])value)[0], parameterTypes[0]));
            }
            setter.invoke(bean, parameters);
        }
    }

    public static void populate(Object bean, HttpServletRequest request) throws ServletException {
        BeanUtils.populate(bean, null, null, request);
    }
}

