/*
 * JoinAction.java
 */
package web.mailinglist;

import business.db.MailingList;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * Implementation of <strong>Action</strong> that validates and adds
 * a user to a mailing list.
 */
public final class JoinAction extends Action {
    /**
    * Process the specified HTTP request, and create the corresponding HTTP
    * response (or forward to another web component that will create it).
    * Return an <code>ActionForward</code> instance describing where and how
    * control should be forwarded, or <code>null</code> if the response has
    * already been completed.
    *
    * @param mapping The ActionMapping used to select this instance
    * @param actionForm The optional ActionForm bean for this request (if any)
    * @param request The HTTP request we are processing
    * @param response The HTTP response we are creating
    *
    * @exception IOException if an input/output error occurs
    * @exception ServletException if a servlet exception occurs
    */
    public ActionForward perform(ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
                                 throws IOException, ServletException {
        // Extract attributes and parameters we will need
        JoinForm joinForm = (JoinForm) form;
        String email = joinForm.getEmail();

        ActionErrors errors = new ActionErrors();

        // store input....
        try {
            business.db.MailingList.AddEmail(email);
        } catch (Exception e) {
            // log, print stack


            // display error back to user
            errors.add("email",new ActionError("error.mailing.db.add"));
        }

        // If any messages is required, save the specified error messages keys
        // into the HTTP request for use by the <struts:errors> tag.
        if (!errors.empty()) {
            saveErrors(request, errors);

            // return to the original form
            return (new ActionForward(mapping.getInput()));
        }

        // Forward control to the specified 'success' URI that is in the Action.xml
        return (mapping.findForward("success"));
    }

}
