/*
 * JoinForm.java
 */
package web.mailinglist;

import business.util.Validation;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;


/**
 * Form bean for the join mailing list page.  This form has the following fields,
 * with default values in square brackets:
 * <ul>
 * <li><b>email</b> - The mail host for this subscription.  [REQUIRED]
 * </ul>
 */
public final class JoinForm extends ActionForm  {
    /**
     * Return the email.
     */
    public String getEmail() {
    	return (m_email);
    }

    /**
     * Set the email.
     * @param email The new email address
     */
    public void setEmail(String email) {
        m_email = email;
    }

    /**
     * Reset all properties to their default values.
     *
     * @param mapping The mapping used to select this instance
     * @param request The servlet request we are processing
     */
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        m_email = null;
    }

    /**
     * Validate the properties that have been set from this HTTP request,
     * and return an <code>ActionErrors</code> object that encapsulates any
     * validation errors that have been found.  If no errors are found, return
     * <code>null</code> or an <code>ActionErrors</code> object with no
     * recorded error messages.
     *
     * @param mapping The mapping used to select this instance
     * @param request The servlet request we are processing
     */
    public ActionErrors validate(ActionMapping mapping,
                                 HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

	    if( m_email == null || m_email.length()==0 ){
            errors.add("email",new ActionError("error.mail.address.required"));
        }

	    if( business.util.Validation.isValidEmail( m_email )==false ) {
            errors.add("email",new ActionError("error.mail.address.format"));
        }

    	return (errors);
    }



    /**
     * The email address.
     */
    private String m_email = null;
}

