/*
 * BurpExtender.java
 *
 * Copyright (c) 2012 Luca Carettoni
 *
 * This file is part of Blazer, a Burp extension to perform gray-box AMF Testing.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY.
 *
 */
package burp;

import com.mtso.blazer.AMFUtil;
import com.mtso.blazer.BlazerUIView;
import com.mtso.blazer.TaskManager;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

/*
 * This class implements the IBurpExtender interface to make use of Burp Extender
 */
public class BurpExtender implements IBurpExtender {

    private String version = "v0.2";
    private IBurpExtenderCallbacks myCallBacks;

    public BurpExtender() {
    }

    public void registerExtenderCallbacks(IBurpExtenderCallbacks callbacks) {

        callbacks.issueAlert("[Blazer " + version + "]");
        callbacks.registerMenuItem("Blazer - AMF Testing Made Easy!", new CustomMenuItem(callbacks));
        callbacks.setProxyInterceptionEnabled(false); //avoid interception. In case, users can re-enable it from the GUI
    }

    public void setCommandLineArgs(String[] strings) {
        //no command-line arguments for this extension
    }

    public byte[] processProxyMessage(int i, boolean bln, String string, int i1, boolean bln1, String string1, String string2, String string3, String string4, String string5, byte[] bytes, int[] ints) {
        //no interference with testing
        return bytes;
    }

    public void applicationClosing() {
        //do nothing
    }

    public void processHttpMessage(String string, boolean bln, IHttpRequestResponse ihrr) {
        //do nothing
    }

    public void newScanIssue(IScanIssue isi) {
        //do nothing
    }
}

class CustomMenuItem implements IMenuItemHandler {

    private IBurpExtenderCallbacks callbacks;
    private TaskManager manager;

    public CustomMenuItem(IBurpExtenderCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public void menuItemClicked(String menuItemCaption, IHttpRequestResponse[] messageInfo) {
        try {
            // User clicked on the Blazer extension contextual menu

            //Does the request contain a valid AMF RemotingMessage?
            if (!AMFUtil.isAMF(messageInfo[0].getRequest())) {
                this.callbacks.issueAlert("[Blazer] The request does not contain a valid AMF RemotingMessage");
            }
                if (menuItemCaption.equalsIgnoreCase("Blazer - AMF Testing Made Easy!")) {
                    manager = new TaskManager(callbacks, messageInfo[0]);

                    try {
                        for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if ("Nimbus".equals(info.getName())) {
                                UIManager.setLookAndFeel(info.getClassName());
                                break;
                            }
                        }
                    } catch (Exception e) {
                        // Nimbus L&F is not available, set the GUI to Metal or whatever is available
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }

                    BlazerUIView gui = new BlazerUIView(manager);
                    gui.setVisible(true);
                }
        } catch (Exception ex) {
            System.out.println("[!] Blazer BurpExtender Exception: " + ex.toString().trim());
        }
    }
}
