#!/usr/bin/env python

#dlnaclient.py
#  A program browse the content directory for a specific object
#  Use to analyze DLNA conversation in order to identify appropriate
#  SOAP request to query the desired object.
#  Author: Zachary Cutlip
#          zcutlip@tacnetsol.com
#          Twitter: @zcutlip


from twisted.internet import reactor

from coherence.base import Coherence
from coherence.upnp.devices.control_point import ControlPoint
from coherence.upnp.core import DIDLLite



# called for each media server found
def media_server_found(client, udn):
    print "media_server_found", client
    
    d = client.content_directory.browse('PWNED',
            browse_flag='BrowseDirectChildren', requested_count=100,process_result=False,
            backward_compatibility=False)

def media_server_removed(udn):
    print "media_server_removed", udn

def start():
    control_point = ControlPoint(Coherence({'logmode':'warning'}),
            auto_client=['MediaServer'])
    control_point.connect(media_server_found,
            'Coherence.UPnP.ControlPoint.MediaServer.detected')
    control_point.connect(media_server_removed,
            'Coherence.UPnP.ControlPoint.MediaServer.removed')

if __name__ == "__main__":
    reactor.callWhenRunning(start)
    reactor.run()


