/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NetworkLeakage
extends Applet {
    private ArrayList<String> report_;
    private JTextArea textArea_;
    private String host_;
    private int port_;
    private int timeout_ = 5000;
    private String userAgent_;
    private String urlTarget_;

    public void init() {
        this.report_ = new ArrayList();
        this.textArea_ = new JTextArea();
        this.textArea_.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea_);
        jScrollPane.setPreferredSize(new Dimension(this.getWidth() - 5, this.getHeight() - 5));
        this.add((Component)jScrollPane, "Center");
        this.log("initialized from: " + this.getCodeBase().toString());
    }

    public void start() {
        try {
            this.log("started");
            this.testNetworkInterfaces();
            this.log("finished");
        }
        catch (Exception exception) {
            this.logerror(exception);
        }
    }

    private void testNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                this.dumpNetworkInterface(enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            this.logerror(exception);
        }
    }

    private void dumpNetworkInterface(NetworkInterface networkInterface) {
        try {
            Object object;
            this.report("iface: " + networkInterface.getName());
            this.report("displayName: " + networkInterface.getDisplayName());
            String string = "???";
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = networkInterface.getHardwareAddress();
            if (byArray != null) {
                for (int i = 0; i < byArray.length; ++i) {
                    object = Integer.toHexString(byArray[i] & 0xFF);
                    if (2 == ((String)object).length()) {
                        stringBuilder.append((String)object);
                    } else {
                        stringBuilder.append("0");
                        stringBuilder.append((String)object);
                    }
                    if (byArray.length == i + 1) continue;
                    stringBuilder.append(":");
                }
                string = stringBuilder.toString();
            }
            this.report("macaddr: " + string);
            this.report("MTU: " + networkInterface.getMTU());
            this.report("P-to-P: " + (networkInterface.isPointToPoint() ? "true" : "false"));
            this.report("Multicast: " + (networkInterface.supportsMulticast() ? "true" : "false"));
            this.report("Up: " + (networkInterface.isUp() ? "true" : "false"));
            this.report("Loopback: " + (networkInterface.isLoopback() ? "true" : "false"));
            this.report("Virtual: " + (networkInterface.isVirtual() ? "true" : "false"));
            this.report("");
            Enumeration<Object> enumeration = networkInterface.getSubInterfaces();
            while (enumeration.hasMoreElements()) {
                this.dumpNetworkInterface(enumeration.nextElement());
            }
            enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                object = (InetAddress)enumeration.nextElement();
                this.report("address: " + ((InetAddress)object).getHostAddress());
            }
            this.report("summary: " + networkInterface.toString());
        }
        catch (Exception exception) {
            this.logerror(exception);
        }
    }

    private void report(String string) {
        this.log(string);
    }

    private void log(String string) {
        this.textArea_.append(string + "\n");
    }

    private void logerror(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        this.textArea_.append("error: \n");
        this.textArea_.append(stringWriter.toString());
    }
}

