#
# Author: Gregory Fleischer (gfleischer@gmail.com)
#
# Copyright (c) 2012 Gregory Fleischer
#
# This file is part of WTFY.
#
# WTFY is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# WTFY is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with WTFY.  If not, see <http://www.gnu.org/licenses/>.
#
import tornado.netutil

class XmlSocketService(tornado.netutil.TCPServer):
    def __init__(self, framework):
        tornado.netutil.TCPServer.__init__(self)
        self.framework = framework

    def handle_stream(self, stream, address):
        self.framework.debug('XmlSocketService', 'XmlSocketServer', stream, address)
        self.stream = stream
        self.stream.read_until('\0', self.on_read_complete)

    def on_read_complete(self, data):
        self.framework.debug('XmlSocketService', 'XmlSocketServer data', data)
        self.stream.write('<x/>\0', self.on_write_complete)

    def on_write_complete(self):
        self.stream.close()
