#!/usr/bin/python

# by Collin Mulliner

import os
import sys
import Utils

# tested, works!
# 16bit src / dest port
class SMSUdhPorts:
	def __init__(self, src = 0, dst = 0):
		self._pdu = ""
		# port 16bits
		self._pdu = self._pdu + chr(0x05)
		# length
		self._pdu = self._pdu + chr(0x04)
		self._pdu = self._pdu + chr((dst >> 8) & 0xFF) + chr(dst & 0xFF)
		self._pdu = self._pdu + chr((src >> 8) & 0xFF) + chr(src & 0xFF)
	
	def parse(self, data):
		if len(data) == 6 and data[0] == 0x05 and data[1] == 0x04:
			dst = data[2] << 8 | data[3]
			src = data[4] << 8 | data[5]
			return (dst, src)
		else:
			return (None, None)
	
	def getUdh(self):
		return (6, self._pdu)
		
# tested, works!
# bbit src / dest port
class SMSUdh8bitPorts:
	def __init__(self, src, dst):
		self._pdu = ""
		# port 8bits
		self._pdu = self._pdu + chr(0x04)
		# length
		self._pdu = self._pdu + chr(0x02)
		self._pdu = self._pdu + chr(dst & 0xFF)
		self._pdu = self._pdu + chr(src & 0xFF)
		
	def getUdh(self):
		return (6, self._pdu)

# concatinated sms messages
class SMSUdhConcatMsg:
	def __init__(self, m, c, mid):
		self._pdu = ""
		# concatinated sms
		self._pdu = chr(0x00)
		# length
		self._pdu = self._pdu + chr(0x03)
		self._pdu = self._pdu + chr(mid & 0xFF)
		self._pdu = self._pdu + chr(m & 0xFF)
		self._pdu = self._pdu + chr(c & 0xFF)

	def getUdh(self):
		return (5, self._pdu)

# tested, works
# sms,phone,fax,email indication
class SMSUdhSpecialSMSIndication:
	def __init__(self, msgtype, count, store = 0, profile = 0, extended = 0):
		self._pdu = chr(0x01)
		self._pdu = self._pdu + chr(0x02)
		# add profile and extended
		self._pdu = self._pdu + chr(msgtype & 0x03 | (store & 0x01) << 7)
		self._pdu = self._pdu + chr(count & 0xFF)
		
	def getUdh(self):
		return (4, self._pdu)

class SMSMsg:
	def __init__(self):
		self._msg = None
		self._msg_leng = 0
		self._udh = None
		self._udh_leng = 0
		self._smsc = None
		self._smsc_type = None
		self._msisdn = None
		self._msisdn_type = None
		self._deliver = 0
		self._deliver_mti = 0
		self._deliver_mms = 0
		self._deliver_sri = 0
		self._deliver_udhi = 0
		self._deliver_rp = 0
		self._submit = 0
		self._reference = 0
		self._tppid = 0
		self._tpdcs = 0
		self._timestamp = None
		self._pdu = None
		self._pdu_leng = 0
		self._pdu_cmt = 0
	
	# tested, works!
	def deliver_raw2flags(self):
		self._deliver_mti = self._deliver & 0x03
		self._deliver_mms = (self._deliver >> 2) & 0x01
		self._deliver_sri = (self._deliver >> 5) & 0x01
		self._deliver_udhi = (self._deliver >> 6) & 0x01
		self._deliver_rp = (self._deliver >> 7) & 0x01
	
	# tested, works!
	def deliver_flags2raw(self):
		self._deliver = 0x00 | self._deliver_mti & 0x03
		self._deliver = self._deliver | (self._deliver_mms & 0x01) << 2
		self._deliver = self._deliver | (self._deliver_sri & 0x01) << 5
		self._deliver = self._deliver | (self._deliver_udhi & 0x01) << 6
		self._deliver = self._deliver | (self._deliver_rp & 0x01) << 7
	
	# tested, works!
	def deliver_print(self):
		print "Deliver raw: %0.2X" % self._deliver
		print "MTI: " + str(self._deliver_mti)
		print "MMS: " + str(self._deliver_mms)
		print "SRI: " + str(self._deliver_sri)
		print "UDHI: " + str(self._deliver_udhi)
		print "RP: " + str(self._deliver_rp)
	
	# tested, works!
	def msisdn_enc(self, inno):
		leng = len(inno) / 2 + (len(inno) % 2)
		outno = ""
		c = 0
		for i in range(0, len(inno)):
			if (i % 2 == 1):
				c = c | ((ord(inno[i]) - 48) << 4)
				outno = outno + chr(c)
				c = 0
			else:
				c = c | (ord(inno[i]) - 48)
				if i == len(inno) - 1:
					c = c | 0xF0
					outno = outno + chr(c)			
		return (leng, outno)
	
	def msisdn_dec(self, inno, innolen):
		outno = ""
		for i in range(0, innolen):
			outno = outno + chr(((inno[i]) & 0x0F) + 48)
			if (inno[i]) >> 4 != 0x0F:
				outno = outno + chr(((inno[i]) >> 4) + 48)
		return outno
				
	def encode7bit(self, data):
		out = ""
		co = ord(data[0])
		d = data[1:]
		p = 0
		#print len(data)
		for i in d:
			#print "%c %d" % (i, p)
			i = ord(i)
			if p == 0:
				co = co | ((i << 7) & 0x80)
				out = out + chr(co)
				co = i >> 1
				p = 2
			elif p == 2:
				co = co | ((i << 6) & 0xC0)
				out = out + chr(co)
				co = i >> 2
				p = 3
			elif p == 3:
				co = co | ((i << 5) & 0xE0)
				out = out + chr(co)
				co = i >> 3
				p = 4
			elif p == 4:
				co = co | ((i << 4) & 0xF0)
				out = out + chr(co)
				co = i >> 4
				p = 5
			elif p == 5:
				co = co | ((i << 3) & 0xF8)
				out = out + chr(co)
				co = i >> 5
				p = 6
			elif p == 6:
				co = co | ((i << 2) & 0xFC)
				out = out + chr(co)
				co = i >> 6
				p = 7
			elif p == 7:
				co = co | ((i << 1) & 0xFE)
				out = out + chr(co)
				co = i >> 7
				p = 0
		out = out + chr(co)	
		#print len(out)
		return out
	
	def decode7bit(self, data, dtype = 1):
		out = ""
		carry = 0
		p = 0
		for i in data:
			if dtype == 1:
				i = ord(i)
			#print "i = %x" % i
			#print "p = %d" % p
			#print "carry = %x" % carry
			if p == 0:
				carry = i & 0x80
				out = out + chr(i & 0x7f)
				p = 1
			elif p == 1:
				tmp = i & 0xC0
				i2 = i & ~0xC0
				out = out + chr(i2 << 1 | (carry >> 7))
				carry = tmp
				p = 2
			elif p == 2:
				tmp = i & 0xE0
				i2 = i & ~0xE0
				out = out + chr(i2 << 2 | (carry >> 6))
				carry = tmp
				p = 3
			elif p == 3:
				tmp = i & 0xF0
				i2 = i & ~0xF0
				out = out + chr(i2 << 3 | (carry >> 5))
				carry = tmp
				p = 4
			elif p == 4:
				tmp = i & 0xF8
				i2 = i & ~0xF8
				out = out + chr(i2 << 4 | (carry >> 4))
				carry = tmp
				p = 5
			elif p == 5:
				tmp = i & 0xFC
				i2 = i & ~0xFC
				out = out + chr(i2 << 5 | (carry >> 3))
				carry = tmp
				p = 6
			elif p == 6:
				tmp = i & 0xFE
				i2 = i & ~0xFE
				out = out + chr(i2 << 6 | (carry >> 2))
				carry = tmp
				p = 7
			elif p == 7:
				i2 = i & ~0xFE
				out = out + chr((i2 << 7 | (carry >> 1)) & 0x7f)
				out = out + chr(i & 0x7F)
				carry = i & 0x80
				p = 1
			#print out[len(out)-1]
		return out

class SMSFromMS(SMSMsg):	
	def encode(self):
		pass
		self._pdu = ""
		# smsc
		if self._smsc:
			(tl, tno) = self.msisdn_enc(self._msisdn)
			self._pdu = self._pdu + chr(tl)
			self._pdu = self._pdu + chr(self._smsc_type)
			self._pdu = self._pdu + tno
		else:
			self._pdu = chr(0x00)
		# submit
		self._pdu = self._pdu + chr(self._submit)
		#self._pdu = self._pdu + chr(0x51)
		# reference
		self._pdu = self._pdu + chr(self._reference)
		# msisdn
		(tl, tno) = self.msisdn_enc(self._msisdn)
		self._pdu = self._pdu + chr(len(self._msisdn))
		self._pdu = self._pdu + chr(self._msisdn_type)
		self._pdu = self._pdu + tno
		# tppid
		self._pdu = self._pdu + chr(self._tppid)
		# tpdcs
		self._pdu = self._pdu + chr(self._tpdcs)
		# timestamp / timeout
		self._pdu = self._pdu + self._timestamp
		#self._pdu = self._pdu + chr(0xAA)
		# length (total)
		length = self._msg_leng 
		if self._udh:
			length = length + self._udh_leng + 1 # what is +1? is this the udhl? (pduspy thinks we need it)
		self._pdu = self._pdu + chr(length)
		# UDH (user data header)
		if self._udh:
			self._pdu = self._pdu + chr(self._udh_leng)
			self._pdu = self._pdu + self._udh
		else:
			pass
		# UD (uder data)
		self._pdu = self._pdu + self._msg
		
	def decode(self):
		pass

class SMSToMS(SMSMsg):
	
	# tested, works!
	def encode(self):
		self._pdu = ""
		# SMSC
		if self._smsc:
			(nl, no) = self.msisdn_enc(self._smsc)
			self._pdu = self._pdu + chr(nl + 1)
			self._pdu_cmt = nl + 2
			self._pdu = self._pdu + chr(self._smsc_type)
			self._pdu = self._pdu + no
		else:
			self._pdu = self._pdu + chr(0)
			self._pdu_cmt = 0
		# DELIVER
		self._pdu = self._pdu + chr(self._deliver)
		# MSISDN
		(nl, no) = self.msisdn_enc(self._msisdn)
		self._pdu = self._pdu + chr(len(self._msisdn))
		self._pdu = self._pdu + chr(self._msisdn_type)
		self._pdu = self._pdu + no
		# TP_PID
		self._pdu = self._pdu + chr(self._tppid)
		# DCS
		self._pdu = self._pdu + chr(self._tpdcs)
		# timestamp / lifetime
		self._pdu = self._pdu + self._timestamp
		# length (total)
		length = self._msg_leng
		if self._udh:
			length = length + self._udh_leng + 1 # what is +1? is this the udhl? (pduspy thinks we need it)
		self._pdu = self._pdu + chr(length)
		# UDH (user data header)
		if self._udh:
			self._pdu = self._pdu + chr(self._udh_leng)
			self._pdu = self._pdu + self._udh
		else:
			pass
		# UD (uder data)
		self._pdu = self._pdu + self._msg
		# calc cmt length
		self._pdu_cmt = len(self._pdu) - self._pdu_cmt
		
	def decode(self, data, doprint = 1):
		smsc_len = data[0]
		if doprint == 1:
			print "smsc length %d\n" % smsc_len
			print "smsc type %x\n" % data[1]
		self._smsc = self.msisdn_dec(data[2:], (smsc_len - 1))
		if doprint == 1:
			print self._smsc
		pos = smsc_len + 1
		self._deliver = data[pos]
		if doprint == 1:
			print "deliver %x\n" % self._deliver
		self.deliver_raw2flags()
		if doprint == 1:
			self.deliver_print()
		pos = pos + 1
		msisdn_leng = data[pos]
		if doprint == 1:
			print "msisdn leng %d\n" % msisdn_leng
		pos = pos + 1
		self._msisdn_type = data[pos]
		if doprint == 1:
			print "msisdn type %x\n" % self._msisdn_type
		pos = pos + 1
		self._msisdn = self.msisdn_dec(data[pos:], msisdn_leng/2 + msisdn_leng % 2)
		if doprint == 1:
			print self._msisdn
		pos = pos + msisdn_leng/2 + msisdn_leng%2
		self._tppid = data[pos]
		if doprint == 1:
			print "pid %x\n" % self._tppid
		pos = pos + 1
		self._tpdsc = data[pos]
		if doprint == 1:
			print "dsc %x\n" % self._tpdsc
		pos = pos + 1 
		self._timestamp = data[pos:pos+7]
		if doprint == 1:
			print self._timestamp
		pos = pos + 7
		length = data[pos]
		print "length = %d pos = %d value = %x" % (length, pos, data[pos])
		pos = pos + 1
		if doprint == 1:
			print "length: " + str(length)
			#print data[pos:]
		self._udh_leng = data[pos]
		if doprint == 1:
			print "udhl: %d" % self._udh_leng
		pos = pos + 1
		if doprint == 1:	
			print "udh type %x\n" % data[pos]
		pos = pos + 1
		if doprint == 1:
			print "udh length %x\n" % data[pos]
		udhl = data[pos]
		pos = pos + 1
		if doprint == 1:
			print data[pos:pos+udhl]
		udhp = SMSUdhPorts()
		print udhp.parse(data[pos-2:pos+udhl])
		#udhp1 = SMSUdhPorts(0, 5499)
		#(b, a) = udhp1.getUdh()
		#print "%d %d" % (ord(a[2]), ord(a[3]))
		pos = pos + udhl
		if doprint == 1:
			print "data length: %d" % len(data[pos:])
			print self.decode7bit(data[pos:], 0)
		
def __test():
	test = SMSMsg()

	(ol, out) = test.msisdn_enc("491776025980")

	print "Leng: " + str(len(out))
	for i in range(0, ol):
		print "%0.2X" % ord(out[i])
	
	out2 = test.msisdn_dec(out, ol)
	print out2
	
def __test2():
	t = SMSToMS()
	t._msg = "Test 123"
	t._msg_leng = len(t._msg)
	t._msisdn = "491776025980"
	t._msisdn_type = 0x91
	t._smsc = "49177123456"
	t._smsc_type = 0x91
	t._tpdcs = 0x04
	t._tppid = 0x00
	t._deliver = 0x04
	t.encode()
	pdu = Utils.bin2hex(t._pdu, 1)
	print pdu
	#t.deliver_raw2flags()
	#t.deliver_print()
	#t._deliver = 0x00
	#t.deliver_flags2raw()
	#t.deliver_print()
	
if __name__ == "__main__":
	__test2()
	
	#u1 = SMSUdhPorts(1000,1001)
	#(l, u) = u1.getUdh()
	#print l
	#print Utils.bin2hex(u, 1)
	
	
