#!/usr/bin/python

# by Collin Mulliner

import os
import sys
import Utils
import sms
import time
import socket

def sendMsg(msg):
	line = Utils.bin2hex(msg, 1)
	leng = (len(line) / 2) - 8
	buffer = "+CMT: ,%d\r\n%s\r\n" % (leng, line)
	print line
#	so = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
#	so.connect(("192.168.1.182", 4223))
#	so.send(buffer)
#	so.close()

def sendWapPush(msisdn, smsc, dcs, tppid, deliver, ts, src, dst, data):
	if len(data) > 140 - 6:
#		print "data len = %d\n" % len(data)
		parts = len(data) / 131
		if len(data) / 131 > 0:
			parts = parts + 1
#		print "Wap PUSH send in %d parts\n" % parts
		for i in range(0, parts):
#			print "Part #%d\n" % int(i+1)
			if i+1 < parts:
				cd = data[i*131:(i+1)*131]
			else:
				cd = data[i*131:]
			sendMsg(toPortPart(msisdn, smsc, dcs, tppid, deliver, ts, src, dst, cd, parts, i + 1, 88))
#			time.sleep(1)
	else:
		return sendMsg(toPort(msisdn, smsc, dcs, tppid, deliver, ts, src, dst, data))
			

def toPort(msisdn, smsc, dcs, tppid, deliver, ts, src, dst, data):
	s = sms.SMSToMS()
	s._msisdn = msisdn
	s._msisdn_type = 0x91
	s._smsc = smsc
	s._smsc_type = 0x91
	s._tppid = tppid
	s._tpdcs = dcs
	s._timestamp = ts
	s._deliver = deliver
	s.deliver_raw2flags()
	#s.deliver_print()
	s._deliver_udhi = 1
	s.deliver_flags2raw()
	#s.deliver_print()
	s._msg = data
	s._msg_leng = len(data)
	u = sms.SMSUdhPorts(src, dst)
	(s._udh_leng, s._udh) = u.getUdh()
	s.encode()
	return s._pdu

def toPortPart(msisdn, smsc, dcs, tppid, deliver, ts, src, dst, data, m, c, mid):
	s = sms.SMSToMS()
	s._msisdn = msisdn
	s._msisdn_type = 0x91
	s._smsc = smsc
	s._smsc_type = 0x91
	s._tppid = tppid
	s._tpdcs = dcs
	s._timestamp = ts
	s._deliver = deliver
	s.deliver_raw2flags()
	#s.deliver_print()
	s._deliver_udhi = 1
	s.deliver_flags2raw()
	#s.deliver_print()
	s._msg = data
	s._msg_leng = len(data)
	u = sms.SMSUdhPorts(src, dst)
	(s._udh_leng, s._udh) = u.getUdh()
	u2 = sms.SMSUdhConcatMsg(m,c,mid)
	(l, m) = u2.getUdh()
	s._udh = s._udh + m
	s._udh_leng = s._udh_leng + l
	s.encode()
	return s._pdu

# 

if __name__ == "__main__":
#	infile = open("vvm_url.out","r")
	testcase = ''
	ts = Utils.hex2bin("99309251619580",0)

	for line in sys.stdin:
		if(line.find('[')>=0):
			testcase = testcase.rstrip('\n')
			sendWapPush("491776025980", "49177123456", 0x04, 0x00, 0x04, ts, 9200, 2948, testcase)
			print "[end case]"
			testcase=''
		else:
			testcase = testcase + line

	
