#!/Library/Frameworks/Python.framework/Versions/Current/bin/python


#
# Charlie Miller 
#

#
# fuzz only the long text field (payload)
#

from sulley   import *
from requests import smil
import pgraph
import time

########################################################################################################################

class connection (pgraph.edge.edge):
    def __init__ (self, src, dst, callback=None):
        pgraph.edge.edge.__init__(self, src, dst)
        self.callback = callback

class session_file (pgraph.graph):
    def __init__ (self, session_filename=None, skip=0, sleep_time=1.0, log_level=2, proto="tcp", restart_interval=0, timeout=5.0, web_port=26000, crash_threshold=3):
        pgraph.graph.__init__(self)
        self.root       = pgraph.node()
        self.root.name  = "__ROOT_NODE__"
        self.root.label = self.root.name
        self.last_recv  = None
        self.add_node(self.root)
    def log (self, msg, level=1):
        print "[%s] %s" % (time.strftime("%I:%M.%S"), msg)
    def add_node (self, node):
        node.number = len(self.nodes)
        node.id     = len(self.nodes)
        if not self.nodes.has_key(node.id):
            self.nodes[node.id] = node
        return self
    def connect (self, src, dst=None, callback=None):
        if not dst:
            dst = src
            src = self.root
        if type(src) is str:
            src = self.find_node("name", src)
        if type(dst) is str:
            dst = self.find_node("name", dst)
        if src != self.root and not self.find_node("name", src.name):
            self.add_node(src)
        if not self.find_node("name", dst.name):
            self.add_node(dst)
        edge = connection(src.id, dst.id, callback)
        self.add_edge(edge)
        return edge
    def num_mutations (self, this_node=None, path=[]):
        if not this_node:
            this_node                = self.root
            self.total_num_mutations = 0
        for edge in self.edges_from(this_node.id):
            next_node                 = self.nodes[edge.dst]
            self.total_num_mutations += next_node.num_mutations()
            if edge.src != self.root.id:
                path.append(edge)
            self.num_mutations(next_node, path)
        if path:
            path.pop()
        return self.total_num_mutations
    def server_init (self):
        self.total_mutant_index  = 0
        self.total_num_mutations = self.num_mutations()
    def fuzz (self, this_node=None, path=[]):
        if not this_node:
            if not self.edges_from(self.root.id):
                raise sex.error("NO REQUESTS SPECIFIED IN SESSION")
            this_node = self.root
            try:    self.server_init()
            except: return
        for edge in self.edges_from(this_node.id):
            self.fuzz_node = self.nodes[edge.dst]
            num_mutations  = self.fuzz_node.num_mutations()
            if edge.src != self.root.id:
                path.append(edge)
            current_path  = " -> ".join([self.nodes[e.src].name for e in path])
            current_path += " -> %s" % self.fuzz_node.name
            self.log("current fuzz path: %s" % current_path, 2)
            self.log("fuzzed %d of %d total cases" % (self.total_mutant_index, self.total_num_mutations), 2)
            done_with_fuzz_node = False
            crash_count         = 0
            # loop through all possible mutations of the fuzz node.
            while not done_with_fuzz_node:
                if not self.fuzz_node.mutate():
                    self.log("all possible mutations for current fuzz node exhausted", 2)
                    done_with_fuzz_node = True
                    continue
                self.total_mutant_index += 1
                # if we don't need to skip the current test case.
                self.log("fuzzing %d of %d" % (self.fuzz_node.mutant_index, num_mutations), 2)
                while 1:
                    output = ""
                    for e in path:
                        node = self.nodes[e.src]
                        output += node.render()
                    output += self.fuzz_node.render()
                    break
                self.render_rest(self.fuzz_node, output)
            temp = self.nodes[edge.dst]
            self.fuzz(self.fuzz_node, path)
            temp.reset()

        # finished with the last node on the path, pop it off the path stack.
        if path:
            path.pop()

    def render_rest(self, this_node=None, output=""):
            original_output = output
            if(len(self.edges_from(this_node.id)) > 0):
                for edge in self.edges_from(this_node.id):
                    output = original_output
                    output += self.nodes[edge.dst].render()
                    self.render_rest(self.nodes[edge.dst], output)
            else:
                print output



def tobinary(n, bits):
    bStr=''
    while bits:
            bStr = str(n%2) + bStr
            n = n >> 1
	    bits = bits - 1
    return bStr


#
# 7 bit encoding
#
def toint(str):
	ret = 0
	strlen = len(str)
	for i in range(0,strlen):
		if(str[strlen-1-i]=='1'):
			ret = ret + (1<<i)
	return ret


def seven_bit_encoder(string):
	bitstream = ''
	ret = ''
	strlen = len(string)
	for i in range(0,strlen):
		bitstream += tobinary(ord(string[strlen-1-i]), 7)

	i = len(bitstream) - 8
	while (i > 0):
		dword = bitstream[i:i+8]
		temp = "%02x" % toint(dword)
		ret += temp.upper()
		i -= 8
	dword = bitstream[0:i+8]
        temp = "%02x" % toint(dword)
        ret += temp.upper()

	return ret

#
# 8 bit encoding
#
def eight_bit_encoder(string):
        ret = ''
        strlen = len(string)
        for i in range(0,strlen):
                temp = "%02x" % ord(string[i])
		ret += temp.upper()
	return ret

#
# 16 bit encoding
#
def sixteen_bit_encoder(string):
        ret = ''
        strlen = len(string)
        for i in range(0,strlen):
                temp = "00%02x" % ord(string[i])
                ret += temp.upper()
        return ret


# An ndef fuzzer

# ndef record (text): d1 | 01 | 13 | 54 | 02 | 65  6e | 73  75  70  2c  20  75  6c  74  72  61  6c  69  67  68  74  3f | fe
# ndef record (long text): C1 01 00 00 01 2F 54 02 65 6E 61 61 61 61 61 61
# ndef record (something else):

s_initialize("record")
### d1
s_byte(0xc1, format="oct", name="header", full_range=True, fuzzable=False)

### 01
s_size("type block", name="type length", format="oct", length=1, math=lambda x: x/2, fuzzable=False)

if s_block_start("long payload long", dep="header", dep_value=16, dep_compare="&"):
	s_size("payload block", format="oct", length = 4, math=lambda x: x/2, fuzzable=False)
s_block_end()

### 13
if s_block_start("long payload small", dep="header", dep_value=16, dep_compare="!&"):
        s_size("payload block", format="oct", length = 1, math=lambda x: x/2, fuzzable=False)
s_block_end()

if s_block_start("id length block", dep="header", dep_value=8, dep_compare="!&"):
	s_size("id block", name="id length", format="oct", length=1, math=lambda x: x/2, fuzzable=False)
s_block_end()

### 54
if s_block_start("type block"):
	s_string("T", encoding="hex", fuzzable=False)
s_block_end()

if s_block_start("id block", dep="header", dep_value=8, dep_compare="!&"):
	s_string("ID!", encoding="hex", fuzzable=False)
s_block_end()


if s_block_start("payload block"):
	
	s_binary("91 01 05 54 02 65 6E 68 69", encoding="hex")

	if s_block_start("record"):
		s_binary("51 01 0B 55 01 67 6F 6F 67 6C 65 2E 63 6F 6D", encoding="hex")
	s_block_end()

	s_repeat("record", min_reps=1, max_reps=101, step=5)

s_block_end()

##########################
# for testing, remove!!!!#
##########################
#s_byte(0x61, format="oct", fuzzable=True)


#s_size("to_number", format="oct", length=1, math=lambda x: x/2, fuzzable=False)
#if s_block_start("to_number"):
#	s_byte(0x91, format="oct", name="typeofaddress", fuzzable=False)
#	s_string("AAAAAA", max_len = 256, fuzzable=False)
#s_block_end()



fuzz_file = session_file()
fuzz_file.connect(s_get("record"))
fuzz_file.fuzz()

