#!/Library/Frameworks/Python.framework/Versions/Current/bin/python

#
# Makes various NFC related testcases by mutated existing NFC data
# Uncomment the test cases in 'goodies' you want to mutate.
# By Charlie Miller
#

import random
import binascii
import math

goodies = [
# connect pdu for LLCP (first is for npp-server, second is for snep server)
#	"0520060f636f6d2e616e64726f69642e6e7070",
	"0080000385c10200130520060f75726e3a6e66633a736e3a736e6570"

# information pdu for LLCP (first is for npp-server, second is for snep server)
#	"43200001000000010100000017d101135402656e7375702c20756c7472616c414141743f",
#	"132000100200000017d101135402656e48656c6c6f414141416c642121212121",

# type 4 capacity container
#	"000f10005400ff0406e104fffe0000"

# MF UL memory
#	"0000000000000000cd480000e11012000323",

# short text (type 54) - works on 2,4
#	"d101135402656e7375702c20756c7472616c696768743f",

#smart poster (type 53 70) - works 2,4
#	"D1021B537091010B5500676F6F676C652E636F6D5101085405656E2D55536869",

# long text, - works on 4
#	"C1010000012F5402656E616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161616161",


# SMS - (type 55, sms:) - works on 2,4
#	"D101215500736D733A363336333939343739313F626F64793D447564652077616B65207570",
# Dialer (type 55, tel:) - works on 2,4
#	"D1010B550536333633393934373931",

# URN - (type 55, http:) - works on 2,4
#	"D1010C5501676F6F676C652E636F6D2F",

# short vtag - works on 2,4 
#	"d20c6d746578742f782d7643617264424547494e3a56434152440d0a56455253494f4e3a322e310d0a4e3a426172746f77736b693b436875636b3b3b3b0d0a464e3a436875636b20426172746f77736b690d0a454d41494c3b484f4d453a636875636b406275796d6f72652e636f6d0d0a454e443a56434152440d0a",

## vtag - works on 4 
#	"C20C00000173746578742F782D7643617264424547494E3A56434152440D0A56455253494F4E3A332E300D0A464E3A436861726C6965202254686520616E696D616C22204D696C6C65720D0A4E3A4D696C6C65723B436861726C69653B416C667265640D0A4F52473A52657365617263683B4C6162730D0A5449544C453A5072696E636970616C20526573656172636820436F6E73756C74616E740D0A524F4C453A4D656469612077686F72650D0A4144523B545950453D504F5354414C2C50415243454C3A3B3B33363720436F70706572204C616B657320426C76643B4D4F3B3B36333034303B5553410D0A54454C3B545950453D564F4943452C505245463A3633362D3339392D343739310D0A54454C3B545950453D4641583A3633362D3339392D333438320D0A454D41494C3B545950453D494E5445524E45542C505245463A636861726C69652E6D696C6C6572406163637576616E742E636F6D0D0A55524C3A687474705C3A2F2F6163637576616E742E636F6D0D0A454E443A56434152440D0A",

# bluetooth - (type "nokia.com:bt) - can't test, nexus doesn't read it, sc3711 can't read from the emulated tag 
#	"D40C226E6F6B69612E636F6D3A6274010102030405060406803132333435363738393000000000000007436861726C6965"
]


FuzzFactor	= 10 
numcases   	= 2000 

def bit_flip(data):
	global FuzzFactor
	binary = binascii.a2b_hex(data)
	buf = list(binary)
	numwrites=random.randrange(math.ceil((float(len(buf)) / FuzzFactor)))+1
#	numwrites = 0
	for j in range(numwrites):
		rbyte = random.randrange(256)
	     	rn = random.randrange(len(buf))
	       	buf[rn] = "%c"%(rbyte);

	return binascii.hexlify("".join(buf))

def inject(data):
	global FuzzFactor
        binary = binascii.a2b_hex(data)
        buf = list(binary)
     	numwrites=random.randrange(math.ceil((float(len(buf)) / FuzzFactor)))+1
#	numwrites = 0
        for j in range(numwrites):
        	rbyte = random.randrange(256)
               	rn = random.randrange(len(buf))
		temp_str = "%c"%(rbyte);
		temp_buf=buf[:rn]+list(temp_str)+buf[rn:]
		buf = temp_buf
	return binascii.hexlify("".join(buf))

for x in goodies:
	for y in range(numcases):
		if random.randrange(100)>50:
			print inject(x)
		else:
			print bit_flip(x)



