#!/usr/bin/python

import time
import os
import random
import binascii
import subprocess


# this is for emulating type 2 tags with SCL3711 with an n9 talking to it.


#
# popen runs in the background.  close() waits for it to finish
# if you don't call close, I guess it just runs forever
#

ssh = "ssh root@"
bus = ""
device = ""
fd = -1 

# initalization
def init(ipaddy):
	global ssh, bus, device, pidlist
	ssh = ssh+ipaddy+" "

	# figure out what bus/device our usb hub is on
	command = "lsusb"
	c = os.popen(command)
	line = c.read()
	loc = line.find("D-Link Corp. DUB-H7 7-port USB 2.0 hub")
	if loc > 0:
		bus = line[loc-29:loc-26]
		device = line[loc-18:loc-15]
	
	c.close()

	reset_services()

	pidlist = get_pids()
	print "Monitoring"
	for x in pidlist:
		print x + ","

	return True

def create_valid(title):
#	ret = "03"
#	payload_len = 0x1b + len(title)
#	ret += "%02x" % payload_len
	ret = ""
	ret += "d102"
	payload_len = 0x16 + len(title)
	ret += "%02x" % payload_len
	ret += "53709101"
	payload_len = 3 + len(title)
	ret += "%02x" % payload_len
	ret += "5402656e"+binascii.hexlify(title)
	ret += "51010b5501676F6F676C652E636F6D"
	return ret

def disconnect_usb_reader():
	global bus,device
	command = "~/Downloads/hub-ctrl -b "+bus+" -d "+device+" -P 4 -p"
	c = os.popen(command)
	c.close()
#	time.sleep(1)

def connect_usb_reader():
	global bus,device
	command = "~/Downloads/hub-ctrl -b "+bus+" -d "+device+" -P 4 -p 1"
	c = os.popen(command)
	c.close()
	time.sleep(1)

def present_phone():
	global ssh
#	command =  ssh + '"pkill -CONT nfcd"' 
#        c = os.popen(command)
#	c.close()
	return True	

def remove_phone():
	global ssh
#	command = ssh + '"pkill -STOP nfcd"' 
#        c = os.popen(command)
#	c.close()

	reset_services()

	return True	

def start_card_emulation():
	command = "timeout -s 9 -k 5 5 ~/testing/libnfc-1.5.1/utils/nfc-emulate-forum-tag4 test.out 2>/dev/null"
	c = os.popen(command)
	return c

def setup_ndef_for_emulation(ndef):
	#add header
        tag2_memory = ""
	tag2_memory += binascii.unhexlify(ndef)
	temp_file = open("test.out", "w")
	temp_file.write(tag2_memory)
	temp_file.close()
	
def send_ndef(ndef):
#	disconnect_usb_reader() # necessary???
	remove_phone()
#	connect_usb_reader()
	setup_ndef_for_emulation(ndef)
	emulation_fd = start_card_emulation()
	present_phone()
	emulation_fd.close()  
	time.sleep(3)	# 3 worked to 2600.  THIS WORKED, TRYING FASTER:::	time.sleep(4) 
	return True

def get_last_msg():
	global ssh
	command = ssh + '"grep -A1 XXXX /var/log/syslog | tail -1"'
        c = os.popen(command)
        last_msg = c.read()
	c.close()
	the_eq = last_msg.find("goo")
	ret = last_msg[the_eq-13:the_eq-5]
	return ret

def get_service_check(randnum):
	ndef = create_valid("XXXX"+randnum)
	clean_logs()
	send_ndef(ndef)
	return get_last_msg() 

def diff_pidlists(before, after):
	ret = True
	for (b_proc, b_pid) in before.items():
		if b_proc.find("sshd") >= 0:
			continue
		if b_proc.find("ps aux") >= 0:
			continue
		if b_proc.find("/usr/sbin/nfcd") >=0:
			continue 
		if b_proc in after:
			if b_pid != after[b_proc]:
				print "PID of %s changed from %s to %s" % (b_proc, b_pid, after[b_proc]) 
				ret = False
	return ret

def get_pids():
	global ssh
	command = ssh + '"ps aux"'
       	c = os.popen(command)
        pid_listing = c.read()
	c.close()
	pids = {}

	nl = pid_listing.find('\n')
	while nl > 0 and nl != len(pid_listing):
		line = pid_listing[:nl]
		pid = line[:5]
		process = line[15:]
		pids[process] = pid
		pid_listing = pid_listing[nl+1:]
		nl = pid_listing.find('\n')
	return pids

def get_nfcd_pid():
	global ssh
	command = ssh + '"pidof nfcd"'
       	c = os.popen(command)
        pid = c.read()
	c.close()
	return pid

def gdb_file_crash():
	global ssh
	command = ssh + '"cat gdb.txt"'
	c = os.popen(command)
        gdb = c.read()
	c.close()
	pp = gdb.find('Program received')
	if pp>0:
		end = gdb[pp:].find('\n')
		line = gdb[pp:pp+end]
		print line
		if line.find("SEGV") > 0:
			return True
	return False

def check_for_crash(pids):
	global pidlist
	new_pids = get_pids()
	if diff_pidlists(pids, new_pids):
		if gdb_file_crash():
			print "gdb file CRASH"
			return True
		else:
			print " . "
			return False
	else:
		print "pid change CRASH"
		pidlist = new_pids
		return True

def check_for_service():
	randnum = str(random.randrange(10000000, 99999999))
	last_msg = get_service_check(randnum)
	if(last_msg == randnum):
#		print "Passed!"
		return True
	else:
		print "failed! |%s|%s|" % (randnum, last_msg)
		return False

# get next test case
def get_testcase(filename):
	global fd
	if fd == -1:
		fd = file(filename)
	ndef = fd.readline()
	if not ndef:
		return ""
	ndef = ndef[:len(ndef)-1]

	if len(ndef) % 2:
		print "warning half nibble"
		ndef += "0"

#	while(len(ndef)%32):
#		ndef += "00"
	return ndef 

def clean_logs():
	global ssh
	command = ssh + '"> /var/log/syslog"'
	c = os.popen(command)
	c.close()
	
def reset_services():
	global ssh
	command = ssh + '"opensh -c \\\"killall -9 nfcd gdb 2>/dev/null\\\""'	
	c = os.popen(command)
	c.close()
	time.sleep(1)
	command = ssh + '"/usr/sbin/nfcd -l 5"'	
	c = os.popen(command)
	c.close()
	time.sleep(1)
	command = ssh + '"rm -f gdb.txt"'	
	c = os.popen(command)
	c.close()
	command = ssh + '"opensh -c \\\"gdb -x gdb.commands -p \`pidof nfcd\` &\\\""'
	c = os.popen(command)
	c.close()

def restart():
	global ssh
	command = ssh + '"reboot"'	
	c = os.popen(command)
	c.close()
	time.sleep(120)
	reset_services()

def test_ndef(ndef):
	global pidlist
	send_ndef(ndef)
	if check_for_crash(pidlist):
		pass #reset_services()
	counter = 1
	while not check_for_service():
		counter += 1
		print "SERVICE DOWN!!!"
		if counter > 7:
			reset_services()
		if counter > 10:
			disconnect_usb_reader()
			time.sleep(1)
			connect_usb_reader()

def test_casenum(filename, casenum):
	global fd
	ndef = get_testcase(filename)
	testnum=1
	while ndef and testnum <= casenum:
		if testnum==casenum:
			test_ndef(ndef)
		ndef = get_testcase(filename)
		testnum += 1	
	fd.close()
	fd = -1

def test_file(filename):
	ndef = get_testcase(filename)
	testnum = 1
	while ndef:
#		if not testnum % 5:
#			restart()
		print "%d: " % testnum,
		testnum += 1
		test_ndef(ndef)
		ndef = get_testcase(filename)
	print "Finished!"

def test_from(filename, casenum):
        ndef = get_testcase(filename)
        testnum=1
        while ndef and testnum <= casenum:
                if testnum==casenum:
                        while ndef:
                                print "%d: " % testnum,
                                testnum += 1
                                test_ndef(ndef)
                                ndef = get_testcase(filename)
                ndef = get_testcase(filename)
                testnum += 1


#
# testing area
#

init("192.168.1.17")

#ndef = get_testcase("bitflip.out")
#test_ndef(ndef)

test_from("bitflip.out", 14847)
#test_file("bitflip.out")

#test_casenum("bitflip.out", 3791)
#test_casenum("bitflip.out", 3792)
#test_casenum("bitflip.out", 3792)
#test_casenum("bitflip.out", 3793)
#test_casenum("bitflip.out", 1551)
#test_casenum("bitflip.out", 1552)

#b=get_pids()
#a=get_pids()
#diff_pidlists(b,a)

#check_for_service()
#check_for_service()
#check_for_service()

#remove_phone()
#present_phone()

#clear_log()
#remove_phone()
#present_phone()
#print "watching"
#time.sleep(1)
#get_log()


#ndef = create_valid("hi")
#ndef = get_testcase("bitflip.out")
#print ndef
##ndef = get_testcase("bitflip.out")
#print ndef
#ndef = get_testcase("bitflip.out")
#print ndef



#check_for_service()
#print_pids()



