#
#   Copyright (C) Stonesoft Corporation 2010 - 2013.
#   All rights reserved.
#
#   The StoneGate software, manuals, and technical
#   literature may not be reproduced in any form or
#   by any means except by permission in writing from
#   Stonesoft Corporation.
#

# Predator4 webGUI

require 'fileutils'

$webgui_root = File.expand_path( File.dirname( __FILE__ ) )
$webgui_tmp_pcap = "#{$webgui_root}/webgui/tmp/attack.pcap"
Thread.abort_on_exception = true

FileUtils.mkdir_p File.dirname($webgui_tmp_pcap)

require "#{$webgui_root}/lib/util.rb"
require "#{$webgui_root}/webgui/wg_httphandler.rb"
require "#{$webgui_root}/webgui/wg_datastore.rb"
require "#{$webgui_root}/webgui/wg_exploit.rb"

def print_usage()
  puts "Predator4 WebGUI"
  puts "Usage: ruby webgui.rb <options>"
  puts ""
  puts "Options:"
  puts "\t--port=<port> \t\t Server port. Defaults to 8000"
  puts "\t--binary=<path> \t\t Path to binary."
  puts "\t--config=<path> \t\t Path to webgui config. Defaults to './webgui.cfg"
end

# Global parameters
$p4_verifydelay = 1000

@server_port = 8000
@is_evader = false

if File.exists? "./predator4"
  @p4_binary_path = "./predator4"
elsif File.exists? "./evader"
  @p4_binary_path = "./evader"
elsif `which predator4`.strip.size > 0
  @p4_binary_path = `which predator4`.strip
elsif `which evader`.strip.size > 0
  @p4_binary_path = `which evader`.strip
else
  @p4_binary_path = nil
end

@webgui_config_path = nil

ARGV.each do |arg|
  if arg =~ /--port=(\d+)/
    @server_port = $1.to_i()
  elsif arg =~ /--predator4=(.*)/
    @p4_binary_path = $1
  elsif arg =~ /--binary=(.*)/
    @p4_binary_path = $1
  elsif arg =~ /--config=(.*)/
    @webgui_config_path = $1
  else
    puts "* Unrecognized option \"#{arg}\""
    print_usage()
    exit()
  end
end

if @server_port < 0 or @server_port > 0xffff
  puts "* Invalid server port \"#{@server_port}\" - Expected a number between 0 and 0xffff"
  exit()
end

if @p4_binary_path.nil?
  puts "* Binary not found, specify with --binary"
  exit()
elsif not File.exists?( @p4_binary_path )
  puts "* Binary not found from path \"#{@p4_binary_path}\""
  exit()
else
  if @p4_binary_path =~ /evader$/
    $is_evader = true    
  end
end

if not @webgui_config_path.nil? and not File.exists?( @webgui_config_path )
  puts "* WebGUI configuration not found from path \"#{@webgui_config_path}\""
  exit()
end

# Check Predator4 binary and extract everything useful
if not P4WebGUI::DataStore.load_predator4( @p4_binary_path )
  puts "* Failed to extract data from binary \"#{@p4_binary_path}\""
  exit()
else
  puts "* Loaded binary ( \"#{@p4_binary_path}\" )"
end

# Check configuration
if not P4WebGUI::DataStore.load_webgui_config( @webgui_config_path )
  puts "* Failed to parse webgui configuration ) \"#{@webgui_config_path}\""
  exit()
elsif not @webgui_config_path.nil?
  puts "* Loaded webgui configuration( \"#{@webgui_config_path}\" )"
end

puts "* Starting WebGUI on port #{@server_port}"
$uid = "webgui_#{@server_port}"
P4WebGUI::HTTPHandler.run! :host => 'localhost', :port => @server_port

