$(function() {
  Evader.store = {};
  Evader.store.loaded = false;
  Evader.store.identifier = 'evader';

  Evader.store.saveConfiguration = function(configuration) {
    if(store.enabled) {
      store.set(Evader.store.identifier + '.configuration', configuration);
    }
  };
  
  Evader.store.loadConfiguration = function() {
    if(store.enabled) {
      var configuration = store.get(Evader.store.identifier + '.configuration');

      for(var key in configuration) {
        var $input = $('#' + key);

        if($input.is('[type=radio]') || $input.is('[type=checkbox]')) {
          $('#' + key).attr('checked', 'checked').trigger('change');
        } else {
          $input.val(configuration[key]).trigger('change');
        }
      }

      $('.slider').slider({value: $('#mongbat_maxev').val()});
      
      Evader.store.activateChangeEvents();
    }
  };

  Evader.store.loadIPConfiguration = function() {
    if(store.enabled) {
      var configuration = store.get(Evader.store.identifier + '.ip_configuration') || {},
          currentInterface = $('#netconfig_iface').val();
      
      if(configuration[currentInterface]) {
        $('#netconfig_src_ip').val(configuration[currentInterface].netconfig_src_ip);
        $('#netconfig_dst_ip').val(configuration[currentInterface].netconfig_dst_ip);
        $('#netconfig_gateway').val(configuration[currentInterface].netconfig_gateway);
        
        if(configuration[currentInterface].gateway_needed_yes) {
          $('#gateway_needed_yes').attr('checked', 'checked').trigger('change');
          $('#gateway_needed_no').removeAttr('checked');
        } else {
          $('#gateway_needed_no').attr('checked', 'checked').trigger('change');
          $('#gateway_needed_yes').removeAttr('checked');          
        }
      }
    }
  };
  
  Evader.store.saveIPConfiguration = function() {
    if(store.enabled) {
      var configuration = store.get(Evader.store.identifier + '.ip_configuration') || {},
          currentInterface = $('#netconfig_iface').val();

      configuration[currentInterface] = {
        netconfig_src_ip: $('#netconfig_src_ip').val(),
        netconfig_dst_ip: $('#netconfig_dst_ip').val(),
        netconfig_gateway: $('#netconfig_gateway').val()
      }
      configuration[currentInterface][$('.gateway_needed:checked').attr('id')] = true;
    
      store.set(Evader.store.identifier + '.ip_configuration', configuration);
    }
  };

  Evader.store.activateChangeEvents = function() {
    $('#netconfig_iface').live('change', function() {
      if(store.enabled) {
        var configuration = store.get(Evader.store.identifier + '.ip_configuration') || {};

        if(configuration[$(this).val()]) {
          Evader.store.loadIPConfiguration();
        } else {
          Evader.store.saveIPConfiguration();
        }        
      }
    });
    
    $('#netconfig_gateway, #netconfig_src_ip, #netconfig_dst_ip, .gateway_needed').live('change', Evader.store.saveIPConfiguration);

    $('input').live('change', function() {
      var configuration = {};

      $('input').each(function(idx, input) {
        var $input = $(input),
            val = null;

        if($input.is('[type=radio]') || $input.is('[type=checkbox]')) {
          if($input.is(':checked')) {
            val = $input.val();
          }
        } else if($input.is(':not([type=submit])')) {
          val = $input.val();        
        }

        if(val) {
          configuration[$input.attr('id')] = val;        
        }
      });

      Evader.store.saveConfiguration(configuration);
    });    
  };

  Evader.store.loadDefaults = function() {
    $('.attacks input:first').attr('checked', 'checked').trigger('change');
    $('.attack_options input:first').attr('checked', 'checked').trigger('change');
  };

  setTimeout(function() {
    Evader.store.loadDefaults();
    Evader.store.loadConfiguration();
    Evader.store.loadIPConfiguration();
    Evader.store.loaded = true;
    $(document).trigger('evader.configuration_loaded');
  }, 50);
});