module P4WebGUI
  class EvasionParser
    def self.parse(evasions)
      return "" if evasions.nil?
      evasions.map{|evasion, evasion_options|
        next unless evasion_options['enabled']
        
        evasion_cfg_str = "--evasion=#{evasion}"
        if evasion_options['options'] && evasion_options['options'].size > 0
          evasion_options['options'].each do |key, value|
            if value.respond_to?(:join)
              evasion_cfg_str += ",#{value.join('\|')}"
            else
              evasion_cfg_str += ",#{value}"
            end
          end
        end
        evasion_cfg_str
      }.join(' ') + ' '
    end
  end
end