require "spec_helper"

describe "P4WebGUI" do
  describe "Helpers" do
    describe ".blank?" do
      it "returns true if the string is nil" do
        expect(P4WebGUI::Helpers.blank?(nil)).to be(true)
      end
      
      it "returns true if the string is empty" do
        expect(P4WebGUI::Helpers.blank?("")).to be(true)        
      end
      
      it "returns false if the string is not empty" do
        expect(P4WebGUI::Helpers.blank?("a")).to be(false)
      end
    end
    
    describe ".add_to_option_string" do
      it "returns an empty string if the value is nil" do
        expect(P4WebGUI::Helpers.add_to_option_string('abc', nil)).to eql('')
      end
      
      it "returns the parameter if the value is true" do
        expect(P4WebGUI::Helpers.add_to_option_string('abc', 'true')).to eql('--abc ')
      end
      
      it "returns an empty string if the value is false" do
        expect(P4WebGUI::Helpers.add_to_option_string('abc', 'false')).to eql('')
      end
      
      it "raises an exception if the value is something else" do
        expect{P4WebGUI::Helpers.add_to_option_string('abc', 'def')}.to raise_error
      end
    end    
  end
end