# the generator interface

class Generator
  def initialize(attack, use_evasions, ignore_evasions)
    @attack = attack
    @use_evasions = use_evasions
    @ignore_evasions = ignore_evasions
    @use_evasions_order = []
    @use_evasions.each_key do |evasion_name|
      @use_evasions_order.push evasion_name
    end
  end

  # called with an index number
  def generate(index)
    return nil
  end

  # called with index number and result code
  def result(code, index)
  end

  def to_s
    return "Unimplemented"
  end

  # return how may combinations can be generated or nil if the number is not known or cannot be calculated
  def count
    return nil
  end

  # return false if this generator can work with a test queue
  # return true if the workers should pull results
  def pull_mode
    return false
  end

  # override for pull_mode generator to answer yes when no more
  # work is available
  def completed
    raise "Not implemented - needed for pull_mode generator"
  end

  def randseed(evindex)
    a = []
    8.times do
      a.push rand(256)
    end
    return Base64::encode64(a.pack("C*")).chomp.gsub(/=/, "")
  end
end
