$(function() {
  Evader.tree = {};
  
  Evader.tree.checkPath = function($input) {
    /*
     * if we are not checked before click
     *   mark the whole path to root as checked
     *
     * if we are checked
     *   mark the path to root as unchecked up to the point where siblings are also unchecked
     */
     
     var activatePath = function($input) {
       var $parent = $input.parent();
       
       while(!$parent.hasClass('evasions_evtree')) {
         if($parent.is('li')) {
           $parent.children('[type=checkbox]').attr('checked', 'checked');
         }
         $parent = $parent.parent();
       }
     };
     
     var deactivatePath = function($input) {
       var $parent = $input.parent();
  
       if($input.parent().parent().children('li').children('[type=checkbox]:checked').length === 0) {
         while(!$parent.hasClass('evasions_evtree')) {
           if($parent.is('li') && $parent.children('ul').children('li').children('[type=checkbox]:checked').length === 0) {
             $parent.children('[type=checkbox]').removeAttr('checked');
           }
           $parent = $parent.parent();
         }
       }
     };
  
     if($input.is('[type=checkbox]')) {
       if($input.is(':checked')) {
         activatePath($input);
       } else {
         deactivatePath($input);
       }
     } else {
       activatePath($input);       
     }
  };
  
  Evader.tree.isOpen = function($li) {
    var result = false;

    $li.children('ul').each(function(idx, ul) {
      $(ul).children('li').each(function(idx, child) {
        var $child = $(child);
        if($child.hasClass('evtree-closed') || $child.hasClass('evtree-leaf-closed')) {
          result = false;
        } else if($child.hasClass('evtree-open') || $child.hasClass('evtree-leaf-open')) {
          result = true;
        }
      });
    });
    
    return result;    
  };
  
  Evader.tree.toggleNode = function($li, classA, classB, classC, classD) {
    $li.children('ul').each(function(idx, ul) {
      $(ul).children('li').each(function(idx, child) {
        var $child = $(child);

        if($child.hasClass(classA)) {
          $child.removeClass(classA).addClass(classB);
        } else if($child.hasClass(classC)) {
          $child.removeClass(classC).addClass(classD);
  
          $child.children('ul').each(function(idx, ul) {
            $(ul).children().each(function(idx, child) {
              if($(child).hasClass(classC)) {
                $(child).removeClass(classC).addClass(classD);
              }
            });
          });
        }        
      });
    });
  };
  
  Evader.tree.toggle = function(value) {
    var $li = $('#' + value + '_li');

    if(Evader.tree.isOpen($li)) {
      Evader.tree.toggleNode($li, 'evtree-open', 'evtree-closed', 'evtree-leaf-open', 'evtree-leaf-closed');
    } else {
      Evader.tree.toggleNode($li, 'evtree-closed', 'evtree-open', 'evtree-leaf-closed', 'evtree-leaf-open');
    }
  };
  
  Evader.tree.initializeEvents = function() {
    $('.evasions_tree .check_path').change(function(e) {
      e.preventDefault();
      Evader.tree.checkPath($(this));
    });

    $('.evasions_tree .evtree_li_a').click(function(e) {
      e.preventDefault();
      var value = $(this).attr('data-value');
      Evader.tree.toggle(value);
    });
  };
  
  Evader.tree.enable = function() {
    $('.evasions_tree input').removeAttr('disabled');
    if(Evader.tree.originallyDisabled) {
      Evader.tree.originallyDisabled.attr('disabled', 'disabled');
    }
    $('.evasions_tree .protocol').children('input').attr('disabled', 'disabled');
  };
  
  Evader.tree.disable = function() {
    Evader.tree.originallyDisabled = $('.evasions_tree input[disabled=disabled]');
    $('.evasions_tree input').attr('disabled', 'disabled');
  };

  $(document).bind('evader.configuration_loaded', function() {
    Evader.tree.initializeEvents();
    $('[name=mode]').trigger('change');
  });

  $('[name=attack]').change(function(e) {
    var attack = $('[name=attack]:checked').val(),
        $tree = $('.evasions_tree');
    $tree.find('.protocol').hide();
    $tree.find('.protocol[data-attack*=' + attack + ']').show();
    $tree.find('.evasion').children('input[type=checkbox]').removeAttr('checked');
  });
  
  $('[value="CLEAR EVASIONS"]').click(function(e) {
    e.stopPropagation();
    e.preventDefault();
    
    $('li.evasion').children('[type="checkbox"]').removeAttr('checked').trigger('change');
  });
  
  $('[name=mode]').change(function() {
    if($('#mode_evasions').is(':checked')) {
      Evader.tree.enable();
    } else {
      Evader.tree.disable();
    }
  });
});