require 'ipaddr'

module P4WebGUI
  module Helpers
    def self.blank?(string)
      string.nil? || string == ''
    end
    
    def self.add_to_option_string(name, value)
      return "" if value.nil?

      if value == "true"
        "--#{name} "
      elsif value == "false"
        ""
      else
        raise "Invalid exploit URL - #{name} value \"#{value}\" invalid"
      end
    end

    class IPRange
      def initialize(range)
        @first_ip_str = range.split('-').first.strip
        @last_ip_str = range.split('-').last.strip
        @first_ip = IPAddr.new(@first_ip_str)
        @last_ip = IPAddr.new(@last_ip_str)
      end
      
      def workers
        @last_ip.to_i - @first_ip.to_i
      end
      
      def src_ip
        @first_ip
      end
    end
  end
end