/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms.dispatcher;

import com.opensymphony.messagework.jms.util.MessageUtil;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.DefaultComponentManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class MessageDispatcher
implements MessageListener {
    public static final String PROPERTY_NAMESPACE = "messagework_namespace";
    public static final String PROPERTY_ACTION_NAME = "messagework_action";
    public static final String PROPERTY_LOCALE = "messagework_locale";
    private static Map applicationMap = MessageDispatcher.buildApplicationMap();
    private static Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$messagework$jms$dispatcher$MessageDispatcher == null ? (class$com$opensymphony$messagework$jms$dispatcher$MessageDispatcher = MessageDispatcher.class$("com.opensymphony.messagework.jms.dispatcher.MessageDispatcher")) : class$com$opensymphony$messagework$jms$dispatcher$MessageDispatcher));
    protected static ComponentConfiguration componentConfiguration;
    static /* synthetic */ Class class$com$opensymphony$messagework$jms$dispatcher$MessageDispatcher;

    protected static Map buildApplicationMap() {
        HashMap map = new HashMap();
        componentConfiguration = MessageDispatcher.loadConfiguration();
        MessageDispatcher.initializeScopeContext(map, null, "application");
        return Collections.synchronizedMap(map);
    }

    private static void initializeScopeContext(Map context, Map fallbackScope, String scopeName) {
        ComponentManager componentManager = MessageDispatcher.buildComponentManager(fallbackScope);
        componentConfiguration.configure(componentManager, scopeName);
        context.put("com.opensymphony.xwork.interceptor.component.ComponentManager", componentManager);
    }

    private static ComponentManager buildComponentManager(Map fallbackScope) {
        DefaultComponentManager componentManager = new DefaultComponentManager();
        if (fallbackScope != null && fallbackScope.containsKey("com.opensymphony.xwork.interceptor.component.ComponentManager")) {
            ComponentManager fallback = (ComponentManager)fallbackScope.get("com.opensymphony.xwork.interceptor.component.ComponentManager");
            componentManager.setFallback(fallback);
        }
        return componentManager;
    }

    private static ComponentConfiguration loadConfiguration() {
        ComponentConfiguration config = new ComponentConfiguration();
        InputStream configXml = Thread.currentThread().getContextClassLoader().getResourceAsStream("components.xml");
        if (configXml == null) {
            String message = "Unable to find the file components.xml in the classpath.";
            LOG.error((Object)"Unable to find the file components.xml in the classpath.");
            throw new RuntimeException("Unable to find the file components.xml in the classpath.");
        }
        try {
            config.loadFromXml(configXml);
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            throw new RuntimeException("Unable to load component configuration");
        }
        catch (SAXException sae) {
            LOG.error((Object)sae);
            throw new RuntimeException("Unable to load component configuration");
        }
        return config;
    }

    public void onMessage(Message message) {
        Map extraContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing Messsage " + message));
        }
        MapMessage mapMessage = (MapMessage)message;
        try {
            extraContext = this.buildExtraContext((Message)mapMessage);
        }
        catch (JMSException e) {
            throw new XworkException("Caught JMSException while setting up the context map.", (Throwable)e);
        }
        String namespace = (String)extraContext.get(PROPERTY_NAMESPACE);
        String actionName = (String)extraContext.get(PROPERTY_ACTION_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing Action for '" + namespace + actionName + "'"));
        }
        ActionProxy proxy = null;
        try {
            proxy = ActionProxyFactory.getFactory().createActionProxy(namespace, actionName, extraContext);
            proxy.execute();
        }
        catch (XworkException e) {
            LOG.error((Object)"Could not find action", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not execute action", (Throwable)e);
            throw new XworkException((Throwable)e);
        }
    }

    protected Map buildExtraContext(Message message) throws JMSException {
        Map messageProperties = this.buildMessageProperties(message);
        HashMap<String, Object> extraContext = new HashMap<String, Object>(messageProperties);
        Map session = this.getSession(message);
        Map params = this.buildParams(message);
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", params);
        extraContext.put("com.opensymphony.xwork.ActionContext.session", session);
        extraContext.put("com.opensymphony.xwork.ActionContext.application", applicationMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.locale", this.getLocale(message));
        ComponentManager componentManager = MessageDispatcher.buildComponentManager(session);
        extraContext.put("com.opensymphony.xwork.interceptor.component.ComponentManager", componentManager);
        params.put("DefaultComponentManager", componentManager);
        extraContext.put("com.opensymphony.messagework.jms.MessageActionContext.Message", message);
        MessageDispatcher.initializeScopeContext(extraContext, session, "request");
        return extraContext;
    }

    private Map buildMessageProperties(Message message) throws JMSException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration propertiesEnum = message.getPropertyNames();
        while (propertiesEnum.hasMoreElements()) {
            String propertyName = (String)propertiesEnum.nextElement();
            if (propertyName.startsWith("SESSION_")) continue;
            properties.put(propertyName, message.getObjectProperty(propertyName));
        }
        return properties;
    }

    protected Locale getLocale(Message message) throws JMSException {
        Locale locale = MessageUtil.getLocale(message);
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    protected Map getSession(Message message) throws JMSException {
        Map session = MessageUtil.getSession(message);
        MessageDispatcher.initializeScopeContext(session, applicationMap, "session");
        return session;
    }

    protected Map buildParams(Message message) throws JMSException {
        MapMessage mapMessage = (MapMessage)message;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration keys = mapMessage.getMapNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            params.put(key, mapMessage.getObject(key));
        }
        return params;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

