/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.webFlow.collectors;

import com.opensymphony.webwork.webFlow.JarFileFilter;
import com.opensymphony.webwork.webFlow.collectors.ArbitraryXMLConfigurationProvider;
import com.opensymphony.webwork.webFlow.collectors.Collector;
import com.opensymphony.webwork.webFlow.entities.XWorkCommand;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebWork2Collector
implements Collector {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$webwork$webFlow$collectors$WebWork2Collector == null ? (class$com$opensymphony$webwork$webFlow$collectors$WebWork2Collector = WebWork2Collector.class$("com.opensymphony.webwork.webFlow.collectors.WebWork2Collector")) : class$com$opensymphony$webwork$webFlow$collectors$WebWork2Collector));
    private String basePath = "";
    private URLClassLoader classLoader;
    private Configuration config = null;
    static /* synthetic */ Class class$com$opensymphony$webwork$webFlow$collectors$WebWork2Collector;

    public Map getPackages() {
        HashMap packages = new HashMap();
        if (this.config != null) {
            Set packageNames = this.config.getPackageConfigNames();
            Iterator iter = packageNames.iterator();
            while (iter.hasNext()) {
                HashMap<String, XWorkCommand> pkgCommands = new HashMap<String, XWorkCommand>();
                String pkgName = (String)iter.next();
                PackageConfig pkgConfig = this.config.getPackageConfig(pkgName);
                Map resultConfigs = pkgConfig.getGlobalResultConfigs();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(pkgName + "=" + pkgConfig));
                }
                Set resultNames = resultConfigs.keySet();
                Iterator iterator = resultNames.iterator();
                while (iterator.hasNext()) {
                    String resultName = (String)iterator.next();
                    ResultConfig resultConfig = (ResultConfig)resultConfigs.get(resultName);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)(" - result " + resultName + "=" + resultConfig.getParams()));
                }
                Map actionConfigMap = pkgConfig.getAllActionConfigs();
                Set actionNames = actionConfigMap.keySet();
                Iterator iterator2 = actionNames.iterator();
                while (iterator2.hasNext()) {
                    String actionName = (String)iterator2.next();
                    ActionConfig actionConfig = (ActionConfig)actionConfigMap.get(actionName);
                    XWorkCommand command = new XWorkCommand(actionConfig, this.basePath);
                    command.setName(actionName);
                    command.setNamespace(pkgConfig.getNamespace());
                    pkgCommands.put(actionName, command);
                }
                packages.put(pkgName, pkgCommands);
            }
        }
        return packages;
    }

    public void setBasePath(String basePath) throws IOException {
        this.basePath = basePath;
        String configFilePath = this.basePath + "WEB-INF/classes/xwork.xml";
        File configFile = new File(configFilePath);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("can read config file? " + configFile.canRead()));
        }
        ArbitraryXMLConfigurationProvider configProvider = new ArbitraryXMLConfigurationProvider(configFile.getCanonicalPath());
        ConfigurationManager.addConfigurationProvider((ConfigurationProvider)configProvider);
        this.config = ConfigurationManager.getConfiguration();
    }

    public void initClassLoader(String basePathString) {
        LOG.debug((Object)("basePathString=" + basePathString));
        URL[] classPathURLs = new URL[100];
        try {
            URL classPathURL;
            classPathURLs[0] = classPathURL = new URL("file://" + basePathString);
            String libPath = this.basePath + "WEB-INF/lib/";
            File libDir = new File(libPath);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("libDir=" + libDir));
            }
            if (libDir != null && libDir.isDirectory()) {
                JarFileFilter jarFilter = new JarFileFilter(".*\\.jar");
                File[] jars = libDir.listFiles(jarFilter);
                for (int i = 0; i < jars.length; ++i) {
                    URL jarURL;
                    File jar = jars[i];
                    if (jar.getName().matches("commons-logging.*") || jar.getName().matches("xwork.*") || jar.getName().matches("webwork.*")) continue;
                    String jarPath = "file://" + jar.getCanonicalPath();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("jarPath=" + jarPath));
                    }
                    classPathURLs[i + 1] = jarURL = new URL(jarPath);
                }
            }
        }
        catch (MalformedURLException e1) {
            LOG.error((Object)"MalformedURLException", (Throwable)e1);
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", (Throwable)e);
        }
        this.classLoader = URLClassLoader.newInstance(classPathURLs);
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

