/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.webFlow.renderers;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.webFlow.XWorkConfigRetriever;
import com.opensymphony.webwork.webFlow.entities.View;
import com.opensymphony.webwork.webFlow.renderers.Renderer;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DOTRenderer
implements Renderer {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$webwork$webFlow$renderers$DOTRenderer == null ? (class$com$opensymphony$webwork$webFlow$renderers$DOTRenderer = DOTRenderer.class$("com.opensymphony.webwork.webFlow.renderers.DOTRenderer")) : class$com$opensymphony$webwork$webFlow$renderers$DOTRenderer));
    private String output;
    static /* synthetic */ Class class$com$opensymphony$webwork$webFlow$renderers$DOTRenderer;
    static /* synthetic */ Class class$com$opensymphony$xwork$ActionChainResult;

    public DOTRenderer(String output) {
        this.output = output;
    }

    public void render() {
        DotGraph graph = new DotGraph();
        graph.attribute("action", "color", "coral1");
        graph.attribute("view", "color", "darkseagreen2");
        graph.attribute("start", "color", "gold");
        graph.attribute("start", "shape", "octagon");
        HashMap<String, View> viewMap = new HashMap<String, View>();
        Set namespaces = XWorkConfigRetriever.getNamespaces();
        Iterator iter = namespaces.iterator();
        while (iter.hasNext()) {
            String namespace = (String)iter.next();
            Set actionNames = XWorkConfigRetriever.getActionNames(namespace);
            Iterator iterator = actionNames.iterator();
            while (iterator.hasNext()) {
                String actionName = (String)iterator.next();
                ActionConfig actionConfig = XWorkConfigRetriever.getActionConfig(namespace, actionName);
                String action = namespace + "/" + actionName + "." + Configuration.get((String)"webwork.action.extension");
                graph.add_node("action", action, actionName);
                Set resultNames = actionConfig.getResults().keySet();
                Iterator iterator2 = resultNames.iterator();
                while (iterator2.hasNext()) {
                    String location;
                    String resultName = (String)iterator2.next();
                    ResultConfig resultConfig = (ResultConfig)actionConfig.getResults().get(resultName);
                    String resultClassName = resultConfig.getClassName();
                    if (resultClassName.equals((class$com$opensymphony$xwork$ActionChainResult == null ? DOTRenderer.class$("com.opensymphony.xwork.ActionChainResult") : class$com$opensymphony$xwork$ActionChainResult).getName())) continue;
                    if (resultClassName.indexOf("Dispatcher") != -1 || resultClassName.indexOf("Velocity") != -1 || resultClassName.indexOf("Freemarker") != -1) {
                        if (resultConfig.getParams().get("location") == null) continue;
                        location = this.getViewLocation((String)resultConfig.getParams().get("location"), namespace);
                        if (location.endsWith((String)Configuration.get((String)"webwork.action.extension"))) {
                            this.addLink(action, location.substring(1), resultConfig.getName(), graph);
                            continue;
                        }
                        graph.add_node("view", location, null);
                        graph.add_link(action, location, resultConfig.getName());
                        View viewFile = XWorkConfigRetriever.getView(namespace, actionName, resultName);
                        if (viewFile == null) continue;
                        viewMap.put(location, viewFile);
                        continue;
                    }
                    if (resultClassName.indexOf("Jasper") != -1 || resultClassName.indexOf("XSLT") != -1 || resultClassName.indexOf("Redirect") == -1 || !(location = this.getViewLocation((String)resultConfig.getParams().get("location"), namespace)).endsWith((String)Configuration.get((String)"webwork.action.extension"))) continue;
                    this.addLink(action, location.substring(1), resultConfig.getName(), graph);
                }
            }
        }
        Iterator iterator = viewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String view = (String)entry.getKey();
            View viewFile = (View)entry.getValue();
            Set targets = viewFile.getTargets();
            Iterator iterator1 = targets.iterator();
            while (iterator1.hasNext()) {
                String viewTarget = (String)iterator1.next();
                try {
                    if (!viewTarget.startsWith("/") && view.lastIndexOf(47) >= 1) {
                        viewTarget = view.substring(1, view.lastIndexOf(47)) + "/" + viewTarget;
                    }
                    this.addLink(view, viewTarget, "", graph);
                }
                catch (Throwable e) {
                    System.out.println("Problem with view " + view + " and target " + viewTarget);
                }
            }
        }
        try {
            FileWriter out = new FileWriter(this.output + "/out.dot");
            out.write(graph.to_s(true));
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addLink(String view, String target, String label, DotGraph graph) {
        int bang = target.indexOf(33);
        if (bang != -1) {
            String command = target.substring(bang + 1, target.lastIndexOf(46));
            String action = target.substring(0, bang) + target.substring(target.lastIndexOf(46));
            graph.add_link(view, "/" + action, label + "\\n(!" + command + ")");
        } else {
            graph.add_link(view, "/" + target, label);
        }
    }

    private String getViewLocation(String location, String namespace) {
        String view = null;
        view = !location.startsWith("/") ? namespace + "/" + location : location;
        if (view.indexOf(63) != -1) {
            view = view.substring(0, view.indexOf(63));
        }
        return view;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DotGraph {
        Map clusters = new HashMap();
        Map links;
        Map attributes;

        public DotGraph() {
            this.clusters.put("default", new HashMap());
            this.links = new HashMap();
            this.attributes = new HashMap();
        }

        public void add_node(String type, String name, String label) {
            String[] ret = this.split_cluster(name);
            String cluster = ret[0];
            name = ret[1];
            HashMap<String, Object[]> nodes = (HashMap<String, Object[]>)this.clusters.get(cluster);
            if (nodes == null) {
                nodes = new HashMap<String, Object[]>();
                this.clusters.put(cluster, nodes);
            }
            if (label == null) {
                label = name;
            }
            HashMap<String, String> nodeParams = new HashMap<String, String>(1);
            nodes.put(name, new Object[]{type, nodeParams});
            nodeParams.put("label", label);
        }

        public void add_link(String source, String dest, String label) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("label", label);
            this.links.put(new String[]{this.x(source), this.x(dest)}, new Object[]{"link", attrs});
        }

        public String x(String y) {
            String[] cluster = this.split_cluster(y);
            return cluster[0] + "/" + cluster[1];
        }

        public void attribute(String type, String name, String value) {
            Map<String, String> params = null;
            if (this.attributes.get(type) == null) {
                params = new HashMap();
                this.attributes.put(type, params);
            } else {
                params = (Map)this.attributes.get(type);
            }
            params.put(name, value);
        }

        public String to_s(boolean include_attributes) {
            Object[] attributes;
            Map.Entry entry;
            StringBuffer result = new StringBuffer();
            result.append("digraph mygraph {\n");
            if (include_attributes) {
                result.append("  fontsize=10;\n");
                result.append("  fontname=helvetica;\n");
                result.append("  node [fontsize=10, fontname=helvetica, style=filled, shape=rectangle]\n");
                result.append("  edge [fontsize=10, fontname=helvetica]\n");
            }
            Map defaultCluster = (Map)this.clusters.get("default");
            Iterator iterator = defaultCluster.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String name = (String)entry.getKey();
                attributes = (Object[])entry.getValue();
                result.append("  default_" + this.c(name) + " ");
                if (include_attributes) {
                    result.append(this.write_attributes((Map)attributes[1], (String)attributes[0]));
                }
                result.append(";\n");
            }
            iterator = this.clusters.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String cluster = (String)entry.getKey();
                Map nodes = (Map)entry.getValue();
                if ("default".equals(cluster)) continue;
                result.append("  subgraph cluster_" + this.c(cluster) + " {\n");
                if (include_attributes) {
                    result.append("    color=grey;\n");
                    result.append("    fontcolor=grey;\n");
                    result.append("    label=\"" + cluster + "\";\n");
                }
                Iterator iterator1 = nodes.entrySet().iterator();
                while (iterator1.hasNext()) {
                    Map.Entry entry1 = iterator1.next();
                    String name = (String)entry1.getKey();
                    Object[] attributes2 = (Object[])entry1.getValue();
                    result.append("    " + this.c(cluster) + "_" + this.c(name) + " ");
                    if (include_attributes) {
                        result.append(this.write_attributes((Map)attributes2[1], (String)attributes2[0]));
                    }
                    result.append(";\n");
                }
                result.append("  }\n");
            }
            iterator = this.links.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String[] link = (String[])entry.getKey();
                attributes = (Object[])entry.getValue();
                result.append("  " + this.c(link[0]) + " -> " + this.c(link[1]) + " ");
                if (include_attributes) {
                    result.append(this.write_attributes((Map)attributes[1], (String)attributes[0]));
                }
                result.append(";\n");
            }
            result.append("}\n");
            return result.toString();
        }

        String[] split_cluster(String name) {
            String[] cluster = new String[2];
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (name.matches(".*\\/.*")) {
                cluster = name.split("\\/", 2);
            } else {
                cluster[0] = "default";
                cluster[1] = name;
            }
            return cluster;
        }

        String c(String str) {
            return str.replaceAll("[\\.\\/\\-\\$\\{\\}]", "_");
        }

        String write_attributes(Map attributes, String type) {
            StringBuffer result = new StringBuffer();
            result.append('[');
            Iterator iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                result.append(key + "=\"" + value + "\",");
            }
            Map extra_attributes = (Map)this.attributes.get(type);
            if (extra_attributes != null) {
                Iterator iterator2 = extra_attributes.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    result.append(key + "=\"" + value + "\",");
                }
            }
            result.deleteCharAt(result.length() - 1);
            result.append(']');
            String toString = result.toString();
            if (toString.equals("]")) {
                toString = "";
            }
            return toString;
        }
    }
}

