/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms;

import com.opensymphony.messagework.jms.ActionMessageSender;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMessageAction
implements Action {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$messagework$jms$SendMessageAction == null ? (class$com$opensymphony$messagework$jms$SendMessageAction = SendMessageAction.class$("com.opensymphony.messagework.jms.SendMessageAction")) : class$com$opensymphony$messagework$jms$SendMessageAction));
    private XWorkConverter converter = XWorkConverter.getInstance();
    private ActionMessageSender actionMessageSender;
    private String namespace;
    private String actionName;
    private boolean waitForResponse = false;
    private int timeout = -1;
    static /* synthetic */ Class class$com$opensymphony$messagework$jms$SendMessageAction;
    static /* synthetic */ Class class$java$lang$String;

    public void setWaitForResponse(boolean waitForResponse) {
        this.waitForResponse = waitForResponse;
    }

    public void setActionMessageSender(ActionMessageSender actionMessageSender) {
        this.actionMessageSender = actionMessageSender;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String execute() throws Exception {
        LOG.debug((Object)("Sending a message to " + this.namespace + "/" + this.actionName));
        Map requestParams = ActionContext.getContext().getParameters();
        Map params = this.buildSingleValuedMap(requestParams);
        this.actionMessageSender.setNamespace(this.namespace);
        TextMessage message = null;
        try {
            if (this.waitForResponse) {
                LOG.debug((Object)("Sending Message and waiting for a response for " + this.timeout + "ms (-1 means no timeout)."));
                message = (TextMessage)this.actionMessageSender.sendActionMessageAndGetResponse(this.actionName, params, this.timeout);
                return message.getText();
            }
            LOG.debug((Object)"Sending Message and not waiting for a response.");
            this.actionMessageSender.sendActionMessage(this.actionName, params);
            return "success";
        }
        catch (Exception e) {
            LOG.error((Object)"Caught an error while sending message.", (Throwable)e);
            return "error";
        }
    }

    Map buildSingleValuedMap(Map requestParams) {
        HashMap params = new HashMap();
        Map context = ActionContext.getContext().getContextMap();
        Iterator iterator = requestParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String val = (String)this.converter.convertValue(context, null, null, null, entry.getValue(), class$java$lang$String == null ? SendMessageAction.class$("java.lang.String") : class$java$lang$String);
            if (val == null) continue;
            params.put(entry.getKey(), val);
        }
        return params;
    }

    public String doDefault() {
        return "input";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

