/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms.util;

import com.opensymphony.messagework.jms.util.ConvertingMap;
import com.opensymphony.messagework.jms.util.UnconvertedValue;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageUtil {
    public static final String SESSION_PROPERTY_PREFIX = "SESSION_";
    public static final String CONVERTED_SESSION_PROPERTIES = "CONVERTED_SESSION_PROPS";
    public static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$messagework$jms$util$MessageUtil == null ? (class$com$opensymphony$messagework$jms$util$MessageUtil = MessageUtil.class$("com.opensymphony.messagework.jms.util.MessageUtil")) : class$com$opensymphony$messagework$jms$util$MessageUtil));
    private static final String STRING_CLASS_DELIMETER = "||:||";
    private static final XWorkConverter CONVERTER = XWorkConverter.getInstance();
    static /* synthetic */ Class class$com$opensymphony$messagework$jms$util$MessageUtil;
    static /* synthetic */ Class class$java$lang$String;

    private MessageUtil() {
    }

    public static void setLocale(Message message, Locale locale) throws JMSException {
        message.setStringProperty("messagework_locale", locale.toString());
    }

    public static void setActionName(Message message, String actionName) throws JMSException {
        message.setStringProperty("messagework_action", actionName);
    }

    public static String getNamespace(Message message) throws JMSException {
        return message.getStringProperty("messagework_namespace");
    }

    public static void setNamespace(Message message, String namespace) throws JMSException {
        message.setStringProperty("messagework_namespace", namespace);
    }

    public static Map getSession(Message message) throws JMSException {
        String convertedProps = message.getStringProperty(CONVERTED_SESSION_PROPERTIES);
        Set convertedPropNames = convertedProps == null ? Collections.EMPTY_SET : MessageUtil.buildConvertedPropertyNames(convertedProps);
        ConvertingMap map = new ConvertingMap();
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            Object value;
            String propertyName = (String)propertyNames.nextElement();
            if (!propertyName.startsWith(SESSION_PROPERTY_PREFIX)) continue;
            String sessionKey = propertyName.substring(8);
            if (convertedPropNames.contains(propertyName)) {
                String convertedString = message.getStringProperty(propertyName);
                value = new UnconvertedValue(convertedString);
            } else {
                value = message.getObjectProperty(propertyName);
            }
            map.put(sessionKey, value);
        }
        return map;
    }

    static Object rebuildConvertedObject(String convertedString) {
        Class<?> clazz;
        int delimIndex = convertedString.indexOf(STRING_CLASS_DELIMETER);
        if (delimIndex < 0) {
            LOG.warn((Object)("Got a converted session object string without a class name: " + convertedString));
            return convertedString;
        }
        if (delimIndex == 0) {
            return null;
        }
        String stringValue = convertedString.substring(0, delimIndex);
        int classStartIndex = delimIndex + STRING_CLASS_DELIMETER.length();
        if (classStartIndex >= convertedString.length()) {
            LOG.warn((Object)("Got a converted session object string with an empty class name: " + convertedString));
            return stringValue;
        }
        String className = convertedString.substring(classStartIndex);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Got a converted session object with a class name which could not be found: " + convertedString), (Throwable)e);
            return null;
        }
        try {
            Map context = ActionContext.getContext().getContextMap();
            Object value = CONVERTER.convertValue(context, null, null, null, (Object)stringValue, clazz);
            return value;
        }
        catch (Exception e) {
            LOG.error((Object)("Caught an exception while converting session string value '" + stringValue + "' to class " + className), (Throwable)e);
            return null;
        }
    }

    static Set buildConvertedPropertyNames(String convertedProps) {
        HashSet<String> names = new HashSet<String>();
        StringTokenizer splitter = new StringTokenizer(convertedProps, ",");
        while (splitter.hasMoreTokens()) {
            String propertyName = splitter.nextToken();
            if (propertyName == null || propertyName.length() <= 0) continue;
            names.add(propertyName);
        }
        return names;
    }

    public static void setSession(Message message, Map sessionMap) throws JMSException {
        if (sessionMap == null) {
            return;
        }
        StringBuffer convertedProps = new StringBuffer();
        Iterator iterator = sessionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            if (key.equals("com.opensymphony.xwork.interceptor.component.ComponentManager")) continue;
            Object value = entry.getValue();
            String sessionKey = SESSION_PROPERTY_PREFIX + key.toString();
            if (value instanceof Number || value instanceof Character || value instanceof Boolean || value instanceof String) {
                message.setObjectProperty(sessionKey, value);
                continue;
            }
            String stringRepresentation = MessageUtil.buildSessionStringRepresentation(value);
            message.setObjectProperty(sessionKey, (Object)stringRepresentation);
            convertedProps.append(sessionKey + ",");
        }
        if (convertedProps.length() > 0) {
            message.setStringProperty(CONVERTED_SESSION_PROPERTIES, convertedProps.toString());
        }
    }

    static String buildSessionStringRepresentation(Object value) {
        Map context = ActionContext.getContext().getContextMap();
        String stringVersion = (String)CONVERTER.convertValue(context, null, null, null, value, class$java$lang$String == null ? (class$java$lang$String = MessageUtil.class$("java.lang.String")) : class$java$lang$String);
        String stringRepresentation = stringVersion + STRING_CLASS_DELIMETER + value.getClass().getName();
        return stringRepresentation;
    }

    public static Locale getLocale(Message message) throws JMSException {
        Locale locale = null;
        String localeStr = message.getStringProperty("messagework_locale");
        if (TextUtils.stringSet((String)localeStr)) {
            locale = MessageUtil.localeFromString(localeStr);
        }
        return locale;
    }

    private static Locale localeFromString(String localeStr) {
        if (localeStr == null || localeStr.trim().length() == 0 || localeStr.equals("_")) {
            return Locale.getDefault();
        }
        int index = localeStr.indexOf(95);
        if (index < 0) {
            return new Locale(localeStr);
        }
        String language = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language);
        }
        if ((index = (localeStr = localeStr.substring(index + 1)).indexOf(95)) < 0) {
            return new Locale(language, localeStr);
        }
        String country = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language, country);
        }
        localeStr = localeStr.substring(index + 1);
        return new Locale(language, country, localeStr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

