/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Library;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.BooleanConverter;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class Column {
    public HsqlNameManager.HsqlName columnName;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    long identityStart;
    long identityIncrement;
    static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigDecimal BIG_DECIMAL_0 = new BigDecimal(0.0);
    static final BigDecimal BIG_DECIMAL_1 = new BigDecimal(1.0);
    private static Collator i18nCollator = Collator.getInstance();
    static boolean sql_compare_in_locale = false;

    Column(HsqlNameManager.HsqlName hsqlName, boolean bl, int n, int n2, int n3, boolean bl2, long l, long l2, boolean bl3, Expression expression) throws HsqlException {
        this.columnName = hsqlName;
        this.isNullable = bl;
        this.colType = n;
        this.colSize = n2;
        this.colScale = n3;
        this.isIdentity = bl2;
        this.identityStart = l;
        this.identityIncrement = l2;
        this.isPrimaryKey = bl3;
        this.defaultExpression = expression;
        if (this.isIdentity && n == 4 && (this.identityStart > Integer.MAX_VALUE || this.identityIncrement > Integer.MAX_VALUE)) {
            throw Trace.error(65, hsqlName.statementName);
        }
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void setNullable(boolean bl) {
        this.isNullable = bl;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    Object getDefaultValue(Session session) throws HsqlException {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.colType);
    }

    String getDefaultDDL() {
        String string = null;
        try {
            string = this.defaultExpression == null ? null : this.defaultExpression.getDDL();
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        return string;
    }

    Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    int getType() {
        return this.colType;
    }

    int getDIType() {
        return this.colType == 100 ? 12 : this.colType;
    }

    int getDITypeSub() {
        if (this.colType == 100) {
            return 4;
        }
        return 1;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static Object add(Object object, Object object2, int n) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d + d2));
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)object + (String)object2;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.add(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return ValuePool.getInt(n2 + n3);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return ValuePool.getLong(l + l2);
            }
        }
        throw Trace.error(20, Types.getTypeString(n));
    }

    static Object concat(Object object, Object object2) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        return Column.convertObject(object) + Column.convertObject(object2);
    }

    static Object negate(Object object, int n) throws HsqlException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = -((Number)object).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return ValuePool.getInt(-((Number)object).intValue());
            }
            case -5: {
                return ValuePool.getLong(-((Number)object).longValue());
            }
        }
        throw Trace.error(20, Types.getTypeString(n));
    }

    static Object multiply(Object object, Object object2, int n) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Number) || !(object2 instanceof Number)) {
            object = Column.convertObject(object2, n);
            object2 = Column.convertObject(object2, n);
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d * d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.multiply(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return ValuePool.getInt(n2 * n3);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return ValuePool.getLong(l * l2);
            }
        }
        throw Trace.error(20, Types.getTypeString(n));
    }

    static Object divide(Object object, Object object2, int n) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d / d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                int n2 = bigDecimal.scale() > bigDecimal2.scale() ? bigDecimal.scale() : bigDecimal2.scale();
                return bigDecimal2.signum() == 0 ? null : bigDecimal.divide(bigDecimal2, n2, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                Trace.check(n4 != 0, 6);
                return ValuePool.getInt(n3 / n4);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return l2 == 0L ? null : ValuePool.getLong(l / l2);
            }
        }
        throw Trace.error(20, Types.getTypeString(n));
    }

    static Object subtract(Object object, Object object2, int n) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d - d2));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.subtract(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return ValuePool.getInt(n2 - n3);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return ValuePool.getLong(l - l2);
            }
        }
        throw Trace.error(20, Types.getTypeString(n));
    }

    static void setCompareInLocal(boolean bl) {
        sql_compare_in_locale = bl;
    }

    static int compare(Object object, Object object2, int n) throws HsqlException {
        int n2 = 0;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare((String)object, (String)object2);
                    break;
                }
                n2 = ((String)object).compareTo((String)object2);
                break;
            }
            case 1: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare(Library.rtrim((String)object), Library.rtrim((String)object2));
                    break;
                }
                n2 = Library.rtrim((String)object).compareTo(Library.rtrim((String)object2));
                break;
            }
            case 100: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare(((String)object).toUpperCase(), ((String)object2).toUpperCase());
                    break;
                }
                n2 = ((String)object).toUpperCase().compareTo(((String)object2).toUpperCase());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return n3 > n4 ? 1 : (n4 > n3 ? -1 : 0);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return l > l2 ? 1 : (l2 > l ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return d > d2 ? 1 : (d2 > d ? -1 : 0);
            }
            case 2: 
            case 3: {
                n2 = ((BigDecimal)object).compareTo((BigDecimal)object2);
                break;
            }
            case 91: {
                if (((Date)object).after((Date)object2)) {
                    return 1;
                }
                if (((Date)object).before((Date)object2)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                return HsqlDateTime.compare((Time)object, (Time)object2);
            }
            case 93: {
                if (((Timestamp)object).after((Timestamp)object2)) {
                    return 1;
                }
                if (((Timestamp)object).before((Timestamp)object2)) {
                    return -1;
                }
                return 0;
            }
            case 16: {
                boolean bl = (Boolean)object;
                boolean bl2 = (Boolean)object2;
                return bl == bl2 ? 0 : (bl2 ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof Binary && object2 instanceof Binary) {
                    n2 = Column.compareTo(((Binary)object).getBytes(), ((Binary)object2).getBytes());
                    break;
                }
                throw Trace.error(95, Types.getTypeString(n));
            }
            case 1111: {
                return 0;
            }
            default: {
                throw Trace.error(95, Types.getTypeString(n));
            }
        }
        return n2 == 0 ? 0 : (n2 < 0 ? -1 : 1);
    }

    static String convertObject(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Object convertObject(Object object, int n) throws HsqlException {
        try {
            if (object == null) {
                return null;
            }
            switch (n) {
                case 0: {
                    return null;
                }
                case -6: {
                    int n2;
                    if (object instanceof Boolean) {
                        return (Boolean)object != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        n2 = Integer.parseInt((String)object);
                        object = ValuePool.getInt(n2);
                    }
                    if (object instanceof Integer) {
                        n2 = ((Number)object).intValue();
                        if (127 < n2 || n2 < -128) {
                            throw Trace.error(65);
                        }
                        return object;
                    }
                    if (object instanceof Byte) {
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (!(object instanceof Number)) break;
                    return Column.convertObject(Column.convertToInt(object), n);
                }
                case 5: {
                    int n3;
                    if (object instanceof Boolean) {
                        return (Boolean)object != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        n3 = Integer.parseInt((String)object);
                        object = ValuePool.getInt(n3);
                    }
                    if (object instanceof Integer) {
                        n3 = ((Number)object).intValue();
                        if (Short.MAX_VALUE < n3 || n3 < Short.MIN_VALUE) {
                            throw Trace.error(65);
                        }
                        return object;
                    }
                    if (object instanceof Byte || object instanceof Short) {
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (!(object instanceof Number)) break;
                    return Column.convertObject(Column.convertToInt(object), n);
                }
                case 4: {
                    if (object instanceof Boolean) {
                        return (Boolean)object != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                    }
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        int n4 = Integer.parseInt((String)object);
                        return ValuePool.getInt(n4);
                    }
                    if (object instanceof Long) {
                        long l = ((Number)object).longValue();
                        if (Integer.MAX_VALUE < l || l < Integer.MIN_VALUE) {
                            throw Trace.error(65);
                        }
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Number) {
                        return Column.convertToInt(object);
                    }
                    if (!(object instanceof Boolean)) break;
                    return ValuePool.getInt((Boolean)object != false ? 1 : 0);
                }
                case -5: {
                    if (object instanceof Boolean) {
                        return (Boolean)object != false ? ValuePool.getLong(1L) : ValuePool.getLong(0L);
                    }
                    if (object instanceof Long) {
                        return object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        long l = Long.parseLong((String)object);
                        return ValuePool.getLong(l);
                    }
                    if (object instanceof Integer) {
                        return ValuePool.getLong(((Integer)object).longValue());
                    }
                    if (!(object instanceof Number)) break;
                    return Column.convertToLong(object);
                }
                case 6: 
                case 7: 
                case 8: {
                    if (object instanceof Boolean) {
                        return (Boolean)object != false ? ValuePool.getDouble(1L) : ValuePool.getDouble(0L);
                    }
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        double d = new Double((String)object);
                        long l = Double.doubleToLongBits(d);
                        return ValuePool.getDouble(l);
                    }
                    if (!(object instanceof Number)) break;
                    return Column.convertToDouble(object);
                }
                case 2: 
                case 3: {
                    if (object instanceof Boolean) {
                        return (Boolean)object != false ? BIG_DECIMAL_1 : BIG_DECIMAL_0;
                    }
                    if (!(object instanceof BigDecimal)) break;
                    return object;
                }
                case 16: {
                    if (object instanceof Boolean) {
                        return (Boolean)object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        return BooleanConverter.getBoolean((String)object);
                    }
                    if (object instanceof Integer) {
                        return BooleanConverter.getBoolean((Integer)object);
                    }
                    if (object instanceof Long) {
                        return BooleanConverter.getBoolean((Long)object);
                    }
                    if (object instanceof Double) {
                        return BooleanConverter.getBoolean((Double)object);
                    }
                    if (object instanceof BigDecimal) {
                        return BooleanConverter.getBoolean((BigDecimal)object);
                    }
                    throw Trace.error(16);
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (object instanceof String) {
                        return object;
                    }
                    if (object instanceof Time) {
                        return HsqlDateTime.getTimeString((Time)object, null);
                    }
                    if (object instanceof Timestamp) {
                        return HsqlDateTime.getTimestampString((Timestamp)object, null);
                    }
                    if (object instanceof Date) {
                        return HsqlDateTime.getDateString((Date)object, null);
                    }
                    if (!(object instanceof byte[])) break;
                    return StringConverter.byteToHex((byte[])object);
                }
                case 92: {
                    if (object instanceof Time) {
                        return HsqlDateTime.getNormalisedTime((Time)object);
                    }
                    if (object instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedTime((Timestamp)object);
                    }
                    if (object instanceof String) {
                        return HsqlDateTime.timeValue((String)object);
                    }
                    if (!(object instanceof Date)) break;
                    throw Trace.error(95, Types.getTypeString(n));
                }
                case 93: {
                    if (object instanceof Timestamp) {
                        return object;
                    }
                    if (object instanceof Time) {
                        return HsqlDateTime.getNormalisedTimestamp((Time)object);
                    }
                    if (object instanceof Date) {
                        return HsqlDateTime.getNormalisedTimestamp((Date)object);
                    }
                    if (!(object instanceof String)) break;
                    return HsqlDateTime.timestampValue((String)object);
                }
                case 91: {
                    if (object instanceof Date) {
                        return HsqlDateTime.getNormalisedDate((Date)object);
                    }
                    if (object instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedDate((Timestamp)object);
                    }
                    if (object instanceof String) {
                        return HsqlDateTime.dateValue((String)object);
                    }
                    if (!(object instanceof Time)) break;
                    throw Trace.error(95, Types.getTypeString(n));
                }
                case -4: 
                case -3: 
                case -2: {
                    if (object instanceof Binary) {
                        return object;
                    }
                    if (object instanceof byte[]) {
                        return new Binary((byte[])object, false);
                    }
                    if (object instanceof String) {
                        return new Binary(StringConverter.hexToByte((String)object), false);
                    }
                    throw Trace.error(95, Types.getTypeString(n));
                }
                case 1111: {
                    if (object instanceof JavaObject) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new JavaObject(StringConverter.hexToByte((String)object));
                    }
                    if (object instanceof Binary) {
                        return new JavaObject(((Binary)object).getBytes());
                    }
                    return new JavaObject((Serializable)object);
                }
            }
            if (object instanceof JavaObject) {
                object = ((JavaObject)object).getObject();
                return Column.convertObject(object, n);
            }
            return Column.convertString(object.toString(), n);
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Exception exception) {
            throw Trace.error(16, exception.getMessage());
        }
    }

    private static Object convertString(String string, int n) throws HsqlException {
        switch (n) {
            case -6: 
            case 5: {
                return Column.convertObject(string, n);
            }
            case 4: {
                int n2 = Integer.parseInt(string);
                return ValuePool.getInt(n2);
            }
            case -5: {
                return ValuePool.getLong(Long.parseLong(string));
            }
            case 6: 
            case 7: 
            case 8: {
                double d = new Double(string);
                long l = Double.doubleToLongBits(d);
                return ValuePool.getDouble(l);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return string;
            }
            case 91: {
                return HsqlDateTime.dateValue(string);
            }
            case 92: {
                return HsqlDateTime.timeValue(string);
            }
            case 93: {
                return HsqlDateTime.timestampValue(string);
            }
            case 2: 
            case 3: {
                string = Library.trim(string, " ", true, true);
                return new BigDecimal(string);
            }
            case 16: {
                return BooleanConverter.getBoolean(string);
            }
        }
        throw Trace.error(95, Types.getTypeString(n));
    }

    static String createSQLString(Object object, int n) throws HsqlException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.createSQLString(((Number)object).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.toQuotedString(object.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(object instanceof Binary)) {
                    throw Trace.error(95);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((Binary)object).getBytes()), '\'', false);
            }
            case 1111: {
                if (!(object instanceof JavaObject)) {
                    throw Trace.error(18);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((JavaObject)object).getBytes()), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)object);
            }
        }
        return object.toString();
    }

    public static String createSQLString(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(d)) {
            return "0E0/0E0";
        }
        String string = Double.toString(d);
        if (string.indexOf(69) < 0) {
            string = string.concat("E0");
        }
        return string;
    }

    public static String createSQLString(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringConverter.toQuotedString(string, '\'', true);
    }

    static Integer convertToInt(Object object) throws HsqlException {
        int n = ((Number)object).intValue();
        if (object instanceof BigDecimal) {
            BigInteger bigInteger = ((BigDecimal)object).toBigInteger();
            if (bigInteger.compareTo(MAX_INT) > 0 || bigInteger.compareTo(MIN_INT) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getInt(n);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.isNaN(d) || d >= 2.147483648E9 || d <= -2.147483649E9) {
                throw Trace.error(65);
            }
            return ValuePool.getInt(n);
        }
        throw Trace.error(95);
    }

    static Long convertToLong(Object object) throws HsqlException {
        long l = ((Number)object).longValue();
        if (object instanceof BigDecimal) {
            BigInteger bigInteger = ((BigDecimal)object).toBigInteger();
            if (bigInteger.compareTo(MAX_LONG) > 0 || bigInteger.compareTo(MIN_LONG) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getLong(l);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.isNaN(d) || d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
                throw Trace.error(65);
            }
            return ValuePool.getLong(l);
        }
        throw Trace.error(95);
    }

    static Double convertToDouble(Object object) throws HsqlException {
        BigDecimal bigDecimal;
        int n;
        BigDecimal bigDecimal2;
        double d = ((Number)object).doubleValue();
        if (object instanceof BigDecimal && (bigDecimal2 = new BigDecimal(d + (double)(n = (bigDecimal = (BigDecimal)object).signum()))).compareTo(bigDecimal) != n) {
            throw Trace.error(65);
        }
        return ValuePool.getDouble(Double.doubleToLongBits(d));
    }

    static int getCombinedNumberType(int n, int n2, int n3) {
        int n4 = Column.getNumTypeWidth(n);
        int n5 = Column.getNumTypeWidth(n2);
        if (n4 == 16 || n5 == 16) {
            return 8;
        }
        switch (n3) {
            case 14: 
            case 70: {
                return n4 > n5 ? n : n2;
            }
        }
        int n6 = n4 + n5;
        if (n6 <= 4) {
            return 4;
        }
        if (n6 <= 8) {
            return -5;
        }
        return 2;
    }

    private static int getNumTypeWidth(int n) {
        switch (n) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    public static byte[] hexToByteArray(String string) throws HsqlException {
        try {
            return StringConverter.hexToByte(string);
        }
        catch (IOException iOException) {
            throw Trace.error(81);
        }
    }

    static int compareTo(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = 0;
        while (true) {
            int n4 = 0;
            int n5 = 0;
            if (n3 < n) {
                n4 = byArray[n3] & 0xFF;
            } else if (n3 >= n2) {
                return 0;
            }
            if (n3 < n2) {
                n5 = byArray2[n3] & 0xFF;
            }
            if (n4 > n5) {
                return 1;
            }
            if (n5 > n4) {
                return -1;
            }
            ++n3;
        }
    }
}

