/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trigger;
import org.hsqldb.lib.HsqlDeque;

class TriggerDef
extends Thread {
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 12;
    HsqlNameManager.HsqlName name;
    String when;
    String operation;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    protected static int defaultQueueSize = 1024;
    Table table;
    Trigger trig;
    String fire;
    int vectorIndex;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid;
    protected volatile boolean keepGoing = true;

    public static int getDefaultQueueSize() {
        return defaultQueueSize;
    }

    public TriggerDef(HsqlNameManager.HsqlName hsqlName, String string, String string2, boolean bl, Table table, Trigger trigger, String string3, boolean bl2, int n) throws HsqlException {
        this.name = hsqlName;
        this.when = string.toUpperCase();
        this.operation = string2.toUpperCase();
        this.forEachRow = bl;
        this.nowait = bl2;
        this.maxRowsQueued = n;
        this.table = table;
        this.trig = trigger;
        this.fire = string3;
        this.vectorIndex = this.SqlToIndex();
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        this.valid = this.vectorIndex >= 0;
    }

    public StringBuffer getDDL() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("TRIGGER").append(' ');
        stringBuffer.append(this.name.statementName).append(' ');
        stringBuffer.append(this.when).append(' ');
        stringBuffer.append(this.operation).append(' ');
        stringBuffer.append("ON").append(' ');
        stringBuffer.append(this.table.getName().statementName).append(' ');
        if (this.forEachRow) {
            stringBuffer.append("FOR").append(' ');
            stringBuffer.append("EACH").append(' ');
            stringBuffer.append("ROW").append(' ');
        }
        if (this.nowait) {
            stringBuffer.append("NOWAIT").append(' ');
        }
        if (this.maxRowsQueued != TriggerDef.getDefaultQueueSize()) {
            stringBuffer.append("QUEUE").append(' ');
            stringBuffer.append(this.maxRowsQueued).append(' ');
        }
        stringBuffer.append("CALL").append(' ');
        stringBuffer.append(this.fire);
        return stringBuffer;
    }

    public int SqlToIndex() {
        int n = this.operation.equals("INSERT") ? 0 : (this.operation.equals("DELETE") ? 1 : (this.operation.equals("UPDATE") ? 2 : -1));
        if (this.when.equals("BEFORE")) {
            n += 3;
        } else if (!this.when.equals("AFTER")) {
            n = -1;
        }
        if (this.forEachRow) {
            n += 6;
        }
        return n;
    }

    public static int indexToRight(int n) {
        switch (n) {
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                return 2;
            }
            case 0: 
            case 3: 
            case 6: 
            case 9: {
                return 4;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                return 8;
            }
        }
        return 0;
    }

    public void run() {
        while (this.keepGoing) {
            TriggerData triggerData = this.popPair();
            if (triggerData == null || triggerData.username == null) continue;
            this.trig.fire(this.vectorIndex, this.name.name, this.table.getName().name, triggerData.oldRow, triggerData.newRow);
        }
    }

    public synchronized void start() {
        if (this.maxRowsQueued != 0) {
            super.start();
        }
    }

    public synchronized void terminate() {
        this.keepGoing = false;
        this.notify();
    }

    synchronized TriggerData popPair() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        if (this.pendingQueue.size() == 0) {
            return null;
        }
        return (TriggerData)this.pendingQueue.removeFirst();
    }

    synchronized void pushPair(Session session, Object[] objectArray, Object[] objectArray2) {
        if (this.maxRowsQueued == 0) {
            this.trig.fire(this.vectorIndex, this.name.name, this.table.getName().name, objectArray, objectArray2);
            return;
        }
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(new TriggerData(session, objectArray, objectArray2));
        this.notify();
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public boolean isValid() {
        return this.valid;
    }

    class TriggerData {
        public Object[] oldRow;
        public Object[] newRow;
        public String username;

        public TriggerData(Session session, Object[] objectArray, Object[] objectArray2) {
            this.oldRow = objectArray;
            this.newRow = objectArray2;
            this.username = session.getUsername();
        }
    }
}

