/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$ReadWriteCache == null ? (class$net$sf$hibernate$cache$ReadWriteCache = ReadWriteCache.class$("net.sf.hibernate.cache.ReadWriteCache")) : class$net$sf$hibernate$cache$ReadWriteCache));
    private Cache cache;
    private int nextLockId;
    static /* synthetic */ Class class$net$sf$hibernate$cache$ReadWriteCache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    private int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cache lookup: " + key));
        }
        try {
            boolean gettable;
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            boolean bl = gettable = lockable != null && lockable.isGettable(txTimestamp);
            if (gettable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cache hit: " + key));
                }
                Object object = ((Item)lockable).getValue();
                return object;
            }
            if (log.isTraceEnabled()) {
                if (lockable == null) {
                    log.trace((Object)("Cache miss: " + key));
                } else {
                    log.trace((Object)("Cached item was locked: " + key));
                }
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheConcurrencyStrategy.SoftLock lock(Object key) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidating: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            long timeout = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
            Lock lock = lockable == null ? new Lock(timeout, this.nextLockId()) : lockable.lock(timeout, this.nextLockId());
            this.cache.put(key, lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(Object key, Object value, long txTimestamp) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caching: " + key));
        }
        try {
            boolean puttable;
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            boolean bl = puttable = lockable == null || lockable.isPuttable(txTimestamp);
            if (puttable) {
                this.cache.put(key, new Item(value, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cached: " + key));
                }
                boolean bl2 = true;
                return bl2;
            }
            if (log.isTraceEnabled()) {
                if (lockable.isLock()) {
                    log.trace((Object)("Item was locked: " + key));
                } else {
                    log.trace((Object)("Item was already cached: " + key));
                }
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    private void decrementLock(Object key, Lock lock) throws CacheException {
        lock.unlock(this.cache.nextTimestamp());
        this.cache.put(key, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Releasing: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                this.decrementLock(key, (Lock)lockable);
            } else {
                this.handleLockExpiry(key);
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    void handleLockExpiry(Object key) throws CacheException {
        log.warn((Object)("An item was expired by the cache while it was locked (increase your cache timeout): " + key));
        long ts = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(ts, this.nextLockId());
        lock.unlock(ts);
        this.cache.put(key, lock);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterUpdate(Object key, Object value, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                Lock lock = (Lock)lockable;
                if (lock.wasLockedConcurrently()) {
                    this.decrementLock(key, lock);
                } else {
                    this.cache.put(key, new Item(value, this.cache.nextTimestamp()));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Updated: " + key));
                    }
                }
            } else {
                this.handleLockExpiry(key);
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterInsert(Object key, Object value) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (lockable == null) {
                this.cache.put(key, new Item(value, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Inserted: " + key));
                }
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    public void evict(Object key) throws CacheException {
    }

    public void insert(Object key, Object value) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
    }

    private boolean isUnlockable(CacheConcurrencyStrategy.SoftLock clientLock, Lockable myLock) throws CacheException {
        return myLock != null && myLock.isLock() && clientLock != null && ((Lock)clientLock).getId() == ((Lock)myLock).getId();
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        if (minimalPuts) {
            throw new HibernateException("minimal puts not supported for read-write cache");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    CacheConcurrencyStrategy.SoftLock {
        private long unlockTimestamp = -1L;
        private int mutiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;

        public Lock(long timeout, int id) {
            this.timeout = timeout;
            this.id = id;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        public Lock lock(long timeout, int id) {
            this.concurrentLock = true;
            ++this.mutiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long currentTimestamp) {
            if (--this.mutiplicity == 0) {
                this.unlockTimestamp = currentTimestamp;
            }
        }

        public boolean isPuttable(long txTimestamp) {
            return this.mutiplicity == 0 && this.unlockTimestamp < txTimestamp || this.timeout < txTimestamp;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        public boolean isLock() {
            return true;
        }

        public boolean isGettable(long txTimestamp) {
            return false;
        }

        public int getId() {
            return this.id;
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private long freshTimestamp;
        private Object value;

        public Item(Object value, long currentTimestamp) {
            this.value = value;
            this.freshTimestamp = currentTimestamp;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public Lock lock(long timeout, int id) {
            return new Lock(timeout, id);
        }

        public boolean isLock() {
            return false;
        }

        public boolean isGettable(long txTimestamp) {
            return this.freshTimestamp < txTimestamp;
        }

        public boolean isPuttable(long txTimestamp) {
            return false;
        }
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1);
    }
}

