/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq;

import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.ActiveMQConnection;
import org.codehaus.activemq.ActiveMQConnectionFactory;
import org.codehaus.activemq.ActiveMQQueueSession;
import org.codehaus.activemq.ActiveMQTopicSession;
import org.codehaus.activemq.ActiveMQXASession;
import org.codehaus.activemq.message.ResponseReceipt;
import org.codehaus.activemq.message.XATransactionInfo;
import org.codehaus.activemq.transport.TransportChannel;

public class ActiveMQXAConnection
extends ActiveMQConnection
implements XATopicConnection,
XAQueueConnection,
XAConnection {
    private static final Log log;
    private final String resourceManagerId = this.determineResourceManagerId();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActiveMQXAConnection(ActiveMQConnectionFactory factory, String theUserName, String thePassword, TransportChannel transportChannel) throws JMSException {
        super(factory, theUserName, thePassword, transportChannel);
    }

    public ActiveMQXAConnection(ActiveMQConnectionFactory factory, String theUserName, String thePassword) throws JMSException {
        super(factory, theUserName, thePassword);
    }

    private String determineResourceManagerId() throws JMSException {
        XATransactionInfo info = new XATransactionInfo();
        info.setId(this.packetIdGenerator.generateId());
        info.setType(113);
        ResponseReceipt receipt = (ResponseReceipt)this.syncSendRequest(info);
        String rmId = (String)((Object)receipt.getResult());
        if (!$assertionsDisabled && rmId == null) {
            throw new AssertionError();
        }
        return rmId;
    }

    public XASession createXASession() throws JMSException {
        return this.createActiveMQXASession(0);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQQueueSession(this.createActiveMQXASession(acknowledgeMode));
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new ActiveMQTopicSession(this.createActiveMQXASession(acknowledgeMode));
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createActiveMQXASession(acknowledgeMode);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        return this.createActiveMQXASession(0);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        return this.createActiveMQXASession(0);
    }

    protected ActiveMQXASession createActiveMQXASession(int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.sendConnectionInfoToBroker();
        return new ActiveMQXASession(this, acknowledgeMode);
    }

    public String getResourceManagerId() {
        return this.resourceManagerId;
    }

    static {
        $assertionsDisabled = !ActiveMQXAConnection.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)ActiveMQXAConnection.class);
    }
}

