/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.activemq.journal.InvalidRecordLocationException;
import org.codehaus.activemq.journal.impl.BatchedWrite;
import org.codehaus.activemq.journal.impl.Mark;
import org.codehaus.activemq.journal.impl.RecordHeader;
import org.codehaus.activemq.journal.impl.RecordLocationImpl;
import org.codehaus.activemq.journal.impl.Segment;

public final class LogFile {
    public static final byte DATA_RECORD_TYPE = 1;
    public static final byte MARK_RECORD_TYPE = 2;
    private static final NumberFormat onlineLogNameFormat = NumberFormat.getNumberInstance();
    private final File logDirectory;
    private final int initialSegmentSize;
    private boolean closed;
    private final Segment[] segments;
    private final LinkedList activeSegments = new LinkedList();
    private final LinkedList inactiveSegments = new LinkedList();
    private byte markSegment = (byte)-1;
    private final Mark lastMark = new Mark();
    private byte appendSegment = (byte)-1;
    private int lastSegmentId = -1;

    public LogFile(File logDirectory) throws IOException {
        this(logDirectory, 4, 0x500000);
    }

    public LogFile(File logDirectory, int onlineSegmentCount, int initialSegmentSize) throws IOException {
        this.logDirectory = logDirectory;
        this.segments = new Segment[onlineSegmentCount];
        this.initialSegmentSize = initialSegmentSize;
        this.initialize();
    }

    private void initialize() throws IOException {
        Segment segment;
        byte i;
        if (!this.logDirectory.exists() && !this.logDirectory.mkdirs()) {
            throw new IOException("Could not create directory: " + this.logDirectory);
        }
        byte lastIndex = (byte)(this.segments.length - 1);
        int lastSegmentId = 0;
        Mark mark = null;
        for (i = 0; i < this.segments.length; i = (byte)(i + 1)) {
            this.segments[i] = new Segment(new File(this.logDirectory, "log-" + onlineLogNameFormat.format(i) + ".dat"), this.initialSegmentSize, i);
            if (!this.segments[i].isActive()) continue;
            if (this.segments[i].getLastMark().sequenceId >= 0L) {
                this.markSegment = i;
                mark = this.segments[i].getLastMark();
            }
            if (this.segments[i].getId() <= lastSegmentId) continue;
            lastSegmentId = this.segments[i].getId();
            lastIndex = i;
        }
        i = this.nextSegmentIndex(lastIndex);
        while (this.inactiveSegments.size() + this.activeSegments.size() < this.segments.length) {
            segment = this.segments[i];
            if (segment.isActive()) {
                this.activeSegments.add(segment);
            } else {
                this.inactiveSegments.add(segment);
            }
            i = this.nextSegmentIndex(i);
        }
        if (mark != null) {
            this.setMark(mark);
        }
        if (this.activeSegments.size() == 0) {
            this.activateNextSegment();
        } else {
            Segment lastSegment = (Segment)this.activeSegments.getLast();
            lastSegment.setReadOnly(false);
            this.appendSegment = lastSegment.getIndex();
            Iterator iter = this.activeSegments.iterator();
            while (iter.hasNext()) {
                Segment s = (Segment)iter.next();
                if (s == lastSegment) continue;
                s.setReadOnly(true);
            }
        }
        if (mark == null) {
            segment = (Segment)this.activeSegments.getFirst();
            mark = new Mark();
            mark.sequenceId = segment.getIndex();
            mark.offsetId = 256;
        }
        this.lastMark.copy(mark);
    }

    private int getNextSegmentId() {
        return ++this.lastSegmentId;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].close();
        }
    }

    private void setMark(Mark mark) throws IOException {
        this.lastMark.copy(mark);
        Iterator i = this.activeSegments.iterator();
        while (i.hasNext()) {
            Segment segment = (Segment)i.next();
            if (segment.getLastSequenceId() < this.lastMark.sequenceId) {
                segment.reinitialize();
                i.remove();
                this.inactiveSegments.add(segment);
                continue;
            }
            this.markSegment = segment.getIndex();
            break;
        }
    }

    public void appendAndForce(BatchedWrite write) throws IOException {
        Segment segment = this.segments[this.appendSegment];
        segment.seek(segment.getAppendOffset());
        segment.write(write);
        if (write.getMark() != null) {
            this.setMark(write.getMark());
        }
        segment.force();
    }

    private RecordInfo readRecordInfo(RecordLocationImpl location) throws IOException, InvalidRecordLocationException {
        if (0 > location.getSegmentIndex() || location.getSegmentIndex() > this.segments.length) {
            throw new InvalidRecordLocationException("Invalid segment id.");
        }
        Segment segment = this.segments[location.getSegmentIndex()];
        segment.seek(location.getSegmentOffset());
        if (segment.isAtAppendOffset()) {
            throw new InvalidRecordLocationException("No record at end of log.");
        }
        try {
            RecordHeader header = new RecordHeader();
            segment.readRecordHeader(header);
            return new RecordInfo(location, header);
        }
        catch (IOException e) {
            throw new InvalidRecordLocationException("No record at found.");
        }
    }

    public RecordLocationImpl readRecordLocation(RecordLocationImpl location) throws IOException, InvalidRecordLocationException {
        RecordInfo info = this.readRecordInfo(location);
        return info.location.setSequence(((RecordInfo)info).header.sequenceId);
    }

    public RecordLocationImpl getNextDataRecordLocation(RecordLocationImpl lastLocation) throws IOException, InvalidRecordLocationException {
        RecordInfo ri = this.readRecordInfo(lastLocation);
        do {
            byte segmentIndex = ri.location.getSegmentIndex();
            int offset = ri.getNextLocation();
            if (offset >= this.segments[segmentIndex].getAppendOffset()) {
                if ((segmentIndex = this.nextActiveSegmentIndex(segmentIndex)) < 0) {
                    return null;
                }
                offset = 256;
            }
            try {
                ri = this.readRecordInfo(ri.location.setSegmentIndexAndOffset(segmentIndex, offset));
            }
            catch (InvalidRecordLocationException e) {
                return null;
            }
        } while (((RecordInfo)ri).header.recordType != 1);
        return ri.location.setSequence(((RecordInfo)ri).header.sequenceId);
    }

    private byte nextActiveSegmentIndex(byte i) {
        byte rc = this.nextSegmentIndex(i);
        return this.segments[rc].isActive() ? rc : (byte)-1;
    }

    private byte nextSegmentIndex(byte i) {
        if ((i = (byte)(i + 1)) < this.segments.length) {
            return i;
        }
        return 0;
    }

    public byte[] readData(int segmentIndex, int segmentOffset) throws IOException {
        if (0 > segmentIndex || segmentIndex > this.segments.length) {
            return null;
        }
        Segment segment = this.segments[segmentIndex];
        segment.seek(segmentOffset);
        if (segment.isAtAppendOffset()) {
            return null;
        }
        RecordHeader header = new RecordHeader();
        segment.readRecordHeader(header);
        byte[] data = new byte[header.length];
        segment.read(data);
        return data;
    }

    public int getInitialSegmentSize() {
        return this.initialSegmentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSegmentIndexActive(byte i) {
        Segment segment = this.segments[i];
        synchronized (segment) {
            return this.segments[i].isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstSequenceIdOfSegementIndex(byte i) {
        Segment segment = this.segments[i];
        synchronized (segment) {
            return this.segments[i].getFirstSequenceId();
        }
    }

    public synchronized boolean canActivateNextSegment() {
        return this.inactiveSegments.size() > 0;
    }

    public byte getFirstActiveSegmentIndex() {
        return ((Segment)this.activeSegments.getFirst()).getIndex();
    }

    void activateNextSegment() throws IOException {
        if (this.appendSegment >= 0) {
            this.segments[this.appendSegment].setReadOnly(true);
        }
        Segment next = (Segment)this.inactiveSegments.removeFirst();
        this.activeSegments.addLast(next);
        next.activate(this.getNextSegmentId());
        this.appendSegment = next.getIndex();
    }

    public byte getAppendSegmentIndex() {
        return this.appendSegment;
    }

    public int getAppendSegmentOffset() {
        return this.segments[this.appendSegment].getAppendOffset();
    }

    int getTotalSegements() {
        return this.segments.length;
    }

    public long getLastSequenceId() {
        return this.segments[this.appendSegment].getLastSequenceId();
    }

    public synchronized RecordLocationImpl getFirstRecordLocationOfSecondActiveSegment(byte fm) {
        return ((Segment)this.activeSegments.get(1)).getFirstRecordLocation(fm);
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public RecordLocationImpl getLastMarkedRecordLocation(byte fm) {
        if (this.markSegment == -1) {
            return null;
        }
        return new RecordLocationImpl(fm, this.markSegment, this.lastMark.offsetId, this.lastMark.sequenceId);
    }

    static {
        onlineLogNameFormat.setMinimumIntegerDigits(3);
        onlineLogNameFormat.setMaximumIntegerDigits(3);
        onlineLogNameFormat.setGroupingUsed(false);
        onlineLogNameFormat.setParseIntegerOnly(true);
        onlineLogNameFormat.setMaximumFractionDigits(0);
    }

    public static class RecordInfo {
        private final RecordLocationImpl location;
        private final RecordHeader header;

        public RecordInfo(RecordLocationImpl location, RecordHeader header) {
            this.location = location;
            this.header = header;
        }

        int getNextLocation() {
            return this.location.getSegmentOffset() + this.header.length + 35;
        }
    }
}

