/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.service.impl.PersistenceAdapterSupport;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.jdbc.JDBCAdapter;
import org.codehaus.activemq.store.jdbc.JDBCMessageStore;
import org.codehaus.activemq.store.jdbc.JDBCPreparedTransactionStore;
import org.codehaus.activemq.store.jdbc.JDBCTopicMessageStore;
import org.codehaus.activemq.store.jdbc.TransactionContext;
import org.codehaus.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.codehaus.activemq.util.FactoryFinder;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class JDBCPersistenceAdapter
extends PersistenceAdapterSupport {
    private static final Log log = LogFactory.getLog((Class)JDBCPersistenceAdapter.class);
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/codehaus/activemq/store/jdbc/");
    private WireFormat wireFormat = new DefaultWireFormat();
    private DataSource dataSource;
    private JDBCAdapter adapter;
    private String adapterClass;

    public JDBCPersistenceAdapter() {
    }

    public JDBCPersistenceAdapter(DataSource ds, WireFormat wireFormat) {
        this.dataSource = ds;
        this.wireFormat = wireFormat;
    }

    public Map getInitialDestinations() {
        return null;
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        return new JDBCMessageStore(this, this.adapter, this.wireFormat.copy(), destinationName);
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        return new JDBCTopicMessageStore(this, this.adapter, this.wireFormat.copy(), destinationName);
    }

    public PreparedTransactionStore createPreparedTransactionStore() throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        return new JDBCPreparedTransactionStore(this, this.adapter, this.wireFormat.copy());
    }

    public void beginTransaction() throws JMSException {
        try {
            Connection c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            TransactionContext.pushConnection(c);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to create transaction: " + e, e);
        }
    }

    public void commitTransaction() throws JMSException {
        Connection c = TransactionContext.popConnection();
        if (c == null) {
            log.warn((Object)"Commit while no transaction in progress");
        } else {
            try {
                c.commit();
            }
            catch (SQLException e) {
                throw JMSExceptionHelper.newJMSException("Failed to commit transaction: " + c + ": " + e, e);
            }
            finally {
                try {
                    c.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        Connection c = TransactionContext.popConnection();
        try {
            c.rollback();
        }
        catch (SQLException e) {
            log.warn((Object)("Cannot rollback transaction due to: " + e), (Throwable)e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.beginTransaction();
        Connection c = null;
        try {
            this.adapter = null;
            try {
                c = this.getConnection();
            }
            catch (SQLException e) {
                throw JMSExceptionHelper.newJMSException("Could not get a database connection: " + e, e);
            }
            if (this.adapterClass == null) {
                try {
                    String dirverName = c.getMetaData().getDriverName();
                    dirverName = dirverName.replaceAll("[^a-zA-Z0-9\\-]", "_");
                    log.debug((Object)("Database type: [" + dirverName + "]"));
                    try {
                        this.adapter = (DefaultJDBCAdapter)factoryFinder.newInstance(dirverName);
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Unrecognized database type (" + dirverName + ").  Will use default JDBC implementation."));
                        log.debug((Object)("Reason: " + e), e);
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)("JDBC error occured while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage()));
                    log.debug((Object)("Reason: " + e), (Throwable)e);
                }
            } else {
                try {
                    Class<?> clazz = JDBCPersistenceAdapter.class.getClassLoader().loadClass(this.adapterClass);
                    this.adapter = (DefaultJDBCAdapter)clazz.newInstance();
                }
                catch (Throwable e) {
                    log.warn((Object)("Invalid JDBC adapter class class (" + this.adapterClass + ").  Will use default JDBC implementation."));
                    log.debug((Object)("Reason: " + e), e);
                }
            }
            if (this.adapter == null) {
                this.adapter = new DefaultJDBCAdapter();
            }
            try {
                this.adapter.doCreateTables(c);
            }
            catch (SQLException e) {
                log.warn((Object)("Cannot create tables due to: " + e), (Throwable)e);
            }
            this.adapter.initSequenceGenerator(c);
        }
        finally {
            this.commitTransaction();
        }
    }

    public synchronized void stop() throws JMSException {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public Connection getConnection() throws SQLException {
        Connection answer = TransactionContext.peekConnection();
        if (answer == null) {
            answer = this.dataSource.getConnection();
            answer.setAutoCommit(true);
        }
        return answer;
    }

    public void returnConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        Connection peek = TransactionContext.peekConnection();
        if (peek != connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getAdapterClass() {
        return this.adapterClass;
    }

    public void setAdapterClass(String adapterClass) {
        this.adapterClass = adapterClass;
    }
}

