/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.PasswordDigest;
import com.caucho.http.security.ServletAuthenticator;
import com.caucho.http.session.SessionImpl;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextException;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.BasicPrincipal;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class AbstractAuthenticator
implements ServletAuthenticator {
    static WriteStream dbg = LogStream.open("/caucho.com/http/security/authenticator");
    public static final String LOGIN_NAME = "com.caucho.servlet.login.name";
    protected int principalCacheSize = 4096;
    protected LruCache principalCache;
    protected String passwordDigestName;
    protected PasswordDigest passwordDigest;
    private boolean logoutOnTimeout = true;

    public int getPrincipalCacheSize() {
        return this.principalCacheSize;
    }

    public void setPrincipalCacheSize(int size) {
        this.principalCacheSize = size;
    }

    public String getPasswordDigest() {
        return this.passwordDigestName;
    }

    public void setPasswordDigest(String digest) {
        this.passwordDigestName = digest;
    }

    public boolean getLogoutOnSessionTimeout() {
        return this.logoutOnTimeout;
    }

    public void setLogoutOnSessionTimeout(boolean logout) {
        this.logoutOnTimeout = logout;
    }

    public void init() throws ServletException {
        int p;
        if (this.principalCacheSize > 0) {
            this.principalCache = new LruCache(this.principalCacheSize);
        }
        if (this.passwordDigestName != null && (p = this.passwordDigestName.indexOf(45)) > 0) {
            String algorithm = this.passwordDigestName.substring(0, p);
            String format = this.passwordDigestName.substring(p + 1);
            this.passwordDigest = new PasswordDigest();
            this.passwordDigest.setAlgorithm(algorithm);
            this.passwordDigest.setFormat(format);
            this.passwordDigest.init();
        }
    }

    public Principal login(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String password) throws ServletException {
        Principal principal;
        String newPassword = password;
        if (this.passwordDigest != null) {
            newPassword = this.passwordDigest.getPasswordDigest(request, response, app, user, password);
        }
        if ((principal = this.loginImpl(request, response, app, user, newPassword)) != null) {
            HttpSession session = request.getSession();
            session.setAttribute(LOGIN_NAME, (Object)new LoginPrincipal(principal));
            if (this.principalCache != null) {
                this.principalCache.put(session.getId(), principal);
            }
        }
        return principal;
    }

    protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String user, String password) throws ServletException {
        return null;
    }

    public Principal loginDigest(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String realm, String nonce, String uri, String qop, String nc, String cnonce, byte[] clientDigest) throws ServletException {
        Principal principal = this.loginDigestImpl(request, response, app, user, realm, nonce, uri, qop, nc, cnonce, clientDigest);
        if (principal != null) {
            HttpSession session = request.getSession();
            session.setAttribute(LOGIN_NAME, (Object)new LoginPrincipal(principal));
            if (this.principalCache != null) {
                this.principalCache.put(session.getId(), principal);
            }
        }
        return principal;
    }

    public Principal loginDigestImpl(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String realm, String nonce, String uri, String qop, String nc, String cnonce, byte[] clientDigest) throws ServletException {
        try {
            int i;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] a1 = this.getDigestSecret(request, response, app, user, realm, "MD5");
            if (a1 == null) {
                return null;
            }
            this.digestUpdateHex(digest, a1);
            digest.update((byte)58);
            for (i = 0; i < nonce.length(); ++i) {
                digest.update((byte)nonce.charAt(i));
            }
            if (qop != null) {
                digest.update((byte)58);
                for (i = 0; i < nc.length(); ++i) {
                    digest.update((byte)nc.charAt(i));
                }
                digest.update((byte)58);
                for (i = 0; cnonce != null && i < cnonce.length(); ++i) {
                    digest.update((byte)cnonce.charAt(i));
                }
                digest.update((byte)58);
                for (i = 0; qop != null && i < qop.length(); ++i) {
                    digest.update((byte)qop.charAt(i));
                }
            }
            digest.update((byte)58);
            byte[] a2 = this.digest(request.getMethod() + ":" + uri);
            this.digestUpdateHex(digest, a2);
            byte[] serverDigest = digest.digest();
            if (clientDigest == null || clientDigest.length != serverDigest.length) {
                return null;
            }
            for (int i2 = 0; i2 < clientDigest.length; ++i2) {
                if (serverDigest[i2] == clientDigest[i2]) continue;
                return null;
            }
            return new BasicPrincipal(user);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void digestUpdateHex(MessageDigest digest, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int d1 = b >> 4 & 0xF;
            int d2 = b & 0xF;
            if (d1 < 10) {
                digest.update((byte)(d1 + 48));
            } else {
                digest.update((byte)(d1 + 97 - 10));
            }
            if (d2 < 10) {
                digest.update((byte)(d2 + 48));
                continue;
            }
            digest.update((byte)(d2 + 97 - 10));
        }
    }

    private String digestToString(byte[] digest) {
        if (digest == null) {
            return "null";
        }
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < digest.length; ++i) {
            byte ch = digest[i];
            int d1 = ch >> 4 & 0xF;
            int d2 = ch & 0xF;
            if (d1 < 10) {
                cb.append((char)(d1 + 48));
            } else {
                cb.append((char)(d1 + 97 - 10));
            }
            if (d2 < 10) {
                cb.append((char)(d2 + 48));
                continue;
            }
            cb.append((char)(d2 + 97 - 10));
        }
        return cb.close();
    }

    protected byte[] getDigestSecret(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm, String algorithm) throws ServletException {
        String password = this.getDigestPassword(request, response, application, username, realm);
        if (password == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            String string = username + ":" + realm + ":" + password;
            byte[] data = string.getBytes("UTF8");
            return digest.digest(data);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected byte[] digest(String value) throws ServletException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] data = value.getBytes("UTF8");
            return digest.digest(data);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm) throws ServletException {
        return null;
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        LoginPrincipal login;
        HttpSession session = request.getSession(false);
        Principal user = null;
        if (this.principalCache == null && session != null && (login = (LoginPrincipal)session.getAttribute(LOGIN_NAME)) != null) {
            user = login.getPrincipal();
        }
        if (user != null) {
            return user;
        }
        if (this.principalCache != null) {
            if (session != null) {
                user = (Principal)this.principalCache.get(session.getId());
            } else if (request.getRequestedSessionId() != null) {
                user = (Principal)this.principalCache.get(request.getRequestedSessionId());
            }
        }
        if (user != null) {
            session = request.getSession(true);
            session.setAttribute(LOGIN_NAME, (Object)new LoginPrincipal(user));
            return user;
        }
        user = this.getUserPrincipalImpl(request, application);
        if (user != null) {
            session = request.getSession(true);
            session.setAttribute(LOGIN_NAME, (Object)new LoginPrincipal(user));
            this.principalCache.put(session.getId(), user);
        }
        return user;
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request, ServletContext application) throws ServletException {
        return null;
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user, String role) throws ServletException {
        return false;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) throws ServletException {
        HttpSession session;
        if (request instanceof AbstractRequest) {
            ((AbstractRequest)request).logoutUserPrincipal();
        }
        if ((session = request.getSession(false)) != null) {
            session.removeAttribute(LOGIN_NAME);
        }
        if (request.getRequestedSessionId() != null) {
            this.principalCache.remove(request.getRequestedSessionId());
        }
    }

    void addSingleSignonUser(String sessionId, Principal principal) {
        if (this.principalCache != null) {
            this.principalCache.put(sessionId, principal);
        }
    }

    void removeSingleSignonUser(String sessionId) {
        if (this.principalCache != null) {
            this.principalCache.remove(sessionId);
        }
    }

    public static class LoginPrincipal
    implements HttpSessionBindingListener,
    Serializable {
        private Principal principal;

        public LoginPrincipal() {
        }

        LoginPrincipal(Principal principal) {
            this.principal = principal;
        }

        Principal getPrincipal() {
            return this.principal;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            AbstractAuthenticator auth;
            HttpSession session = event.getSession();
            Application app = (Application)session.getServletContext();
            if (app.getAuthenticator() instanceof AbstractAuthenticator && (auth = (AbstractAuthenticator)app.getAuthenticator()).logoutOnTimeout) {
                auth.addSingleSignonUser(session.getId(), this.principal);
            }
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            HttpSession session = event.getSession();
            Application app = (Application)session.getServletContext();
            if (app.getAuthenticator() instanceof AbstractAuthenticator) {
                AbstractAuthenticator auth = (AbstractAuthenticator)app.getAuthenticator();
                if (auth.logoutOnTimeout) {
                    auth.removeSingleSignonUser(session.getId());
                } else if (!((SessionImpl)session).isValid()) {
                    auth.removeSingleSignonUser(session.getId());
                }
            }
            try {
                SecurityContext.logout();
            }
            catch (SecurityContextException e) {
                dbg.log(e);
            }
        }
    }
}

