/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyMap;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.net.InetAddress;
import java.util.ArrayList;

public class ForbidHost {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/admin");
    static L10N L = new L10N(class$com$caucho$http$security$ForbidHost == null ? (class$com$caucho$http$security$ForbidHost = ForbidHost.class$("com.caucho.http.security.ForbidHost")) : class$com$caucho$http$security$ForbidHost);
    private LongKeyMap forbiddenHosts;
    private ArrayList forbiddenNets;
    static /* synthetic */ Class class$com$caucho$http$security$ForbidHost;

    public void addForbidIP(String addrName) {
        try {
            InetAddress addr = InetAddress.getByName(addrName);
            if (this.forbiddenHosts == null) {
                this.forbiddenHosts = new LongKeyMap();
            }
            this.forbiddenHosts.put(ForbidHost.inetAddressToLong(addr), "true");
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void removeForbidIP(String addrName) {
        try {
            InetAddress addr = InetAddress.getByName(addrName);
            if (this.forbiddenHosts != null) {
                this.forbiddenHosts.remove(ForbidHost.inetAddressToLong(addr));
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void addForbidNet(String netmask) {
        try {
            InetNetwork net = InetNetwork.create(netmask);
            if (net == null) {
                return;
            }
            if (this.forbiddenNets == null) {
                this.forbiddenNets = new ArrayList();
            }
            this.forbiddenNets.add(net);
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void removeForbidNet(String netmask) {
        try {
            InetNetwork net = InetNetwork.create(netmask);
            if (net == null) {
                return;
            }
            if (this.forbiddenNets != null) {
                this.forbiddenNets.remove(net);
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void init() {
    }

    public boolean isForbidden(long addr) {
        if (this.forbiddenHosts != null && this.forbiddenHosts.get(addr) != null) {
            return true;
        }
        if (this.forbiddenNets != null) {
            for (int i = this.forbiddenNets.size(); i >= 0; --i) {
                InetNetwork net = (InetNetwork)this.forbiddenNets.get(i);
                if (!net.isMatch(addr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isForbidden(InetAddress addr) {
        if (this.forbiddenHosts == null && this.forbiddenNets == null) {
            return false;
        }
        long ip = ForbidHost.inetAddressToLong(addr);
        if (this.forbiddenHosts != null && this.forbiddenHosts.get(ip) != null) {
            return true;
        }
        if (this.forbiddenNets != null) {
            for (int i = this.forbiddenNets.size(); i >= 0; --i) {
                InetNetwork net = (InetNetwork)this.forbiddenNets.get(i);
                if (!net.isMatch(ip)) continue;
                return true;
            }
        }
        return false;
    }

    private static long inetAddressToLong(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        long address = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            address = 256L * address + (long)(bytes[i] & 0xFF);
        }
        return address;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

