/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.jsp.JspParser;
import com.caucho.util.DirectoryClassLoader;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;

public class JspCompiler {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp/servlet");
    private String[] jspFiles;
    private Path classDir;
    private Path appDir;

    public JspCompiler(String[] args) {
        int i = 0;
        this.appDir = Vfs.lookup(".");
        while (i < args.length) {
            if (args[i].equals("-app-dir")) {
                this.appDir = Vfs.lookup(args[i + 1]);
                i += 2;
                continue;
            }
            if (!args[i].equals("-class-dir") && !args[i].equals("-d")) break;
            this.classDir = Vfs.lookup(args[i + 1]);
            i += 2;
        }
        this.jspFiles = new String[args.length - i];
        System.arraycopy(args, i, this.jspFiles, 0, args.length - i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws Exception {
        ClassLoader parent;
        ClassLoader loader = parent = Thread.currentThread().getContextClassLoader();
        if (this.appDir != null) {
            loader = DirectoryClassLoader.create(loader, this.appDir.lookup("WEB-INF/lib"));
            loader = SimpleClassLoader.create(loader, this.appDir.lookup("WEB-INF/classes"), null);
        }
        for (int i = 0; i < this.jspFiles.length; ++i) {
            Path jsp = Vfs.lookup(this.jspFiles[i]);
            JspParser parser = new JspParser();
            parser.setAppDir(this.appDir);
            parser.setClassDir(this.classDir);
            String userPath = jsp.getPath();
            if (userPath.startsWith(this.appDir.getPath())) {
                userPath = userPath.substring(this.appDir.getPath().length());
            }
            String className = JavaCompiler.mangleName(userPath);
            ReadStream is = jsp.openRead();
            try {
                parser.parse(is, userPath, className, jsp.getParent().getPath(), jsp.getParent(), loader);
                continue;
            }
            finally {
                is.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: com.caucho.jsp.JspCompiler [flags] jsp1 jsp2 ...");
            System.out.println(" -app-dir  : The directory root of the web-app.");
            System.out.println(" -class-dir: The working directory to use as output.");
            System.exit(1);
        }
        try {
            new JspCompiler(args).compile();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }
}

