/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.QPageContext;
import com.caucho.util.CharBuffer;
import com.caucho.util.EnumIterator;
import com.caucho.util.L10N;
import com.caucho.util.NullIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.TagSupport;

public class ForEachTag
extends TagSupport
implements IterationTag,
LoopTag,
LoopTagStatus {
    private static L10N L = new L10N(class$com$caucho$jstl$el$ForEachTag == null ? (class$com$caucho$jstl$el$ForEachTag = ForEachTag.class$("com.caucho.jstl.el.ForEachTag")) : class$com$caucho$jstl$el$ForEachTag);
    protected Expr _itemsExpr;
    protected Expr _beginExpr;
    protected Expr _endExpr;
    protected Expr _stepExpr;
    protected String _var;
    protected String _varStatus;
    protected Iterator _iterator;
    protected int _begin;
    protected int _end;
    protected int _step;
    protected Object _current;
    protected int _index;
    protected int _count;
    static /* synthetic */ Class class$com$caucho$jstl$el$ForEachTag;

    public void setItems(Expr items) {
        this._itemsExpr = items;
    }

    public void setBegin(Expr begin) {
        this._beginExpr = begin;
    }

    public void setEnd(Expr end) {
        this._endExpr = end;
    }

    public void setStep(Expr step) {
        this._stepExpr = step;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setVarStatus(String var) {
        this._varStatus = var;
    }

    public int doStartTag() throws JspException {
        this._iterator = null;
        this._index = 0;
        this._count = 0;
        QPageContext pageContext = (QPageContext)this.pageContext;
        this._begin = this._beginExpr != null ? (int)this._beginExpr.evalLong(pageContext) : Integer.MIN_VALUE;
        this._end = this._endExpr != null ? (int)this._endExpr.evalLong(pageContext) : Integer.MAX_VALUE;
        this._step = this._stepExpr != null ? (int)this._stepExpr.evalLong(pageContext) : 0;
        Object items = null;
        if (this._itemsExpr != null) {
            items = this._itemsExpr.evalObject(pageContext);
            this._iterator = ForEachTag.getIterator(items);
            while (this._index < this._begin && this._iterator.hasNext()) {
                ++this._index;
                this._iterator.next();
            }
        } else {
            if (this._beginExpr == null) {
                throw new JspException(L.l("c:forEach must specify `items' or `begin'"));
            }
            if (this._endExpr == null) {
                throw new JspException(L.l("c:forEach must specify `items' or `begin'"));
            }
            this._iterator = new RangeIterator(this._begin, this._end);
            this._end = Integer.MAX_VALUE;
        }
        if (this._varStatus != null) {
            pageContext.setAttribute(this._varStatus, this);
        }
        return this.doAfterBody();
    }

    public int doAfterBody() throws JspException {
        if (this._iterator == null) {
            return 0;
        }
        if (this._iterator.hasNext()) {
            for (int stepCount = this._step <= 0 || this._count == 0 ? 1 : this._step; stepCount > 0; --stepCount) {
                if (!this._iterator.hasNext()) {
                    return 0;
                }
                ++this._index;
                this._current = this._iterator.next();
            }
            ++this._count;
            if (this._var != null) {
                this.pageContext.setAttribute(this._var, this._current);
            }
            if (this._index - 1 <= this._end) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public LoopTagStatus getLoopStatus() {
        return this;
    }

    public Object getCurrent() {
        return this._current;
    }

    public int getIndex() {
        return this._index - 1;
    }

    public int getCount() {
        return this._count;
    }

    public boolean isFirst() {
        return this._count == 1;
    }

    public boolean isLast() {
        if (this._iterator == null || !this._iterator.hasNext()) {
            return true;
        }
        return this._step > 0 && this._step + this._index > this._end;
    }

    public Integer getBegin() {
        if (this._beginExpr != null && this._itemsExpr != null) {
            return new Integer(this._begin);
        }
        return null;
    }

    public Integer getEnd() {
        if (this._endExpr != null && this._itemsExpr != null) {
            return new Integer(this._end);
        }
        return null;
    }

    public Integer getStep() {
        if (this._stepExpr != null) {
            return new Integer(this._step);
        }
        return null;
    }

    public static Iterator getIterator(Object items) throws JspTagException {
        if (items == null) {
            return NullIterator.create();
        }
        if (items instanceof Collection) {
            return ((Collection)items).iterator();
        }
        if (items instanceof Map) {
            return ((Map)items).entrySet().iterator();
        }
        if (items.getClass().isArray()) {
            return new ArrayIterator(items);
        }
        if (items instanceof Iterator) {
            return (Iterator)items;
        }
        if (items instanceof Enumeration) {
            return new EnumIterator((Enumeration)items);
        }
        if (items instanceof String) {
            return new StringIterator((String)items);
        }
        throw new JspTagException(L.l("unknown items value `{0}'", items));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RangeIterator
    implements Iterator {
        private int end;
        private int i;

        RangeIterator(int begin, int end) {
            this.i = begin;
            this.end = end;
        }

        public boolean hasNext() {
            return this.i <= this.end;
        }

        public Object next() {
            if (this.i <= this.end) {
                return new Integer(this.i++);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class StringIterator
    implements Iterator {
        private String value;
        private int length;
        private int i;
        private CharBuffer cb = new CharBuffer();

        StringIterator(String value) {
            this.value = value;
            this.length = value.length();
        }

        public boolean hasNext() {
            return this.i < this.length;
        }

        public Object next() {
            this.cb.clear();
            char ch = '\u0000';
            while (this.i < this.length && (ch = this.value.charAt(this.i)) != ',') {
                this.cb.append(ch);
                ++this.i;
            }
            ++this.i;
            return this.cb.toString();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ArrayIterator
    implements Iterator {
        private Object array;
        private int index;
        private int length;

        ArrayIterator(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        public boolean hasNext() {
            return this.index < this.length;
        }

        public Object next() {
            if (this.index < this.length) {
                return Array.get(this.array, this.index++);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

