/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;

class Node {
    static final int RC_END = 0;
    static final int RC_NULL = 1;
    static final int RC_STRING = 2;
    static final int RC_SET = 3;
    static final int RC_NSET = 4;
    static final int RC_BEG_GROUP = 5;
    static final int RC_END_GROUP = 6;
    static final int RC_GROUP_REF = 7;
    static final int RC_LOOP = 8;
    static final int RC_LOOP_INIT = 9;
    static final int RC_LOOP_SHORT = 10;
    static final int RC_LOOP_UNIQUE = 11;
    static final int RC_LOOP_SHORT_UNIQUE = 12;
    static final int RC_OR = 13;
    static final int RC_OR_UNIQUE = 14;
    static final int RC_POS_PEEK = 15;
    static final int RC_NEG_PEEK = 16;
    static final int RC_WORD = 17;
    static final int RC_NWORD = 18;
    static final int RC_BLINE = 19;
    static final int RC_ELINE = 20;
    static final int RC_BSTRING = 21;
    static final int RC_ESTRING = 22;
    static final int RC_GSTRING = 23;
    static final int RC_STRING_I = 24;
    static final int RC_SET_I = 25;
    static final int RC_NSET_I = 26;
    static final int RC_GROUP_REF_I = 27;
    static final int RC_LEXEME = 28;
    static Node END = new Node(0);
    Node rest = END;
    int code;
    CharBuffer string;
    RegexpSet set;
    int index;
    int min;
    int max;
    Node branch;
    boolean mark;
    boolean printMark;

    Node(int code) {
        this.code = code;
    }

    Node(int code, int index) {
        this(code);
        this.index = index;
    }

    Node(int code, Node branch) {
        this(code);
        this.branch = branch;
    }

    Node(int code, int index, int min, int max) {
        this(code);
        this.index = index;
        this.min = min;
        this.max = max;
    }

    Node(int code, RegexpSet set) {
        this(code);
        this.set = set;
    }

    Node(CharBuffer buf) {
        this(2);
        this.string = buf;
    }

    static Node replaceTail(Node node, Node tail) {
        if (node == null || node.code == 0 || node == tail) {
            return tail;
        }
        if (node.code == 13) {
            node.branch = Node.replaceTail(node.branch, tail);
        }
        node.rest = Node.replaceTail(node.rest, tail);
        return node;
    }

    static Node concat(Node head, Node tail) {
        if (head == null || head.code == 0) {
            return tail;
        }
        Node node = head;
        while (node.rest != null && node.rest.code != 0) {
            node = node.rest;
        }
        node.rest = tail;
        return head;
    }

    public Object clone() {
        Node node = new Node(this.code);
        node.rest = this.rest;
        node.string = this.string;
        node.set = this.set;
        node.index = this.index;
        node.min = this.min;
        node.max = this.max;
        node.branch = this.branch;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.printMark) {
            return "...";
        }
        this.printMark = true;
        try {
            switch (this.code) {
                case 0: {
                    String string = "";
                    return string;
                }
                case 2: {
                    String string = this.string.toString() + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 13: {
                    String string = "(?:" + this.branch + "|" + this.rest + ")";
                    return string;
                }
                case 14: {
                    String string = "(?:" + this.branch + "|!" + this.rest + ")";
                    return string;
                }
                case 22: {
                    String string = "\\Z" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 9: {
                    String string = this.rest.toString();
                    return string;
                }
                case 8: {
                    String string = "(?:" + this.branch + "){" + this.min + "," + this.max + "}" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 11: {
                    String string = "(?:" + this.branch + ")!{" + this.min + "," + this.max + "}" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 5: {
                    String string = "(" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 6: {
                    String string = ")" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 3: {
                    String string = "[" + this.set + "]" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
                case 4: {
                    String string = "[^" + this.set + "]" + (this.rest == null ? "" : this.rest.toString());
                    return string;
                }
            }
            String string = "" + this.code + " " + super.toString();
            return string;
        }
        finally {
            this.printMark = false;
        }
    }

    char charAt(int index) {
        return this.string.charAt(index);
    }
}

