/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.SecurityContextException;
import com.caucho.security.SecurityContextProvider;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.security.Principal;

public class SecurityContext {
    static WriteStream dbg = LogStream.open("/caucho.com/security");
    static L10N L = new L10N("/com/caucho/security/messages");
    private static ThreadLocal providers = new ThreadLocal();

    private SecurityContext() {
    }

    public static Principal getUserPrincipal() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.getUserPrincipal();
        }
        return null;
    }

    public static boolean isUserInRole(String roleName) throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isUserInRole(roleName);
        }
        return false;
    }

    public static void logout() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            provider.logout();
        }
    }

    public static SecurityContextProvider getProvider() {
        return (SecurityContextProvider)providers.get();
    }

    public static void setProvider(SecurityContextProvider provider) {
        providers.set(provider);
    }
}

