/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.el.VariableResolver;
import com.caucho.http.security.AuthenticatorAdapter;
import com.caucho.http.security.ServletAuthenticator;
import com.caucho.java.CompilingClassLoader;
import com.caucho.server.http.Application;
import com.caucho.server.http.Authenticator;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.server.http.ServletServer;
import com.caucho.util.BeanUtil;
import com.caucho.util.DirectoryClassLoader;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.FilePermission;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;

class Configuration {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/server");
    static L10N L = new L10N("com/caucho/server/http/messages");
    static IntMap _classPathElements = new IntMap();
    ClassLoaderContext _context;
    Configuration _parent;
    ServletServer _server;
    RegistryNode _registry;
    HashMap _pathVariables;
    ClassLoader _parentLoader;
    DynamicClassLoader _classLoader;
    ServletAuthenticator _authenticator;
    RegistryNode _authNode;
    String _charEncoding;
    boolean _addWebInfClasses;

    Configuration(ClassLoaderContext context, ClassLoader parentLoader, RegistryNode registry) {
        this._parentLoader = parentLoader;
        this._registry = registry;
        this._context = context;
    }

    void setServer(ServletServer server) {
        this._server = server;
    }

    void setParent(Configuration parent) {
        this._parent = parent;
    }

    void setPathVariables(HashMap vars) {
        this._pathVariables = vars;
    }

    void setAddWebInfClasses(boolean add) {
        this._addWebInfClasses = add;
    }

    public DynamicClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ServletAuthenticator getAuthenticator() {
        return this._authenticator;
    }

    public RegistryNode getAuthNode() {
        return this._authNode;
    }

    private VariableResolver getEnv() {
        return this._context.getEnv();
    }

    DynamicClassLoader configureClassLoaders(Path webInfDir) throws IOException, ServletException {
        RegistryNode node;
        boolean hasWebInfClasses = !this._addWebInfClasses;
        boolean hasWebInfLib = !this._addWebInfClasses;
        ArrayList<RegistryNode> classes = new ArrayList<RegistryNode>();
        ArrayList<FilePermission> permissions = new ArrayList<FilePermission>();
        Iterator iter = this._registry.select("classpath");
        while (iter.hasNext()) {
            RegistryNode node2 = (RegistryNode)iter.next();
            String name = node2.getString();
            if (name == null) continue;
            classes.add(0, node2);
            if (name.equals("WEB-INF/classes") || name.equals("WEB-INF/classes/")) {
                hasWebInfClasses = true;
            }
            if (node2.getString("source", "").startsWith("WEB-INF/classes")) {
                hasWebInfClasses = true;
            }
            if (name.equals("WEB-INF/lib") || name.equals("WEB-INF/lib/")) {
                hasWebInfLib = true;
            }
            Configuration.verifyElements(node2, _classPathElements);
        }
        DynamicClassLoader loader = null;
        if (!hasWebInfLib && webInfDir != null) {
            Path libDir = webInfDir.lookupNative("WEB-INF/lib");
            if (dbg.canWrite()) {
                dbg.log("jar library class loader: " + libDir);
            }
            loader = DirectoryClassLoader.create(this._parentLoader, libDir);
            loader.setNext(this._classLoader);
            this._classLoader = loader;
        }
        iter = classes.iterator();
        while (iter.hasNext()) {
            boolean isLibrary;
            node = (RegistryNode)iter.next();
            String name = node.getString();
            if (name == null) continue;
            Path classesDir = this.lookupPath(name);
            if (classesDir.isFile() && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                if (dbg.canWrite()) {
                    dbg.log("jar class loader: " + classesDir);
                }
                loader = SimpleClassLoader.create(this._parentLoader, new JarPath(classesDir), null);
                loader.setNext(this._classLoader);
                this._classLoader = loader;
                permissions.add(new FilePermission(classesDir.lookup("-").getNativePath(), "read"));
                continue;
            }
            boolean bl = isLibrary = name.equals("WEB-INF/lib") || name.equals("WEB-INF/lib/");
            if (node.getELBoolean("library-dir", isLibrary, this.getEnv())) {
                if (dbg.canWrite()) {
                    dbg.log("jar library class loader: " + classesDir);
                }
                if (node.lookup("source") != null) {
                    throw this.error(node, L.l("<classpath> with library-dir can't have source attribute.  Jar classpath directories can't be automatically compiled."));
                }
                if (node.lookup("compile") != null) {
                    throw this.error(node, L.l("<classpath> with library-dir can't have compile attribute. Jar classpath directories can't be automatically compiled."));
                }
                loader = DirectoryClassLoader.create(this._parentLoader, classesDir);
                loader.setNext(this._classLoader);
                this._classLoader = loader;
                permissions.add(new FilePermission(classesDir.lookup("-").getNativePath(), "read"));
                continue;
            }
            String source = node.getString("source", name);
            boolean compile = node.getBoolean("compile", true);
            if (!compile) {
                loader = SimpleClassLoader.create(this._parentLoader, classesDir, null);
                loader.setNext(this._classLoader);
                this._classLoader = loader;
                permissions.add(new FilePermission(classesDir.lookup("-").getNativePath(), "read"));
                continue;
            }
            Path sourceDir = this.lookupPath(source);
            String encoding = node.getELString("encoding", this._charEncoding, this.getEnv());
            String args = node.getELString("args", null, this.getEnv());
            if (dbg.canWrite()) {
                dbg.log("compiling class loader: " + classesDir + " source=" + sourceDir + " args=" + args);
            }
            loader = CompilingClassLoader.create(this._parentLoader, classesDir, sourceDir, args, encoding);
            loader.setNext(this._classLoader);
            this._classLoader = loader;
            permissions.add(new FilePermission(classesDir.lookup("-").getNativePath(), "read"));
            permissions.add(new FilePermission(sourceDir.lookup("-").getNativePath(), "read"));
        }
        iter = this._registry.select("taglib");
        while (iter.hasNext()) {
            node = (RegistryNode)iter.next();
            String location = node.getELString("taglib-location", null, this.getEnv());
            if (location == null || !location.endsWith(".jar") || webInfDir == null) continue;
            Path jarPath = webInfDir.lookup(location);
            if (dbg.canWrite()) {
                dbg.log("taglib jar: " + jarPath);
            }
            loader = SimpleClassLoader.create(this._parentLoader, new JarPath(jarPath), null);
            loader.setNext(this._classLoader);
            this._classLoader = loader;
        }
        if (!hasWebInfClasses && webInfDir != null) {
            Path classDir = webInfDir.lookupNative("WEB-INF/classes");
            if (dbg.canWrite()) {
                dbg.log("compiling class loader: " + classDir + " source=" + classDir);
            }
            loader = CompilingClassLoader.create(this._parentLoader, classDir, classDir, null);
            loader.setNext(this._classLoader);
            this._classLoader = loader;
        }
        if (this._classLoader == null) {
            this._classLoader = new DynamicClassLoader(this._parentLoader);
        }
        if (this._registry.getELBoolean("servlet-classloader-hack", false, this.getEnv())) {
            this._classLoader.setServletHack(true);
            this._classLoader.addParentPriorityPackage("java.");
            this._classLoader.addParentPriorityPackage("javax.servlet.");
            this._classLoader.addParentPriorityPackage("javax.naming.");
            this._classLoader.addParentPriorityPackage("javax.sql.");
            this._classLoader.addParentPriorityPackage("javax.transaction.");
        }
        for (int i = 0; i < permissions.size(); ++i) {
            this._classLoader.addPermission((Permission)permissions.get(i));
        }
        this._classLoader.init();
        return this._classLoader;
    }

    void configurePostClassLoader() throws Exception {
        if (this._registry == null) {
            return;
        }
        Configuration.configureSystemProperties(this._registry, this.getEnv());
    }

    static void configureSystemProperties(RegistryNode registry, VariableResolver env) throws Exception {
        Iterator iter = registry.select("system-property");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            Iterator subIter = node.iterator();
            while (subIter.hasNext()) {
                RegistryNode subNode = (RegistryNode)subIter.next();
                String name = subNode.getName();
                String value = subNode.getELString(env);
                System.setProperty(name, value);
            }
        }
    }

    void configureAuthenticator(Application app) throws ServletException {
        block9: {
            if (this._registry == null) {
                return;
            }
            this._authNode = this._registry.lookup("authenticator");
            if (this._authNode == null) {
                this._authNode = this._registry.lookup("login-config/authenticator");
            }
            if (this._authNode == null) {
                return;
            }
            if (this._parent != null && this._authNode == this._parent.getAuthNode()) {
                return;
            }
            String authClassName = this._authNode.getString("class-name", this._authNode.getValue());
            if (authClassName == null) {
                return;
            }
            try {
                Object bean = BeanUtil.createBean(this._authNode, this.getEnv(), authClassName);
                if (bean instanceof ServletAuthenticator) {
                    this._authenticator = (ServletAuthenticator)bean;
                    break block9;
                }
                if (bean instanceof Authenticator) {
                    Authenticator a = (Authenticator)bean;
                    this._authenticator = new AuthenticatorAdapter(a, this._registry, app);
                    this._authenticator.init();
                    break block9;
                }
                throw this.error(this._registry, L.l("`{0}' must extend ServletAuthenticator.  Custom authenticators must extend com.caucho.http.security.ServletAuthenticator.", bean));
            }
            catch (Exception e) {
                dbg.log(e);
                throw this.error(this._registry, e);
            }
        }
    }

    Path lookupPath(String path) throws RegistryException {
        return ServletServer.lookupPath(path, this.getEnv());
    }

    static void verifyElements(RegistryNode node, IntMap validElements) throws ServletException {
        Application.verifyElements(node, validElements);
    }

    ServletException error(RegistryNode node, Throwable e) {
        return Application.error(node, e);
    }

    ServletException error(RegistryNode node, String msg) {
        return Application.error(node, msg);
    }

    static {
        _classPathElements.put("source", 1);
        _classPathElements.put("library-dir", 1);
        _classPathElements.put("compile", 1);
        _classPathElements.put("encoding", 1);
        _classPathElements.put("args", 1);
    }
}

