/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.TcpConnection;
import com.caucho.server.http.Application;
import com.caucho.server.http.BadRequestException;
import com.caucho.server.http.BrowserConfig;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.QJniSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;

public class HttpRequest
extends Request {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    private static HashMap sslKeySizes;
    static char[] hostCb;
    static char[] headCb;
    static char[] userAgentCb;
    static CharBuffer http11Cb;
    static CharBuffer http10Cb;
    private CharBuffer virtualHost;
    private String scheme;
    private CharBuffer method;
    private CharBuffer uriHost;
    private CharSegment host;
    private CharBuffer hostBuffer = new CharBuffer();
    private byte[] uri;
    private int uriLength;
    private int urlLengthMax = 8192;
    private CharBuffer protocol;
    private char[] headerBuffer = new char[16384];
    private CharSegment[] headerKeys;
    private CharSegment[] headerValues;
    private int headerCapacity = 256;
    private int headerSize;
    private CharBuffer cb;
    private String cacheQuery;
    private boolean initAttributes;

    HttpRequest(ServletServer server) {
        super(server);
        this.response = new HttpResponse(this);
        this.urlLengthMax = server.getUrlLengthMax();
        this.response.setIgnoreClientDisconnect(server.getIgnoreClientDisconnect());
        this.uri = new byte[this.urlLengthMax];
        this.cb = new CharBuffer();
        this.method = new CharBuffer();
        this.uriHost = new CharBuffer();
        this.protocol = new CharBuffer();
        this.headerCapacity = 256;
        this.headerSize = 0;
        this.headerKeys = new CharSegment[this.headerCapacity];
        this.headerValues = new CharSegment[this.headerCapacity];
        for (int i = 0; i < this.headerCapacity; ++i) {
            this.headerKeys[i] = new CharSegment();
            this.headerValues[i] = new CharSegment();
        }
    }

    public void handleConnection(Connection conn) throws IOException {
        ReadStream is;
        String virtualHost;
        this.setConnection(conn);
        if (dbg.canWrite()) {
            dbg.log(this.dbgId() + "start connection");
        }
        if ((virtualHost = conn.getVirtualHost()) != null && this.virtualHost == null) {
            this.virtualHost = new CharBuffer(virtualHost);
        }
        this.rawStream = is = conn.getReadStream();
        WriteStream os = conn.getWriteStream();
        this.response.init(os);
        if (this.handleRequest()) {
            while (this.handleRequest()) {
            }
        }
        if (dbg.canWrite()) {
            dbg.log(this.dbgId() + "end connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequest() throws IOException {
        try {
            CharSegment host;
            this.start(this.rawStream);
            if (!this.readRequest(this.rawStream)) {
                if (dbg.canWrite()) {
                    dbg.log(this.dbgId() + "read timeout");
                }
                return false;
            }
            if (this.protocol.length() == 0) {
                this.protocol.append("HTTP/0.9");
            }
            if (dbg.canWrite()) {
                dbg.log(this.dbgId() + this.method + " " + new String(this.uri, 0, this.uriLength) + " " + this.protocol);
            }
            this.parseHeaders(this.rawStream);
            if (this.getVersion() >= 257 && this.isForce10()) {
                this.protocol.clear();
                this.protocol.append("HTTP/1.0");
                this.version = 256;
            }
            if ((host = this.getHost()) == null && this.getVersion() >= 257) {
                throw new BadRequestException("HTTP/1.1 requires host");
            }
            if (this.virtualHost != null) {
                host = this.virtualHost;
            }
            this.invocationKey.init(host, this.conn.getLocalPort(), this.uri, this.uriLength, false);
        }
        catch (ClientDisconnectException e) {
            this.response.killCache();
            throw e;
        }
        catch (Throwable e) {
            try {
                this.response.closeConnection();
                if (e instanceof BadRequestException) {
                    this.sendServletError(e);
                } else if (e instanceof ServletException) {
                    this.sendServletError(e);
                } else {
                    this.sendServletError(new BadRequestException(e));
                }
            }
            catch (ClientDisconnectException e1) {
                throw e1;
            }
            catch (Exception e1) {
                dbg.log(e1);
            }
            finally {
                this.response.finish(true);
            }
            return false;
        }
        try {
            Invocation invocation = this.server.getInvocation(this.invocationKey, true, this.isTop(), true, true);
            invocation.service(this, this.response);
        }
        catch (ClientDisconnectException e) {
            this.response.killCache();
            throw e;
        }
        catch (Throwable e) {
            this.response.closeConnection();
            try {
                this.sendServletError(e);
            }
            catch (ClientDisconnectException e1) {
                throw e1;
            }
            catch (Exception e1) {
                dbg.log(e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.response.finish(true);
        }
        if (dbg.canWrite()) {
            dbg.log(this.dbgId() + (this.response.allowKeepalive() ? "keepalive" : "no-keepalive"));
        }
        return this.response.allowKeepalive();
    }

    private boolean isForce10() {
        if (this.getVersion() < 257) {
            return false;
        }
        Application app = this.getApplication();
        if (app == null || !app.hasBrowserMap()) {
            return false;
        }
        CharSegment agent = this.getHeaderBuffer(userAgentCb, userAgentCb.length);
        BrowserConfig browser = null;
        if (agent != null && app != null) {
            browser = app.getBrowser(agent);
        }
        return browser != null && browser.isForce10();
    }

    protected boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    protected void start(ReadStream s) throws IOException {
        super.start(s);
        this.method.clear();
        this.protocol.clear();
        this.uriLength = 0;
        this.cacheQuery = null;
        this.uriHost.clear();
        this.host = null;
        this.headerSize = 0;
        this.initAttributes = false;
    }

    private boolean readRequest(ReadStream s) throws IOException {
        int readLength;
        boolean i = false;
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        if (readOffset >= (readLength = s.getLength())) {
            try {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
            }
            catch (InterruptedIOException e) {
                if (dbg.canWrite()) {
                    dbg.log(this.dbgId() + "keepalive timeout");
                }
                return false;
            }
            readOffset = 0;
        }
        byte ch = readBuffer[readOffset++];
        this.setStartDate();
        this.conn.setAccessTime(this.getDate());
        while (ch == 32 || ch == 9 || ch == 13 || ch == 10) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        char[] buffer = this.method.getBuffer();
        int length = buffer.length;
        int offset = 0;
        while (ch != 32 && ch != 9) {
            if (offset < length) {
                buffer[offset++] = ch >= 97 && ch <= 122 ? (char)(ch + 65 - 97) : (char)ch;
            }
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        this.method.setLength(offset);
        while (ch == 32 || ch == 9) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        byte[] uriBuffer = this.uri;
        int uriLength = 0;
        if (ch != 47) {
            byte ch1;
            while (ch != 47) {
                if (readOffset >= readLength) {
                    readLength = s.fillBuffer();
                    if (readLength < 0) {
                        return false;
                    }
                    readOffset = 0;
                }
                ch = readBuffer[readOffset++];
            }
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    if (ch == 47) {
                        uriBuffer[uriLength++] = ch;
                        this.uriLength = uriLength;
                    }
                    return true;
                }
                readOffset = 0;
            }
            if ((ch1 = readBuffer[readOffset++]) != 47) {
                uriBuffer[uriLength++] = ch;
                ch = ch1;
            } else {
                block14: while (true) {
                    if (readOffset >= readLength) {
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            return true;
                        }
                        readOffset = 0;
                    }
                    ch = readBuffer[readOffset++];
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block14;
                        }
                        case 63: {
                            break block14;
                        }
                        case 47: {
                            break block14;
                        }
                        default: {
                            this.uriHost.append((char)ch);
                            continue block14;
                        }
                    }
                    break;
                }
            }
        }
        block15: while (true) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break block15;
                }
                default: {
                    uriBuffer[uriLength++] = ch;
                    if (readOffset >= readLength) {
                        readOffset = 0;
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            this.uriLength = uriLength;
                            return true;
                        }
                    }
                    ch = readBuffer[readOffset++];
                    continue block15;
                }
            }
            break;
        }
        this.uriLength = uriLength;
        while (ch == 32 || ch == 9) {
            if (readOffset >= readLength) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        buffer = this.protocol.getBuffer();
        length = buffer.length;
        offset = 0;
        while (ch != 32 && ch != 9 && ch != 13 && ch != 10) {
            if (offset < length) {
                buffer[offset++] = ch >= 97 && ch <= 122 ? (char)(ch + 65 - 97) : (char)ch;
            }
            if (readOffset >= readLength) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    this.protocol.setLength(offset);
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        this.protocol.setLength(offset);
        if (offset == 0) {
            this.protocol.append("HTTP/0.9");
            this.version = 9;
        } else if (buffer[offset - 1] == '1' && this.protocol.equals(http11Cb)) {
            this.version = 257;
        } else if (buffer[offset - 1] == '0' && this.protocol.equals(http10Cb)) {
            this.version = 256;
        }
        while (ch != 10) {
            if (readOffset >= readLength) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        s.setOffset(readOffset);
        return true;
    }

    private void parseHeaders(ReadStream s) throws IOException {
        int version = this.getVersion();
        if (version < 256) {
            return;
        }
        if (version < 257) {
            this.response.closeConnection();
        }
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        char[] headerBuffer = this.headerBuffer;
        int headerOffset = 1;
        int headerBufferSize = headerBuffer.length;
        headerBuffer[0] = 122;
        int headerSize = 0;
        this.headerSize = 0;
        CharSegment[] headerKeys = this.headerKeys;
        CharSegment[] headerValues = this.headerValues;
        boolean debug = dbg.canWrite();
        while (true) {
            int ch;
            int keyOffset = headerOffset;
            while (true) {
                if (readOffset >= readLength) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength < 0) {
                        return;
                    }
                }
                if ((ch = readBuffer[readOffset++]) == 10) {
                    s.setOffset(readOffset);
                    return;
                }
                if (ch == 58) break;
                headerBuffer[headerOffset++] = (char)ch;
            }
            while (headerBuffer[headerOffset - 1] == ' ') {
                --headerOffset;
            }
            headerKeys[headerSize].init(headerBuffer, keyOffset, headerOffset - keyOffset);
            do {
                if (readOffset < readLength) continue;
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength >= 0) continue;
                return;
            } while ((ch = readBuffer[readOffset++]) == 32 || ch == 9);
            int valueOffset = headerOffset;
            while (true) {
                if (readOffset >= readLength) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength < 0) break;
                }
                if (ch == 10) {
                    byte ch1 = readBuffer[readOffset];
                    if (ch1 != 32 && ch1 != 9) break;
                    ch = 32;
                    ++readOffset;
                    if (headerBuffer[headerOffset - 1] == '\r') {
                        // empty if block
                    }
                }
                int n = --headerOffset;
                ++headerOffset;
                headerBuffer[n] = (char)ch;
                ch = readBuffer[readOffset++];
            }
            while (headerBuffer[headerOffset - 1] <= ' ') {
                --headerOffset;
            }
            headerValues[headerSize].init(headerBuffer, valueOffset, headerOffset - valueOffset);
            if (debug) {
                dbg.log(this.dbgId() + headerKeys[headerSize] + ": " + headerValues[headerSize]);
            }
            this.headerSize = ++headerSize;
        }
    }

    public CharSegment getMethodBuffer() {
        return this.method;
    }

    CharSegment getHost() {
        if (this.host != null) {
            return this.host;
        }
        this.host = this.uriHost.length() > 0 ? this.uriHost : this.getHeaderBuffer(hostCb, hostCb.length);
        return this.host;
    }

    public byte[] getUriBuffer() {
        return this.uri;
    }

    public int getUriLength() {
        return this.uriLength;
    }

    public boolean isSecure() {
        return this.conn.isSecure() || this.conn.getLocalPort() == 443;
    }

    public CharSegment getProtocolBuffer() {
        return this.protocol;
    }

    public void setHeader(String key, String value) {
        int i;
        int tail = this.headerSize > 0 ? this.headerValues[this.headerSize - 1].getOffset() + this.headerValues[this.headerSize - 1].getLength() : 0;
        for (i = key.length() - 1; i >= 0; --i) {
            this.headerBuffer[tail + i] = key.charAt(i);
        }
        this.headerKeys[this.headerSize].init(this.headerBuffer, tail, key.length());
        tail += key.length();
        for (i = value.length() - 1; i >= 0; --i) {
            this.headerBuffer[tail + i] = value.charAt(i);
        }
        this.headerValues[this.headerSize].init(this.headerBuffer, tail, value.length());
        ++this.headerSize;
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        char[] keyBuf = this.headerBuffer;
        for (int i = this.headerSize - 1; i >= 0; --i) {
            int j;
            CharSegment key = this.headerKeys[i];
            if (key.length() != length) continue;
            int offset = key.getOffset();
            for (j = length - 1; j >= 0; --j) {
                char a = testBuf[j];
                char b = keyBuf[offset + j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j >= 0) continue;
            return this.headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this.headerValues[i];
        }
        return null;
    }

    public void getHeaderBuffers(ArrayList values, String key) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this.headerValues[i]);
        }
    }

    public Enumeration getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this.headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this.headerSize;
        int length = key.length();
        char[] keyBuf = this.headerBuffer;
        while (i < size) {
            CharSegment header = this.headerKeys[i];
            if (header.length() == length) {
                int j;
                int offset = header.getOffset();
                for (j = 0; j < length; ++j) {
                    char b;
                    char a = key.charAt(j);
                    if (a == (b = keyBuf[offset + j])) continue;
                    if (a >= 'A' && a <= 'Z') {
                        a = (char)(a + 32);
                    }
                    if (b >= 'A' && b <= 'Z') {
                        b = (char)(b + 32);
                    }
                    if (a != b) break;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this.headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    public String getServerName() {
        CharSegment host = this.getHost();
        if (host == null) {
            InetAddress addr = this.conn.getLocalAddress();
            return addr.getHostName();
        }
        int p = host.indexOf(':');
        if (p >= 0) {
            return host.substring(0, p);
        }
        return host.toString();
    }

    public int getServerPort() {
        return this.conn.getLocalPort();
    }

    public String getRemoteAddr() {
        InetAddress addr = this.conn.getRemoteAddress();
        return addr.getHostAddress();
    }

    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        if (!(this.conn instanceof TcpConnection)) {
            return super.printRemoteAddr(buffer, offset);
        }
        QSocket socket = ((TcpConnection)this.conn).getSocket();
        if (socket instanceof QJniSocket) {
            QJniSocket jniSocket = (QJniSocket)socket;
            long ip = jniSocket.getRemoteIP();
            for (int i = 24; i >= 0; i -= 8) {
                int value = (int)(ip >> i) & 0xFF;
                if (value < 10) {
                    buffer[offset++] = (byte)(value + 48);
                } else if (value < 100) {
                    buffer[offset++] = (byte)(value / 10 + 48);
                    buffer[offset++] = (byte)(value % 10 + 48);
                } else {
                    buffer[offset++] = (byte)(value / 100 + 48);
                    buffer[offset++] = (byte)(value / 10 % 10 + 48);
                    buffer[offset++] = (byte)(value % 10 + 48);
                }
                if (i == 0) continue;
                buffer[offset++] = 46;
            }
        } else {
            InetAddress addr = this.conn.getRemoteAddress();
            byte[] bytes = addr.getAddress();
            for (int i = 0; i < bytes.length; ++i) {
                int value;
                if (i != 0) {
                    buffer[offset++] = 46;
                }
                if ((value = bytes[i] & 0xFF) < 10) {
                    buffer[offset++] = (byte)(value + 48);
                    continue;
                }
                if (value < 100) {
                    buffer[offset++] = (byte)(value / 10 + 48);
                    buffer[offset++] = (byte)(value % 10 + 48);
                    continue;
                }
                buffer[offset++] = (byte)(value / 100 + 48);
                buffer[offset++] = (byte)(value / 10 % 10 + 48);
                buffer[offset++] = (byte)(value % 10 + 48);
            }
        }
        return offset;
    }

    public String getRemoteHost() {
        QSocket socket;
        if (this.conn instanceof TcpConnection && (socket = ((TcpConnection)this.conn).getSocket()) instanceof QJniSocket) {
            QJniSocket jniSocket = (QJniSocket)socket;
            long ip = jniSocket.getRemoteIP();
            CharBuffer cb = CharBuffer.allocate();
            for (int i = 24; i >= 0; i -= 8) {
                int value = (int)(ip >> i) & 0xFF;
                if (value < 10) {
                    cb.append((char)(value + 48));
                } else if (value < 100) {
                    cb.append((char)(value / 10 + 48));
                    cb.append((char)(value % 10 + 48));
                } else {
                    cb.append((char)(value / 100 + 48));
                    cb.append((char)(value / 10 % 10 + 48));
                    cb.append((char)(value % 10 + 48));
                }
                if (i == 0) continue;
                cb.append('.');
            }
            return cb.close();
        }
        InetAddress addr = this.conn.getRemoteAddress();
        byte[] bytes = addr.getAddress();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            if (i != 0) {
                cb.append('.');
            }
            if (value < 10) {
                cb.append((char)(value + 48));
                continue;
            }
            if (value < 100) {
                cb.append((char)(value / 10 + 48));
                cb.append((char)(value % 10 + 48));
                continue;
            }
            cb.append((char)(value / 100 + 48));
            cb.append((char)(value / 10 % 10 + 48));
            cb.append((char)(value % 10 + 48));
        }
        return cb.toString();
    }

    public Object getAttribute(String name) {
        if (!this.initAttributes) {
            this.initAttributes();
        }
        return super.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.initAttributes) {
            this.initAttributes();
        }
        return super.getAttributeNames();
    }

    public String findSessionIdFromConnection() {
        if (!this.isSecure() || !(this.conn instanceof TcpConnection)) {
            return null;
        }
        TcpConnection tcpConn = (TcpConnection)this.conn;
        QSocket socket = tcpConn.getSocket();
        return null;
    }

    public ReadStream getRawInput() {
        return this.rawStream;
    }

    private void initAttributes() {
        this.initAttributes = true;
        if (!this.isSecure() || !(this.conn instanceof TcpConnection)) {
            return;
        }
        TcpConnection tcpConn = (TcpConnection)this.conn;
        QSocket socket = tcpConn.getSocket();
        String cipherSuite = socket.getCipherSuite();
        super.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
        int keySize = socket.getCipherBits();
        if (keySize != 0) {
            super.setAttribute("javax.servlet.request.key_size", new Integer(keySize));
        }
        try {
            X509Certificate[] certs = socket.getClientCertificates();
            if (certs != null && certs.length > 0) {
                super.setAttribute("javax.servlet.request.X509Certificate", certs);
                super.setAttribute("com.caucho.servlet.login.name", certs[0].getSubjectDN());
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    void setSecure(boolean secure) {
        this.bogusSecure = secure;
    }

    String dbgId() {
        if (this.server != null) {
            return "[" + this.server.getServerId() + ", " + this.conn.getId() + "] ";
        }
        return "[null, " + this.conn.getId() + "] ";
    }

    static {
        hostCb = "Host".toCharArray();
        headCb = "HEAD".toCharArray();
        userAgentCb = "User-Agent".toCharArray();
        http11Cb = new CharBuffer("HTTP/1.1");
        http10Cb = new CharBuffer("HTTP/1.0");
    }
}

